/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.logging.Loggable;
import com.sun.messaging.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExceptionHandler {
    public static final Logger rootLogger = Logger.getLogger("jakarta.jms");

    public static void handleConnectException(Exception source, String host, int port) throws jakarta.jms.JMSException {
        String info = "[" + host + ":" + port + "]";
        ExceptionHandler.throwConnectionException(source, info);
    }

    public static void handleConnectException(Exception source, String url) throws jakarta.jms.JMSException {
        String info = "[" + url + "]";
        ExceptionHandler.throwConnectionException(source, info);
    }

    private static void throwConnectionException(Exception source, String info) throws jakarta.jms.JMSException {
        if (source instanceof jakarta.jms.JMSException && ((jakarta.jms.JMSException)((Object)source)).getErrorCode() != null) {
            ExceptionHandler.throwJMSException((jakarta.jms.JMSException)((Object)source));
        }
        String errorString0 = AdministeredObject.cr.getKString("C4003", info);
        String errorString = AdministeredObject.cr.getString("C4038", errorString0, source.toString());
        JMSException jmse = new JMSException(errorString, "C4003");
        if (rootLogger.isLoggable(Level.WARNING) && ExceptionHandler.shouldLog((Exception)((Object)jmse))) {
            rootLogger.log(Level.WARNING, errorString);
        }
        jmse.setLinkedException(source);
        ExceptionHandler.throwJMSException(jmse);
    }

    public static void handleException(Exception source, String errorCode) throws jakarta.jms.JMSException {
        if (source instanceof jakarta.jms.JMSException && ((jakarta.jms.JMSException)((Object)source)).getErrorCode() != null) {
            ExceptionHandler.throwJMSException((jakarta.jms.JMSException)((Object)source));
        }
        ExceptionHandler.handleException(source, ExceptionHandler.getJMSException(source, errorCode));
    }

    public static void handleException(Exception source, jakarta.jms.JMSException target) throws jakarta.jms.JMSException {
        target.setLinkedException(source);
        if (Debug.debug) {
            ExceptionHandler.printStackTrace(source);
        }
        ExceptionHandler.throwJMSException(target);
    }

    public static void printStackTrace(Exception e) {
        Debug.printStackTrace(e);
    }

    static String getExceptionErrorString(Exception source, String errorCode) {
        return source == null ? AdministeredObject.cr.getKString(errorCode) : ExceptionHandler.getExceptionMessage(source, errorCode);
    }

    public static jakarta.jms.JMSException getJMSException(Exception source, String errorCode) {
        String errorString = ExceptionHandler.getExceptionErrorString(source, errorCode);
        return new JMSException(errorString, errorCode);
    }

    public static String getExceptionMessage(Exception source, String errorCode) {
        block3: {
            block2: {
                if (errorCode == null) break block2;
                if (!Objects.equals(errorCode, "C4038")) break block3;
            }
            return "[" + "C4038" + "]: " + source.toString();
        }
        String errorString0 = AdministeredObject.cr.getKString(errorCode);
        return AdministeredObject.cr.getString("C4038", errorString0, source.toString());
    }

    public static void throwJMSException(jakarta.jms.JMSException jmse) throws jakarta.jms.JMSException {
        ExceptionHandler.throwJMSException(Level.WARNING, jmse);
    }

    public static void throwJMSException(Level level, jakarta.jms.JMSException jmse) throws jakarta.jms.JMSException {
        try {
            if (ExceptionHandler.shouldLog((Exception)((Object)jmse))) {
                Exception source = jmse.getLinkedException();
                if (source != null) {
                    ExceptionHandler.logCaughtException(level, source);
                }
                rootLogger.log(Level.FINER, "I501", jmse);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw jmse;
    }

    public static void throwJMSRuntimeException(JMSRuntimeException jmsre) {
        ExceptionHandler.throwJMSRuntimeException(Level.WARNING, jmsre);
    }

    public static void throwJMSRuntimeException(Level level, JMSRuntimeException jmsre) {
        try {
            if (ExceptionHandler.shouldLog((Exception)jmsre)) {
                Throwable source = jmsre.getCause();
                if (source != null) {
                    ExceptionHandler.logCaughtException(level, source);
                }
                rootLogger.log(Level.FINER, "I501", (Throwable)jmsre);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw jmsre;
    }

    private static boolean shouldLog(Exception e) {
        boolean isLoggable = true;
        if (e instanceof Loggable) {
            if (((Loggable)((Object)e)).getLogState()) {
                isLoggable = false;
            } else {
                ((Loggable)((Object)e)).setLogState(true);
            }
        }
        return isLoggable;
    }

    public static void logCaughtException(Throwable source) {
        ExceptionHandler.logCaughtException(Level.WARNING, source);
    }

    public static void logCaughtException(Level level, Throwable throwable) {
        if (throwable != null && rootLogger.isLoggable(level)) {
            String msg = AdministeredObject.cr.getKString("I500", throwable.toString());
            rootLogger.log(level, msg);
        }
    }

    public static void logError(Throwable thrown) {
        if (thrown != null && rootLogger.isLoggable(Level.SEVERE)) {
            String msg = thrown.toString();
            rootLogger.log(Level.SEVERE, msg, thrown);
        }
    }

    public static void throwRemoteAcknowledgeException(jakarta.jms.JMSException source, String errorCode) throws jakarta.jms.JMSException {
        String errorString = AdministeredObject.cr.getKString(errorCode);
        JMSException newjmse = new JMSException(errorString, errorCode);
        if (source != null) {
            newjmse.setLinkedException((Exception)((Object)source));
        }
        ExceptionHandler.throwJMSException(newjmse);
    }
}

