/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging.jul;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.eclipse.persistence.logging.jul.EclipseLinkLogRecord;

public class LogFormatter
extends SimpleFormatter {
    private static final String CONNECTION_STRING = "Connection";
    private static final String THREAD_STRING = "Thread";
    Date dat = new Date();
    private static final String format = "{0,date} {0,time}";
    private MessageFormat formatter;
    private final Object[] args = new Object[1];
    private final String lineSeparator = System.lineSeparator();

    @Override
    public synchronized String format(LogRecord record0) {
        if (!(record0 instanceof EclipseLinkLogRecord)) {
            return super.format(record0);
        }
        EclipseLinkLogRecord record = (EclipseLinkLogRecord)record0;
        StringBuilder sb = new StringBuilder();
        if (record.shouldPrintDate()) {
            this.dat.setTime(record.getMillis());
            this.args[0] = this.dat;
            StringBuffer text = new StringBuffer();
            if (this.formatter == null) {
                this.formatter = new MessageFormat(format);
            }
            this.formatter.format(this.args, text, (FieldPosition)null);
            sb.append(text);
            sb.append(" ");
        }
        if (record.getSourceClassName() != null) {
            sb.append(record.getSourceClassName());
        } else {
            sb.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sb.append(" ");
            sb.append(record.getSourceMethodName());
        }
        if (record.getSessionString() != null) {
            sb.append(" ");
            sb.append(record.getSessionString());
        }
        if (record.getConnectionId() != null) {
            sb.append(" ");
            sb.append("Connection(").append(record.getConnectionId()).append(")");
        }
        if (record.shouldPrintThread()) {
            sb.append(" ");
            sb.append("Thread(").append(record.getThreadID()).append(")");
        }
        sb.append(this.lineSeparator);
        String message = this.formatMessage(record);
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(message);
        sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                if (record.getLevel().intValue() == Level.SEVERE.intValue()) {
                    record.getThrown().printStackTrace(pw);
                } else if (record.getLevel().intValue() <= Level.WARNING.intValue()) {
                    if (record.shouldLogExceptionStackTrace()) {
                        record.getThrown().printStackTrace(pw);
                    } else {
                        pw.write(record.getThrown().toString());
                        pw.write(this.lineSeparator);
                    }
                }
                sb.append(sw);
            }
        }
        return sb.toString();
    }
}

