/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.jms.config.JmsHost;
import com.sun.enterprise.connectors.jms.config.JmsService;
import com.sun.enterprise.connectors.jms.system.ActiveJmsResourceAdapter;
import com.sun.enterprise.connectors.jms.system.MQAddressList;
import com.sun.enterprise.connectors.jms.util.JmsRaUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.resource.spi.ResourceAdapter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jms.admin.cli.CreateJMSDestination;
import org.glassfish.jms.admin.cli.JMSAdminException;
import org.glassfish.jms.admin.cli.MQJMXConnectorInfo;

public abstract class JMSDestination {
    protected static final Logger logger = Logger.getLogger("jakarta.enterprise.system.tools.admin");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJMSDestination.class);
    public static final String JMS_DEST_TYPE_TOPIC = "topic";
    public static final String JMS_DEST_TYPE_QUEUE = "queue";
    public static final String DEFAULT_MAX_ACTIVE_CONSUMERS = "-1";
    public static final String MAX_ACTIVE_CONSUMERS_ATTRIBUTE = "MaxNumActiveConsumers";
    public static final String MAX_ACTIVE_CONSUMERS_PROPERTY = "maxNumActiveConsumers";
    public static final String JMXSERVICEURLLIST = "JMXServiceURLList";
    public static final String JMXCONNECTORENV = "JMXConnectorEnv";
    protected static final String MBEAN_DOMAIN_NAME = "com.sun.messaging.jms.server";
    protected static final String DESTINATION_MANAGER_CONFIG_MBEAN_NAME = "com.sun.messaging.jms.server:type=DestinationManager,subtype=Config";
    protected static final String CLUSTER_CONFIG_MBEAN_NAME = "com.sun.messaging.jms.server:type=Cluster,subtype=Config";
    protected static final String DESTINATION_TYPE_QUEUE = "q";
    protected static final String DESTINATION_TYPE_TOPIC = "t";

    protected void validateJMSDestName(String destName) {
        if (destName == null || destName.length() <= 0) {
            throw new IllegalArgumentException(localStrings.getLocalString("admin.mbeans.rmb.invalid_jms_destname", destName));
        }
    }

    protected void validateJMSDestType(String destType) {
        if (destType == null || destType.isEmpty()) {
            throw new IllegalArgumentException(localStrings.getLocalString("admin.mbeans.rmb.invalid_jms_desttype", destType));
        }
        if (!JMS_DEST_TYPE_QUEUE.equals(destType) && !JMS_DEST_TYPE_TOPIC.equals(destType)) {
            throw new IllegalArgumentException(localStrings.getLocalString("admin.mbeans.rmb.invalid_jms_desttype", destType));
        }
    }

    protected MQJMXConnectorInfo createMQJMXConnectorInfo(String targetName, Config config, ServerContext serverContext, Domain domain, ConnectorRuntime connectorRuntime) throws ConnectorRuntimeException {
        logger.log(Level.FINE, "createMQJMXConnectorInfo for {0}", targetName);
        try {
            JmsService jmsService = (JmsService)config.getExtensionByType(JmsService.class);
            ActiveJmsResourceAdapter air = this.getMQAdapter(connectorRuntime);
            Class mqRAClassName = air.getResourceAdapter().getClass();
            CommandTarget ctarget = this.getTypeForTarget(targetName);
            if (ctarget == CommandTarget.CLUSTER || ctarget == CommandTarget.CLUSTERED_INSTANCE) {
                logger.log(Level.FINE, "Getting JMX connector for cluster target {0}", targetName);
                return this._getMQJMXConnectorInfoForCluster(targetName, jmsService, mqRAClassName, serverContext);
            }
            logger.log(Level.FINE, "Getting JMX connector for standalone target {0}", targetName);
            return this.createMQJMXConnectorInfo(targetName, jmsService, mqRAClassName, serverContext, config, domain);
        }
        catch (Exception e) {
            throw new ConnectorRuntimeException((Throwable)e);
        }
    }

    private MQJMXConnectorInfo createMQJMXConnectorInfo(String targetName, JmsService jmsService, Class<? extends ResourceAdapter> mqRAClassName, ServerContext serverContext, Config config, Domain domain) throws ConnectorRuntimeException {
        try {
            String adminPassword;
            String adminUserName;
            String connectionURL;
            MQAddressList mqadList = new MQAddressList();
            if (this.getTypeForTarget(targetName) == CommandTarget.DAS) {
                connectionURL = this.getDefaultAddressList(jmsService).toString();
            } else {
                logger.log(Level.FINEST, " _getMQJMXConnectorInfo - standalone JMS service, NOT in DAS");
                JmsService serverJmsService = this.getJmsServiceOfStandaloneServerInstance(targetName, config, domain);
                mqadList.setJmsService(serverJmsService);
                mqadList.setTargetName(targetName);
                mqadList.setup(false);
                connectionURL = mqadList.toString();
            }
            logger.log(Level.FINE, " _getMQJMXConnectorInfo - connection URL {0}", connectionURL);
            JmsHost jmsHost = mqadList.getDefaultJmsHost(jmsService);
            if (jmsHost == null) {
                logger.log(Level.FINE, " _getMQJMXConnectorInfo, using default jms admin user and password ");
                adminUserName = null;
                adminPassword = null;
            } else {
                adminUserName = jmsHost.getAdminUserName();
                adminPassword = JmsRaUtil.getUnAliasedPwd((String)jmsHost.getAdminPassword());
            }
            ResourceAdapter raInstance = this.getConfiguredRA(mqRAClassName, connectionURL, adminUserName, adminPassword);
            String jmxServiceURLList = this.getJmxServiceUrlList(raInstance);
            Map<String, ?> jmxConnectorEnv = this.getJmxConnectorEnv(raInstance);
            logger.log(Level.CONFIG, " _getMQJMXConnectorInfo - jmxServiceURLList {0}", jmxServiceURLList);
            logger.log(Level.CONFIG, " _getMQJMXConnectorInfo - jmxConnectorEnv {0}", jmxConnectorEnv);
            String jmxServiceURL = this.getFirstJMXServiceURL(jmxServiceURLList);
            return new MQJMXConnectorInfo(targetName, ActiveJmsResourceAdapter.getBrokerInstanceName((JmsService)jmsService), jmsService.getType(), jmxServiceURL, jmxConnectorEnv);
        }
        catch (Exception e) {
            throw new ConnectorRuntimeException((Throwable)e);
        }
    }

    private String getJmxServiceUrlList(ResourceAdapter raInstance) {
        String methodName = "getJMXServiceURLList";
        try {
            Method method = raInstance.getClass().getMethod("getJMXServiceURLList", new Class[0]);
            return (String)method.invoke((Object)raInstance, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            logger.log(Level.INFO, "Invocation of getJMXServiceURLList failed, returning null.", e);
            return null;
        }
    }

    private Map<String, ?> getJmxConnectorEnv(ResourceAdapter raInstance) {
        String methodName = "getJMXConnectorEnv";
        try {
            Method method = raInstance.getClass().getMethod("getJMXConnectorEnv", new Class[0]);
            return (Map)method.invoke((Object)raInstance, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            logger.log(Level.INFO, "Invocation of getJMXConnectorEnv failed, returning null.", e);
            return null;
        }
    }

    protected MQJMXConnectorInfo _getMQJMXConnectorInfoForCluster(String target, JmsService jmsService, Class<? extends ResourceAdapter> mqRAClass, ServerContext serverContext) throws ConnectorRuntimeException {
        ResourceAdapter raInstance;
        try {
            String adminPassword;
            String adminUserName;
            MQAddressList list;
            if (jmsService.getType().equalsIgnoreCase("REMOTE")) {
                list = this.getDefaultAddressList(jmsService);
            } else {
                list = new MQAddressList();
                CommandTarget ctarget = this.getTypeForTarget(target);
                if (ctarget == CommandTarget.CLUSTER) {
                    Server[] servers = list.getServersInCluster(target);
                    if (servers != null && servers.length > 0) {
                        list.setInstanceName(servers[0].getName());
                    }
                } else if (ctarget == CommandTarget.CLUSTERED_INSTANCE) {
                    list.setInstanceName(target);
                }
                Map hostMap = list.getResolvedLocalJmsHostsInMyCluster(true);
                if (hostMap.isEmpty()) {
                    String msg = localStrings.getLocalString("mqjmx.no_jms_hosts", "No JMS Hosts Configured");
                    throw new ConnectorRuntimeException(msg);
                }
                for (JmsHost host : hostMap.values()) {
                    list.addMQUrl(host);
                }
            }
            String connectionUrl = list.toString();
            JmsHost jmsHost = list.getDefaultJmsHost(jmsService);
            if (jmsHost == null) {
                logger.log(Level.FINE, " _getMQJMXConnectorInfo, using default jms admin user and password ");
                adminUserName = null;
                adminPassword = null;
            } else {
                adminUserName = jmsHost.getAdminUserName();
                adminPassword = JmsRaUtil.getUnAliasedPwd((String)jmsHost.getAdminPassword());
            }
            raInstance = this.getConfiguredRA(mqRAClass, connectionUrl, adminUserName, adminPassword);
        }
        catch (Exception e) {
            throw new ConnectorRuntimeException((Throwable)e);
        }
        try {
            String jmxServiceURLList = this.getJmxServiceUrlList(raInstance);
            Map<String, ?> jmxConnectorEnv = this.getJmxConnectorEnv(raInstance);
            String jmxServiceURL = this.getFirstJMXServiceURL(jmxServiceURLList);
            return new MQJMXConnectorInfo(target, ActiveJmsResourceAdapter.getBrokerInstanceName((JmsService)jmsService), jmsService.getType(), jmxServiceURL, jmxConnectorEnv);
        }
        catch (Exception e) {
            throw new ConnectorRuntimeException((Throwable)e);
        }
    }

    protected ResourceAdapter getConfiguredRA(Class<? extends ResourceAdapter> mqRAclassname, String connectionURL, String adminuser, String adminpasswd) throws Exception {
        ResourceAdapter raInstance = mqRAclassname.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Method setConnectionURL = mqRAclassname.getMethod("setConnectionURL", String.class);
        setConnectionURL.invoke((Object)raInstance, connectionURL);
        logger.log(Level.FINE, "getConfiguredRA - set connectionURL as {0}", connectionURL);
        if (adminuser != null) {
            Method setAdminUser = mqRAclassname.getMethod("setAdminUsername", String.class);
            setAdminUser.invoke((Object)raInstance, adminuser);
            logger.log(Level.FINE, "getConfiguredRA - set admin user as {0}", adminuser);
        }
        if (adminpasswd != null) {
            Method setAdminPasswd = mqRAclassname.getMethod("setAdminPassword", String.class);
            setAdminPasswd.invoke((Object)raInstance, adminpasswd);
            logger.log(Level.FINE, "getConfiguredRA - set admin passwd");
        }
        return raInstance;
    }

    private JmsService getJmsServiceOfStandaloneServerInstance(String target, Config cfg, Domain domain) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "getJMSServiceOfSI target: {0}", target);
            logger.log(Level.FINE, "cfg " + String.valueOf(cfg));
        }
        JmsService jmsService = (JmsService)cfg.getExtensionByType(JmsService.class);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "jmsservice " + String.valueOf(jmsService));
        }
        return jmsService;
    }

    private String getFirstJMXServiceURL(String jmxServiceURLList) {
        if (jmxServiceURLList == null || jmxServiceURLList.isBlank()) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(jmxServiceURLList, " ");
        return tokenizer.nextToken();
    }

    protected CommandTarget getTypeForTarget(String target) {
        Domain domain = (Domain)Globals.get(Domain.class);
        Config config = domain.getConfigNamed(target);
        if (config != null) {
            return CommandTarget.CONFIG;
        }
        Server targetServer = domain.getServerNamed(target);
        if (targetServer != null) {
            if (targetServer.isDas()) {
                return CommandTarget.DAS;
            }
            return CommandTarget.STANDALONE_INSTANCE;
        }
        Cluster cluster = domain.getClusterNamed(target);
        if (cluster != null) {
            return CommandTarget.CLUSTER;
        }
        return CommandTarget.DAS;
    }

    protected ActiveJmsResourceAdapter getMQAdapter(ConnectorRuntime connectorRuntime) throws Exception {
        String module = "jmsra";
        String loc = ConnectorsUtil.getSystemModuleLocation((String)"jmsra");
        connectorRuntime.createActiveResourceAdapter(loc, "jmsra", null);
        return (ActiveJmsResourceAdapter)ConnectorRegistry.getInstance().getActiveResourceAdapter("jmsra");
    }

    protected MQAddressList getDefaultAddressList(JmsService jmsService) throws Exception {
        MQAddressList list = new MQAddressList(jmsService);
        list.setup(false);
        return list;
    }

    protected final JMSAdminException logAndHandleException(Exception cause, String messageKey) throws JMSAdminException {
        return this.handleException(new Exception(localStrings.getLocalString(messageKey, null), cause));
    }

    protected final JMSAdminException handleException(Exception e) {
        logger.log(Level.WARNING, "Handling exception to be thrown.", e);
        if (e instanceof JMSAdminException) {
            return (JMSAdminException)e;
        }
        String msg = e.getMessage();
        if (msg == null) {
            try (PrintWriter writer = new PrintWriter(new StringWriter());){
                e.printStackTrace(writer);
                JMSAdminException jMSAdminException = new JMSAdminException(writer.toString());
                return jMSAdminException;
            }
        }
        return new JMSAdminException(msg);
    }

    protected AttributeList convertProp2Attrs(Properties destProps) {
        AttributeList destAttrs = new AttributeList();
        String propName = null;
        String propValue = null;
        Enumeration<?> e = destProps.propertyNames();
        while (e.hasMoreElements()) {
            boolean b;
            propName = (String)e.nextElement();
            if (propName.equals("AutoCreateQueueMaxNumActiveConsumers")) {
                destAttrs.add(new Attribute("AutoCreateQueueMaxNumActiveConsumers", Integer.valueOf(destProps.getProperty("AutoCreateQueueMaxNumActiveConsumers"))));
                continue;
            }
            if (propName.equals(MAX_ACTIVE_CONSUMERS_PROPERTY)) {
                destAttrs.add(new Attribute(MAX_ACTIVE_CONSUMERS_ATTRIBUTE, Integer.valueOf(destProps.getProperty(MAX_ACTIVE_CONSUMERS_PROPERTY))));
                continue;
            }
            if (propName.equals(MAX_ACTIVE_CONSUMERS_ATTRIBUTE)) {
                destAttrs.add(new Attribute(MAX_ACTIVE_CONSUMERS_ATTRIBUTE, Integer.valueOf(destProps.getProperty(MAX_ACTIVE_CONSUMERS_ATTRIBUTE))));
                continue;
            }
            if (propName.equals("AutoCreateQueueMaxNumBackupConsumers")) {
                destAttrs.add(new Attribute("AutoCreateQueueMaxNumBackupConsumers", Integer.valueOf(destProps.getProperty("AutoCreateQueueMaxNumBackupConsumers"))));
                continue;
            }
            if (propName.equals("AutoCreateQueues")) {
                b = false;
                propValue = destProps.getProperty("AutoCreateQueues");
                if (propValue.equalsIgnoreCase("true")) {
                    b = true;
                }
                destAttrs.add(new Attribute("AutoCreateQueues", b));
                continue;
            }
            if (propName.equals("AutoCreateTopics")) {
                b = false;
                propValue = destProps.getProperty("AutoCreateTopics");
                if (propValue.equalsIgnoreCase("true")) {
                    b = true;
                }
                destAttrs.add(new Attribute("AutoCreateTopics", b));
                continue;
            }
            if (propName.equals("DMQTruncateBody")) {
                b = false;
                propValue = destProps.getProperty("DMQTruncateBody");
                if (propValue.equalsIgnoreCase("true")) {
                    b = true;
                }
                destAttrs.add(new Attribute("DMQTruncateBody", b));
                continue;
            }
            if (propName.equals("LogDeadMsgs")) {
                b = false;
                propValue = destProps.getProperty("LogDeadMsgs");
                if (propValue.equalsIgnoreCase("true")) {
                    b = true;
                }
                destAttrs.add(new Attribute("LogDeadMsgs", b));
                continue;
            }
            if (propName.equals("MaxBytesPerMsg")) {
                destAttrs.add(new Attribute("MaxBytesPerMsg", Long.valueOf(destProps.getProperty("MaxBytesPerMsg"))));
                continue;
            }
            if (propName.equals("MaxNumMsgs")) {
                destAttrs.add(new Attribute("MaxNumMsgs", Long.valueOf(destProps.getProperty("MaxNumMsgs"))));
                continue;
            }
            if (propName.equals("MaxTotalMsgBytes")) {
                destAttrs.add(new Attribute("MaxTotalMsgBytes", Long.valueOf(destProps.getProperty("MaxTotalMsgBytes"))));
                continue;
            }
            if (propName.equals("NumDestinations")) {
                destAttrs.add(new Attribute("NumDestinations", Integer.valueOf(destProps.getProperty("NumDestinations"))));
                continue;
            }
            if (propName.equals("ConsumerFlowLimit")) {
                destAttrs.add(new Attribute("ConsumerFlowLimit", Long.valueOf(destProps.getProperty("ConsumerFlowLimit"))));
                continue;
            }
            if (propName.equals("LocalDeliveryPreferred")) {
                destAttrs.add(new Attribute("LocalDeliveryPreferred", this.getBooleanValue(destProps.getProperty("LocalDeliveryPreferred"))));
                continue;
            }
            if (propName.equals("ValidateXMLSchemaEnabled")) {
                destAttrs.add(new Attribute("ValidateXMLSchemaEnabled", this.getBooleanValue(destProps.getProperty("ValidateXMLSchemaEnabled"))));
                continue;
            }
            if (propName.equals("UseDMQ")) {
                destAttrs.add(new Attribute("UseDMQ", this.getBooleanValue(destProps.getProperty("UseDMQ"))));
                continue;
            }
            if (propName.equals("LocalOnly")) {
                destAttrs.add(new Attribute("LocalOnly", this.getBooleanValue(destProps.getProperty("LocalOnly"))));
                continue;
            }
            if (propName.equals("ReloadXMLSchemaOnFailure")) {
                destAttrs.add(new Attribute("ReloadXMLSchemaOnFailure", this.getBooleanValue(destProps.getProperty("ReloadXMLSchemaOnFailure"))));
                continue;
            }
            if (propName.equals("MaxNumProducers")) {
                destAttrs.add(new Attribute("MaxNumProducers", Integer.valueOf(destProps.getProperty("MaxNumProducers"))));
                continue;
            }
            if (propName.equals("MaxNumBackupConsumers")) {
                destAttrs.add(new Attribute("MaxNumBackupConsumers", Integer.valueOf(destProps.getProperty("MaxNumBackupConsumers"))));
                continue;
            }
            if (!propName.equals("LimitBehavior")) continue;
            destAttrs.add(new Attribute("LimitBehavior", destProps.getProperty("LimitBehavior")));
        }
        return destAttrs;
    }

    private Boolean getBooleanValue(String propValue) {
        return propValue.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
    }
}

