/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.util.type;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.BooleanType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.ClassType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.DateType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.ErrorType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.FloatingPointType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.IntegralType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.MathType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NullType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NumericType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NumericWrapperClassType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.StringType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.Type;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.WrapperClassType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class TypeTable {
    public static final NullType nullType = new NullType();
    public static final ErrorType errorType = new ErrorType();
    public BooleanType booleanType;
    public IntegralType charType;
    public IntegralType byteType;
    public IntegralType shortType;
    public IntegralType intType;
    public IntegralType longType;
    public FloatingPointType floatType;
    public FloatingPointType doubleType;
    public StringType stringType;
    public MathType bigDecimalType;
    public MathType bigIntegerType;
    protected Model model;
    protected ClassLoader classLoader;
    protected Map types = new HashMap();
    private static Map typeTables = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeTable getInstance(ClassLoader classLoader) {
        Map map = typeTables;
        synchronized (map) {
            TypeTable typeTable = (TypeTable)typeTables.get(classLoader);
            if (typeTable == null) {
                typeTable = new TypeTable(classLoader);
                typeTables.put(classLoader, typeTable);
            }
            return typeTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInstance(ClassLoader classLoader) {
        Map map = typeTables;
        synchronized (map) {
            typeTables.remove(classLoader);
        }
    }

    private TypeTable(ClassLoader classLoader) {
        this.model = Model.RUNTIME;
        this.classLoader = classLoader;
        this.booleanType = new BooleanType();
        this.types.put(this.booleanType.getName(), this.booleanType);
        this.charType = new IntegralType("char", Character.TYPE, 2);
        this.types.put(this.charType.getName(), this.charType);
        this.byteType = new IntegralType("byte", Byte.TYPE, 3);
        this.types.put(this.byteType.getName(), this.byteType);
        this.shortType = new IntegralType("short", Short.TYPE, 4);
        this.types.put(this.shortType.getName(), this.shortType);
        this.intType = new IntegralType("int", Integer.TYPE, 5);
        this.types.put(this.intType.getName(), this.intType);
        this.longType = new IntegralType("long", Long.TYPE, 6);
        this.types.put(this.longType.getName(), this.longType);
        this.floatType = new FloatingPointType("float", Float.TYPE, 7);
        this.types.put(this.floatType.getName(), this.floatType);
        this.doubleType = new FloatingPointType("double", Double.TYPE, 8);
        this.types.put(this.doubleType.getName(), this.doubleType);
        this.stringType = new StringType(this);
        this.types.put(this.stringType.getName(), this.stringType);
        WrapperClassType booleanClassType = new WrapperClassType("java.lang.Boolean", Boolean.class, 11, this.booleanType, this);
        this.types.put(booleanClassType.getName(), booleanClassType);
        NumericWrapperClassType byteClassType = new NumericWrapperClassType("java.lang.Byte", Byte.class, 13, this.byteType, this);
        this.types.put(byteClassType.getName(), byteClassType);
        NumericWrapperClassType shortClassType = new NumericWrapperClassType("java.lang.Short", Short.class, 14, this.shortType, this);
        this.types.put(shortClassType.getName(), shortClassType);
        NumericWrapperClassType intClassType = new NumericWrapperClassType("java.lang.Integer", Integer.class, 15, this.intType, this);
        this.types.put(intClassType.getName(), intClassType);
        NumericWrapperClassType longClassType = new NumericWrapperClassType("java.lang.Long", Long.class, 16, this.longType, this);
        this.types.put(longClassType.getName(), longClassType);
        NumericWrapperClassType charClassType = new NumericWrapperClassType("java.lang.Character", Character.class, 12, this.charType, this);
        this.types.put(charClassType.getName(), charClassType);
        NumericWrapperClassType floatClassType = new NumericWrapperClassType("java.lang.Float", Float.class, 17, this.floatType, this);
        this.types.put(floatClassType.getName(), floatClassType);
        NumericWrapperClassType doubleClassType = new NumericWrapperClassType("java.lang.Double", Double.class, 18, this.doubleType, this);
        this.types.put(doubleClassType.getName(), doubleClassType);
        this.booleanType.setWrapper(booleanClassType);
        this.byteType.setWrapper(byteClassType);
        this.shortType.setWrapper(shortClassType);
        this.intType.setWrapper(intClassType);
        this.longType.setWrapper(longClassType);
        this.charType.setWrapper(charClassType);
        this.floatType.setWrapper(floatClassType);
        this.doubleType.setWrapper(doubleClassType);
        this.bigDecimalType = new MathType("java.math.BigDecimal", BigDecimal.class, 19, this);
        this.types.put(this.bigDecimalType.getName(), this.bigDecimalType);
        this.bigIntegerType = new MathType("java.math.BigInteger", BigInteger.class, 20, this);
        this.types.put(this.bigIntegerType.getName(), this.bigIntegerType);
        DateType dateType = new DateType("java.util.Date", java.util.Date.class, 22, this);
        this.types.put(dateType.getName(), dateType);
        DateType sqldateType = new DateType("java.sql.Date", Date.class, 23, this);
        this.types.put(sqldateType.getName(), sqldateType);
        DateType sqlTimeType = new DateType("java.sql.Time", Time.class, 24, this);
        this.types.put(sqlTimeType.getName(), sqlTimeType);
        DateType sqlTimestampType = new DateType("java.sql.Timestamp", Timestamp.class, 25, this);
        this.types.put(sqlTimestampType.getName(), sqlTimestampType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type checkType(String name) {
        Map map = this.types;
        synchronized (map) {
            Type result = (Type)this.types.get(name);
            if (result == null) {
                try {
                    Class<?> clazz = Class.forName(name, true, this.classLoader);
                    result = new ClassType(name, clazz, this);
                    this.types.put(name, result);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type checkType(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String name = clazz.getName();
        Map map = this.types;
        synchronized (map) {
            Type result = (Type)this.types.get(name);
            if (result == null) {
                result = new ClassType(name, clazz, this);
                this.types.put(name, result);
            }
            return result;
        }
    }

    public Type binaryNumericPromotion(Type left, Type right) {
        if (left instanceof NumericType && right instanceof NumericType) {
            if (left.equals(this.doubleType) || right.equals(this.doubleType)) {
                return this.doubleType;
            }
            if (left.equals(this.floatType) || right.equals(this.floatType)) {
                return this.floatType;
            }
            if (left.equals(this.longType) || right.equals(this.longType)) {
                return this.longType;
            }
            return this.intType;
        }
        return errorType;
    }

    public Type unaryNumericPromotion(Type type) {
        if (type instanceof NumericType) {
            if (type.equals(this.byteType) || type.equals(this.shortType) || type.equals(this.charType)) {
                return this.intType;
            }
            return type;
        }
        return errorType;
    }

    public boolean isNumberType(Type type) {
        Type numberType = this.checkType("java.lang.Number");
        Type characterType = this.checkType("java.lang.Character");
        return type instanceof NumericType || type.isCompatibleWith(numberType) || type.isCompatibleWith(characterType);
    }

    public boolean isIntegralType(Type type) {
        if (type instanceof IntegralType) {
            return true;
        }
        if (type instanceof NumericWrapperClassType) {
            return ((NumericWrapperClassType)type).getPrimitiveType() instanceof IntegralType;
        }
        return false;
    }

    public boolean isFloatingPointType(Type type) {
        if (type instanceof FloatingPointType) {
            return true;
        }
        if (type instanceof NumericWrapperClassType) {
            return ((NumericWrapperClassType)type).getPrimitiveType() instanceof FloatingPointType;
        }
        return false;
    }

    public boolean isDoubleType(Type type) {
        return type.equals(this.doubleType) || type.equals(this.doubleType.getWrapper());
    }

    public boolean isIntType(Type type) {
        return type.equals(this.intType) || type.equals(this.intType.getWrapper());
    }

    public boolean isCharType(Type type) {
        return type.equals(this.charType) || type.equals(this.charType.getWrapper());
    }

    public boolean isBooleanType(Type type) {
        return type.equals(this.booleanType) || type.equals(this.booleanType.getWrapper());
    }

    public boolean isPersistenceCapableType(Type type) {
        return type instanceof ClassType && ((ClassType)type).isPersistenceCapable();
    }

    public boolean isCollectionType(Type type) {
        Type collectionType = this.checkType("java.util.Collection");
        return type instanceof ClassType && type.isCompatibleWith(collectionType);
    }

    public boolean isJavaLangMathType(Type type) {
        Type mathType = this.checkType("java.lang.Math");
        return type instanceof ClassType && type.isCompatibleWith(mathType);
    }

    public Type getSumReturnType(Type type) {
        if (this.isFloatingPointType(type)) {
            return this.doubleType.getWrapper();
        }
        if (this.bigDecimalType.equals(type)) {
            return this.bigDecimalType;
        }
        if (this.bigIntegerType.equals(type)) {
            return this.bigIntegerType;
        }
        if (this.isNumberType(type)) {
            return this.longType.getWrapper();
        }
        return type;
    }

    public Type getAvgReturnType(Type type) {
        if (this.bigDecimalType.equals(type)) {
            return this.bigDecimalType;
        }
        if (this.bigIntegerType.equals(type)) {
            return this.bigIntegerType;
        }
        if (this.isNumberType(type)) {
            return this.doubleType.getWrapper();
        }
        return type;
    }

    public Type getMinMaxReturnType(Type type) {
        if (this.isFloatingPointType(type)) {
            return this.doubleType.getWrapper();
        }
        if (this.isCharType(type)) {
            return this.charType.getWrapper();
        }
        if (this.bigDecimalType.equals(type)) {
            return this.bigDecimalType;
        }
        if (this.bigIntegerType.equals(type)) {
            return this.bigIntegerType;
        }
        if (this.isNumberType(type)) {
            return this.longType.getWrapper();
        }
        return type;
    }
}

