/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.serializers;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.serializers.AbstractSerializer;

public class XMLSerializer
extends AbstractSerializer {
    private static final Map<String, Object> XML_FACTORY_OPTS = Map.of("jakarta.xml.bind.JAXBContextFactory", "org.eclipse.persistence.jaxb.XMLBindingContextFactory");
    JAXBContext context;

    public XMLSerializer() {
    }

    public XMLSerializer(String packageName) {
        try {
            this.context = JAXBContext.newInstance((String)packageName, (ClassLoader)PrivilegedAccessHelper.callDoPrivileged(() -> Thread.currentThread().getContextClassLoader()), XML_FACTORY_OPTS);
        }
        catch (JAXBException exception) {
            throw new RuntimeException(exception);
        }
    }

    public XMLSerializer(JAXBContext context) {
        this.context = context;
    }

    @Override
    public void initialize(Class<?> serializeClass, String serializePackage, Session session) {
        if (this.context == null) {
            if (serializePackage == null) {
                serializePackage = serializeClass.getPackage().getName();
            }
            try {
                this.context = JAXBContext.newInstance((String)serializePackage, (ClassLoader)serializeClass.getClassLoader(), XML_FACTORY_OPTS);
            }
            catch (JAXBException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    @Override
    public Object serialize(Object object, Session session) {
        try {
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            StringWriter writer = new StringWriter();
            marshaller.marshal(object, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Object deserialize(Object xml, Session session) {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            StringReader reader = new StringReader((String)xml);
            return unmarshaller.unmarshal((Reader)reader);
        }
        catch (JAXBException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Class<?> getType() {
        return String.class;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }
}

