/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.descriptors;

import com.sun.jsftemplating.component.factory.ComponentFactory;
import com.sun.jsftemplating.util.Util;
import java.io.Serializable;
import java.util.Formatter;

public class ComponentType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _id = null;
    private String _factoryClass = null;
    private transient ComponentFactory _factory = null;
    private Serializable _extraInfo = null;

    public ComponentType(String id, String factoryClass) {
        if (id == null) {
            throw new NullPointerException("'id' cannot be null!");
        }
        if (factoryClass == null) {
            throw new NullPointerException("'factoryClass' cannot be null!");
        }
        this._id = id;
        this._factoryClass = factoryClass;
    }

    public ComponentType(String id, String factoryClass, Serializable extraInfo) {
        this(id, factoryClass);
        this.setExtraInfo(extraInfo);
    }

    public String getId() {
        return this._id;
    }

    public ComponentFactory getFactory() {
        if (this._factory == null) {
            this._factory = this.createFactory();
        }
        return this._factory;
    }

    protected ComponentFactory createFactory() {
        ComponentFactory factory = null;
        try {
            Class cls = Util.loadClass(this._factoryClass, this);
            factory = (ComponentFactory)cls.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        if (this._extraInfo != null) {
            factory.setExtraInfo(this._extraInfo);
        }
        return factory;
    }

    public void setExtraInfo(Serializable extraInfo) {
        this._extraInfo = extraInfo;
    }

    public Serializable getExtraInfo() {
        return this._extraInfo;
    }

    public String toString() {
        Formatter println = new Formatter();
        println.format("%-30s  %s\n", this._id, this._factoryClass);
        return println.toString();
    }
}

