/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.CDIProvider;
import jakarta.enterprise.inject.spi.Unmanaged;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.logging.WeldSELogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.collections.ImmutableSet;

public class WeldSEProvider
implements CDIProvider {
    private final ComputingCache<String, WeldContainer> containers = ComputingCacheBuilder.newBuilder().setWeakValues().build(new ClassNameToWeldContainer());
    private final Set<String> knownClassNames;

    public WeldSEProvider() {
        ImmutableSet.Builder<String> names = ImmutableSet.builder();
        for (Class<?> clazz = this.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            names.add(clazz.getName());
        }
        names.add(Unmanaged.class.getName());
        names.add(CDI.class.getName());
        this.knownClassNames = names.build();
    }

    @Override
    public CDI<Object> getCDI() {
        List<String> ids = WeldContainer.getRunningContainerIds();
        if (ids.isEmpty()) {
            throw new IllegalStateException("Unable to find running Weld SE container");
        }
        if (ids.size() == 1) {
            return WeldContainer.instance(ids.get(0));
        }
        WeldSELogger.LOG.multipleContainersRunning(ids);
        String caller = this.getCallingClassName();
        if (caller != null) {
            return this.containers.getValue(caller);
        }
        return WeldContainer.instance(ids.get(0));
    }

    @Override
    public int getPriority() {
        return 1;
    }

    private String getCallingClassName() {
        boolean outerSubclassReached = false;
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!this.knownClassNames.contains(element.getClassName())) {
                if (!outerSubclassReached) continue;
                return element.getClassName();
            }
            outerSubclassReached = true;
        }
        return null;
    }

    private static class ClassNameToWeldContainer
    implements Function<String, WeldContainer> {
        private ClassNameToWeldContainer() {
        }

        @Override
        public WeldContainer apply(String callerClassName) {
            List<String> ids = WeldContainer.getRunningContainerIds();
            for (String containerId : ids) {
                Container container = Container.instance(containerId);
                for (Map.Entry<BeanDeploymentArchive, BeanManagerImpl> entry : container.beanDeploymentArchives().entrySet()) {
                    for (String string : entry.getKey().getKnownClasses()) {
                        if (!string.equals(callerClassName)) continue;
                        return WeldContainer.instance(containerId);
                    }
                    for (Class clazz : entry.getKey().getLoadedBeanClasses()) {
                        if (!clazz.getName().equals(callerClassName)) continue;
                        return WeldContainer.instance(containerId);
                    }
                }
            }
            return WeldContainer.instance(ids.get(0));
        }
    }
}

