/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jnosql.jakartapersistence;

import jakarta.data.repository.BasicRepository;
import jakarta.data.repository.CrudRepository;
import jakarta.data.repository.DataRepository;
import jakarta.data.repository.Repository;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.ParameterizedInterfaceModel;
import org.glassfish.main.jnosql.hk2types.GeneralInterfaceModel;
import org.glassfish.main.jnosql.hk2types.Hk2TypesUtil;

public abstract class BaseGlassFishClassScanner {
    private static final System.Logger LOG = System.getLogger(BaseGlassFishClassScanner.class.getName());
    private static final Set<String> STANDARD_INTERFACES = Set.of(BasicRepository.class.getName(), CrudRepository.class.getName(), DataRepository.class.getName());

    protected abstract boolean isSupportedEntityType(GeneralInterfaceModel var1);

    protected abstract String getProviderName();

    protected boolean isEnabled() {
        return true;
    }

    protected Set<Class<?>> findClassesWithAnnotation(Class<?> annotation) {
        if (!this.isEnabled()) {
            return Set.of();
        }
        String annotationClassName = annotation.getName();
        return Hk2TypesUtil.getTypes().getAllTypes().stream().filter(ClassModel.class::isInstance).filter(type -> type.getAnnotation(annotationClassName) != null).map(ClassModel.class::cast).map(Hk2TypesUtil::typeModelToClass).collect(Collectors.toSet());
    }

    protected Stream<Class<?>> repositoriesStream() {
        return this.repositoriesStreamMatching(r -> true);
    }

    protected Stream<Class<?>> repositoriesStreamMatching(Predicate<GeneralInterfaceModel> predicate) {
        if (!this.isEnabled()) {
            return Stream.of(new Class[0]);
        }
        String providerName = this.getProviderName();
        return Hk2TypesUtil.getTypes().getAllTypes().stream().filter(InterfaceModel.class::isInstance).filter(type -> {
            AnnotationModel repositoryAnnotation = type.getAnnotation(Repository.class.getName());
            if (repositoryAnnotation != null) {
                String provider = (String)repositoryAnnotation.getValue("provider", String.class);
                return Objects.equals("", provider) || providerName.equals(provider);
            }
            return false;
        }).map(InterfaceModel.class::cast).map(GeneralInterfaceModel::new).filter(this::doesNotHaveUnsupportedMainEntity).filter(predicate).map(GeneralInterfaceModel::toTypeModel).map(Hk2TypesUtil::typeModelToClass);
    }

    private boolean doesNotHaveUnsupportedMainEntity(GeneralInterfaceModel interf) {
        GeneralInterfaceModel mainEntityType = this.getMainEntityOfInterface(interf);
        return mainEntityType == null || this.isSupportedEntityType(mainEntityType);
    }

    protected boolean isSupportedStandardInterface(GeneralInterfaceModel interf) {
        GeneralInterfaceModel mainEntityType = this.getMainEntityIfSupportedStandardInterface(interf);
        return null != mainEntityType && this.isSupportedEntityType(mainEntityType);
    }

    protected GeneralInterfaceModel getMainEntityIfSupportedStandardInterface(GeneralInterfaceModel interf) {
        if (interf.hasTypeParametersWithUnknownType()) {
            return null;
        }
        GeneralInterfaceModel entityCandidate = this.getMainEntityIfDirectStandardInterface(interf);
        if (entityCandidate != null) {
            return entityCandidate;
        }
        List<GeneralInterfaceModel> entityCandidates = interf.interfacesAsStream().map(this::getMainEntityIfSupportedStandardInterface).filter(Objects::nonNull).distinct().limit(2L).toList();
        return entityCandidates.size() == 1 ? entityCandidates.getFirst() : null;
    }

    protected boolean isNotSupportedStandardInterface(GeneralInterfaceModel intfModel) {
        return !this.isSupportedStandardInterface(intfModel);
    }

    private boolean isDataRepositoryInterface(GeneralInterfaceModel interf) {
        return interf.interfaceName().equals(DataRepository.class.getName());
    }

    private GeneralInterfaceModel getMainEntityIfDirectStandardInterface(GeneralInterfaceModel interf) {
        return STANDARD_INTERFACES.contains(interf.interfaceName()) ? this.getMainEntityOfInterface(interf) : null;
    }

    protected GeneralInterfaceModel getMainEntityOfInterface(GeneralInterfaceModel interf) {
        if (interf.hasTypeParametersWithUnknownType()) {
            return null;
        }
        if (interf.isParameterized()) {
            Collection<ParameterizedInterfaceModel> parameterizedTypes = interf.parametizedTypes();
            return parameterizedTypes.isEmpty() ? null : new GeneralInterfaceModel(parameterizedTypes.iterator().next());
        }
        List<GeneralInterfaceModel> entityCandidates = interf.interfacesAsStream().map(this::getMainEntityOfInterface).filter(Objects::nonNull).distinct().limit(2L).toList();
        return entityCandidates.size() == 1 ? entityCandidates.getFirst() : null;
    }
}

