/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jettison.internal.entity;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.jettison.internal.entity.JettisonLowLevelProvider;
import org.glassfish.jersey.jettison.internal.l10n.LocalizationMessages;
import org.glassfish.jersey.message.internal.ReaderWriter;

public class JettisonObjectProvider
extends JettisonLowLevelProvider<JSONObject> {
    JettisonObjectProvider() {
        super(JSONObject.class);
    }

    public JSONObject readFrom(Class<JSONObject> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            return new JSONObject(ReaderWriter.readFromAsString((InputStream)entityStream, (MediaType)mediaType));
        }
        catch (JSONException je) {
            throw new WebApplicationException((Throwable)new Exception(LocalizationMessages.ERROR_PARSING_JSON_OBJECT(), je), 400);
        }
    }

    public void writeTo(JSONObject t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(entityStream, ReaderWriter.getCharset((MediaType)mediaType));
            t.write((Writer)writer);
            writer.flush();
        }
        catch (JSONException je) {
            throw new WebApplicationException((Throwable)new Exception(LocalizationMessages.ERROR_WRITING_JSON_OBJECT(), je), 500);
        }
    }

    @Produces(value={"*/*"})
    @Consumes(value={"*/*"})
    public static final class General
    extends JettisonObjectProvider {
        @Override
        protected boolean isSupported(MediaType m) {
            return m.getSubtype().endsWith("+json");
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public static final class App
    extends JettisonObjectProvider {
    }
}

