/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.CompoundExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatPipesExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

public final class StringExpressionFactory
extends ExpressionFactory {
    private StringExpressionVisitor visitor;
    public static final String ID = "||";

    public StringExpressionFactory() {
        super(ID, ID);
    }

    private CompoundExpression buildExpression(AbstractExpression parent, String character) {
        if (ID.equals(character)) {
            return new ConcatPipesExpression(parent);
        }
        return null;
    }

    @Override
    protected final AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
        String character = word.substring(0, 1);
        if ("|".equals(character)) {
            character = word.substring(0, 2);
        }
        if (ID.equals(character)) {
            ConcatPipesExpression concatPipesExpression = new ConcatPipesExpression(parent);
            concatPipesExpression.setLeftExpression(expression);
            concatPipesExpression.parse(wordParser, tolerant);
            return concatPipesExpression;
        }
        CompoundExpression compoundExpression = this.buildExpression(parent, character);
        compoundExpression.setLeftExpression(expression);
        compoundExpression.parse(wordParser, tolerant);
        return compoundExpression;
    }

    private StringExpressionVisitor visitor() {
        if (this.visitor == null) {
            this.visitor = new StringExpressionVisitor();
        }
        return this.visitor;
    }

    private static final class StringExpressionVisitor
    extends AbstractExpressionVisitor {
        boolean found;

        private StringExpressionVisitor() {
        }

        @Override
        public void visit(ConcatPipesExpression expression) {
            this.found = true;
        }
    }
}

