/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.gf.ejb.internal;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.InternalInterceptorBindingImpl;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import jakarta.annotation.Priority;
import jakarta.ejb.Singleton;
import jakarta.ejb.Stateful;
import jakarta.ejb.Stateless;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.jersey.gf.ejb.internal.EjbClassUtilities;
import org.glassfish.jersey.gf.ejb.internal.EjbComponentInterceptor;
import org.glassfish.jersey.gf.ejb.internal.EjbExceptionMapper;
import org.glassfish.jersey.gf.ejb.internal.EjbSupplier;
import org.glassfish.jersey.inject.hk2.AbstractBinder;
import org.glassfish.jersey.inject.hk2.Bindings;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.glassfish.jersey.server.spi.internal.ResourceMethodInvocationHandlerProvider;

@Priority(value=300)
public final class EjbComponentProvider
implements ComponentProvider,
ResourceMethodInvocationHandlerProvider {
    private static final Logger LOG = Logger.getLogger(EjbComponentProvider.class.getName());
    private static final String JNDI_JAVA_APP_NAME = "java:app/AppName";
    private static final Set<String> EJB_ANNOTATIONS = Stream.of(Stateful.class, Stateless.class, Singleton.class).map(Class::getName).collect(Collectors.toUnmodifiableSet());
    private final List<String> moduleNames = new CopyOnWriteArrayList<String>();
    private InitialContext initialContext;
    private InjectionManager injectionManager;
    private boolean ejbInterceptorRegistered;

    public void initialize(InjectionManager injectionManager) {
        this.injectionManager = injectionManager;
        this.injectionManager.register(Bindings.service((Object)this).to(ResourceMethodInvocationHandlerProvider.class));
    }

    public boolean bind(Class<?> component, Set<Class<?>> providerContracts) {
        LOG.log(Level.FINE, "Class, {0}, is being checked with Jersey EJB component provider.", component);
        if (this.injectionManager == null) {
            throw new IllegalStateException("EJB component provider has not been initialized properly.");
        }
        if (!this.isEjbComponent(component)) {
            return false;
        }
        if (!this.ejbInterceptorRegistered) {
            this.registerEjbInterceptor(component);
        }
        this.registerBinding(component, providerContracts);
        LOG.log(Level.CONFIG, "Class, {0}, has been bound by Jersey EJB component provider.", component);
        return true;
    }

    public void done() {
        this.injectionManager.register((Binder)new EjbComponentBinder());
    }

    public InvocationHandler create(Invocable method) {
        Class resourceClass = method.getHandler().getHandlerClass();
        if (resourceClass == null || !this.isEjbComponent(resourceClass)) {
            return null;
        }
        Method handlingMethod = method.getDefinitionMethod();
        for (Class<?> iFace : EjbClassUtilities.getRemoteAndLocalIfaces(resourceClass)) {
            try {
                Method iFaceMethod = iFace.getDeclaredMethod(handlingMethod.getName(), handlingMethod.getParameterTypes());
                if (iFaceMethod == null) continue;
                return (target, ignored, args) -> iFaceMethod.invoke(target, args);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                this.logLookupException(handlingMethod, resourceClass, iFace, ex);
            }
        }
        return null;
    }

    public List<String> getModuleNames() {
        return List.copyOf(this.moduleNames);
    }

    private void registerEjbInterceptor(Class<?> component) {
        try {
            this.initialContext = EjbComponentProvider.getInitialContext();
            EjbComponentInterceptor interceptor = new EjbComponentInterceptor(this.injectionManager);
            EjbContainerUtil ejbUtil = EjbContainerUtilImpl.getInstance();
            ApplicationInfo appInfo = this.getApplicationInfo(ejbUtil);
            for (ModuleInfo moduleInfo : appInfo.getModuleInfos()) {
                String fileName = moduleInfo.getName();
                if (!this.isProbableEjbModule(fileName)) continue;
                String moduleName = fileName.substring(0, fileName.length() - 4);
                Object bundleDescriptor = moduleInfo.getMetaData(EjbBundleDescriptorImpl.class.getName());
                if (!(bundleDescriptor instanceof EjbBundleDescriptorImpl)) continue;
                Set ejbs = ((EjbBundleDescriptorImpl)bundleDescriptor).getEjbs();
                for (EjbDescriptor ejb : ejbs) {
                    BaseContainer ejbContainer = EjbContainerUtilImpl.getInstance().getContainer(ejb.getUniqueId());
                    if (ejbContainer.getEJBClass() != component) continue;
                    this.moduleNames.add(moduleName);
                    ejbContainer.registerSystemInterceptor((Object)interceptor);
                }
            }
            InternalInterceptorBindingImpl interceptorBinder = (InternalInterceptorBindingImpl)this.initialContext.lookup("java:org.glassfish.ejb.container.interceptor_binding_spi");
            if (interceptorBinder == null) {
                throw new IllegalStateException("The EJB interceptor binding API is not available. Jersey EJB integration can not be supported.");
            }
            interceptorBinder.registerInterceptor((Object)interceptor);
            this.ejbInterceptorRegistered = true;
            LOG.log(Level.CONFIG, "The Jersey EJB interceptor is bound. Jersey EJB integration support is enabled.");
        }
        catch (NamingException ex) {
            throw new IllegalStateException("The EJB interceptor binding API is not available. Jersey EJB integration can not be supported.", ex);
        }
        catch (LinkageError ex) {
            throw new IllegalStateException("Linkage error when configuring to use the EJB interceptor binding API. Jersey EJB integration can not be supported.", ex);
        }
    }

    private boolean isProbableEjbModule(String jarName) {
        return jarName.endsWith(".jar") || jarName.endsWith(".war");
    }

    private void registerBinding(Class<?> component, Set<Class<?>> providerContracts) {
        EjbSupplier ejbSupplier = new EjbSupplier(component, this.initialContext, this);
        Binding binding = Bindings.supplier(ejbSupplier).to(component).to(providerContracts);
        this.injectionManager.register(binding);
    }

    private ApplicationInfo getApplicationInfo(EjbContainerUtil ejbUtil) throws NamingException {
        ApplicationRegistry appRegistry = (ApplicationRegistry)ejbUtil.getServices().getService(ApplicationRegistry.class, new Annotation[0]);
        Applications applications = (Applications)ejbUtil.getServices().getService(Applications.class, new Annotation[0]);
        String appNamePrefix = (String)this.initialContext.lookup(JNDI_JAVA_APP_NAME);
        Set appNames = appRegistry.getAllApplicationNames();
        TreeSet<String> disabledApps = new TreeSet<String>();
        for (String appName : appNames) {
            if (!appName.startsWith(appNamePrefix)) continue;
            Application appDesc = applications.getApplication(appName);
            if (appDesc != null && !ejbUtil.getDeployment().isAppEnabled(appDesc)) {
                disabledApps.add(appName);
                continue;
            }
            return ejbUtil.getDeployment().get(appName);
        }
        String lastDisabledApp = (String)disabledApps.last();
        if (lastDisabledApp != null) {
            return ejbUtil.getDeployment().get(lastDisabledApp);
        }
        throw new NamingException("Application Information Not Found");
    }

    private boolean isEjbComponent(Class<?> component) {
        for (Annotation a : component.getAnnotations()) {
            if (!EJB_ANNOTATIONS.contains(a.annotationType().getName())) continue;
            return true;
        }
        return false;
    }

    private void logLookupException(Method method, Class<?> component, Class<?> iFace, Exception ex) {
        LOG.log(Level.WARNING, MessageFormat.format("Exception thrown when trying to lookup actual handling method, {0}, for EJB type, {1}, using interface {2}.", method, component, iFace), ex);
    }

    private static InitialContext getInitialContext() {
        try {
            return new InitialContext();
        }
        catch (Exception ex) {
            throw new IllegalStateException("InitialContext not found. Jersey EJB support is not available.", ex);
        }
    }

    private static final class EjbComponentBinder
    extends AbstractBinder {
        private EjbComponentBinder() {
        }

        protected void configure() {
            this.bind(EjbExceptionMapper.class).to(ExceptionMapper.class).in(jakarta.inject.Singleton.class);
        }
    }
}

