/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.config.Config;
import io.helidon.config.ConfigSources;
import io.helidon.config.UrlConfigSource;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigSource;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class MetaConfigFinder {
    public static final String META_CONFIG_SYSTEM_PROPERTY = "io.helidon.config.meta-config";
    public static final String CONFIG_PROFILE_SYSTEM_PROPERTY = "config.profile";
    public static final String HELIDON_CONFIG_PROFILE_SYSTEM_PROPERTY = "helidon.config.profile";
    public static final String CONFIG_PROFILE_ENVIRONMENT_VARIABLE = "HELIDON_CONFIG_PROFILE";
    private static final MediaType UNKNOWN = MediaTypes.create((String)"unknown", (String)"unknown");
    private static final System.Logger LOGGER = System.getLogger(MetaConfigFinder.class.getName());
    private static final List<String> CONFIG_SUFFIXES = List.of("yaml", "conf", "json", "properties");
    private static final String META_CONFIG_PREFIX = "meta-config.";
    private static final String CONFIG_PREFIX = "application.";
    private static final Set<String> FILES_LOGGED = new HashSet<String>();
    private static final Set<String> CLASSPATH_LOGGED = new HashSet<String>();

    private MetaConfigFinder() {
    }

    static Optional<Config> findMetaConfig(Function<MediaType, Boolean> supportedMediaType, List<String> supportedSuffixes) {
        return MetaConfigFinder.findMetaConfigSource(supportedMediaType, supportedSuffixes).map(source -> Config.builder(new Supplier[]{source}).build());
    }

    static Optional<ConfigSource> findConfigSource(Function<MediaType, Boolean> supportedMediaType, List<String> supportedSuffixes) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return MetaConfigFinder.findSource(supportedMediaType, cl, CONFIG_PREFIX, "config source", supportedSuffixes);
    }

    static Optional<String> profile() {
        String profileName = System.getenv(CONFIG_PROFILE_ENVIRONMENT_VARIABLE);
        if (profileName == null) {
            profileName = System.getProperty(HELIDON_CONFIG_PROFILE_SYSTEM_PROPERTY);
        }
        if (profileName == null) {
            profileName = System.getProperty(CONFIG_PROFILE_SYSTEM_PROPERTY);
        }
        return Optional.ofNullable(profileName);
    }

    static List<ConfigSource> configSources(List<String> supportedSuffixes, String profileName) {
        return supportedSuffixes.stream().flatMap(suffix -> MetaConfigFinder.configSources("application-" + profileName + "." + suffix)).collect(Collectors.toUnmodifiableList());
    }

    static List<ConfigSource> configSources(List<String> supportedSuffixes) {
        return supportedSuffixes.stream().flatMap(suffix -> MetaConfigFinder.configSources(CONFIG_PREFIX + suffix)).collect(Collectors.toUnmodifiableList());
    }

    static Stream<ConfigSource> configSources(String fileName) {
        return Stream.concat(MetaConfigFinder.findFile(fileName, "default config source").stream(), MetaConfigFinder.findAllClasspath(fileName));
    }

    private static Stream<ConfigSource> findAllClasspath(String fileName) {
        return ConfigSources.classpathAll(fileName).stream().map(UrlConfigSource.Builder::build);
    }

    private static Optional<ConfigSource> findMetaConfigSource(Function<MediaType, Boolean> supportedMediaType, List<String> supportedSuffixes) {
        Optional<ConfigSource> source;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String metaConfigFile = System.getProperty(META_CONFIG_SYSTEM_PROPERTY);
        String profileName = MetaConfigFinder.profile().orElse(null);
        if (metaConfigFile != null && profileName != null) {
            int lastDot = metaConfigFile.lastIndexOf(46);
            String metaWithProfile = lastDot == 0 ? profileName + metaConfigFile.substring(lastDot) : (lastDot > 0 ? metaConfigFile.substring(0, lastDot) + "-" + profileName + metaConfigFile.substring(lastDot) : metaConfigFile + "-" + profileName);
            source = MetaConfigFinder.findFile(metaWithProfile, "config profile");
            if (source.isPresent()) {
                return source;
            }
            source = MetaConfigFinder.findClasspath(cl, metaWithProfile, "config profile");
            if (source.isPresent()) {
                return source;
            }
            LOGGER.log(System.Logger.Level.INFO, "Custom profile file not found: " + metaWithProfile);
        }
        if (metaConfigFile == null) {
            if (profileName != null) {
                return Optional.of(MetaConfigFinder.profileSource(supportedMediaType, cl, profileName, supportedSuffixes));
            }
        } else {
            source = MetaConfigFinder.findFile(metaConfigFile, "meta configuration");
            if (source.isPresent()) {
                return source;
            }
            source = MetaConfigFinder.findClasspath(cl, metaConfigFile, "meta configuration");
            if (source.isPresent()) {
                return source;
            }
            LOGGER.log(System.Logger.Level.INFO, "Meta configuration file not found: " + metaConfigFile);
        }
        return MetaConfigFinder.findSource(supportedMediaType, cl, META_CONFIG_PREFIX, "meta configuration", supportedSuffixes).or(() -> MetaConfigFinder.findSource(supportedMediaType, cl, "config-profile.", "config profile", supportedSuffixes));
    }

    private static ConfigSource profileSource(Function<MediaType, Boolean> supportedMediaType, ClassLoader cl, String profileName, List<String> supportedSuffixes) {
        Optional<ConfigSource> profile;
        String profileFileName = "config-profile-" + profileName + ".";
        for (String supportedSuffix : supportedSuffixes) {
            profile = MetaConfigFinder.findFile(profileFileName + supportedSuffix, "config profile");
            if (!profile.isPresent()) continue;
            return profile.get();
        }
        for (String supportedSuffix : supportedSuffixes) {
            profile = MetaConfigFinder.findClasspath(cl, profileFileName + supportedSuffix, "config profile");
            if (!profile.isPresent()) continue;
            return profile.get();
        }
        ConfigNode.ListNode.Builder sourceListBuilder = ConfigNode.ListNode.builder();
        sourceListBuilder.addObject(ConfigNode.ObjectNode.builder().addValue("type", "environment-variables").build()).addObject(ConfigNode.ObjectNode.builder().addValue("type", "system-properties").build());
        for (String supportedSuffix : supportedSuffixes) {
            MetaConfigFinder.addFile(sourceListBuilder, "application-" + profileName, supportedSuffix);
        }
        for (String supportedSuffix : supportedSuffixes) {
            MetaConfigFinder.addClasspath(sourceListBuilder, "application-" + profileName, supportedSuffix);
        }
        for (String supportedSuffix : supportedSuffixes) {
            MetaConfigFinder.addFile(sourceListBuilder, "application", supportedSuffix);
        }
        for (String supportedSuffix : supportedSuffixes) {
            MetaConfigFinder.addClasspath(sourceListBuilder, "application", supportedSuffix);
        }
        MetaConfigFinder.addClasspath(sourceListBuilder, "META-INF/microprofile-config-" + profileName, "properties");
        MetaConfigFinder.addClasspath(sourceListBuilder, "META-INF/microprofile-config", "properties");
        return ConfigSources.create(ConfigNode.ObjectNode.builder().addList("sources", (ConfigNode.ListNode)sourceListBuilder.build()).build());
    }

    private static void addClasspath(ConfigNode.ListNode.Builder sourceListBuilder, String fileName, String supportedSuffix) {
        sourceListBuilder.addObject(ConfigNode.ObjectNode.builder().addValue("type", "classpath").addObject("properties", ConfigNode.ObjectNode.builder().addValue("resource", fileName + "." + supportedSuffix).addValue("optional", "true").build()).build());
    }

    private static void addFile(ConfigNode.ListNode.Builder sourceListBuilder, String fileName, String supportedSuffix) {
        sourceListBuilder.addObject(ConfigNode.ObjectNode.builder().addValue("type", "file").addObject("properties", ConfigNode.ObjectNode.builder().addValue("path", fileName + "." + supportedSuffix).addValue("optional", "true").build()).build());
    }

    private static Optional<ConfigSource> findSource(Function<MediaType, Boolean> supportedMediaType, ClassLoader cl, String configPrefix, String type, List<String> supportedSuffixes) {
        HashSet<String> invalidSuffixes = new HashSet<String>(CONFIG_SUFFIXES);
        invalidSuffixes.addAll(supportedSuffixes);
        LinkedHashSet validSuffixes = new LinkedHashSet();
        CONFIG_SUFFIXES.stream().filter(suffix -> (Boolean)supportedMediaType.apply(MediaTypes.detectExtensionType((String)suffix).orElse(UNKNOWN))).forEach(validSuffixes::add);
        supportedSuffixes.stream().filter(suffix -> (Boolean)supportedMediaType.apply(MediaTypes.detectExtensionType((String)suffix).orElse(UNKNOWN))).forEach(validSuffixes::add);
        validSuffixes.forEach(invalidSuffixes::remove);
        Optional<Object> source = validSuffixes.stream().map(suf -> configPrefix + suf).map(it -> MetaConfigFinder.findFile(it, type)).flatMap(Optional::stream).findFirst();
        if (source.isPresent()) {
            return source;
        }
        source = validSuffixes.stream().map(suf -> configPrefix + suf).map(resource -> MetaConfigFinder.findClasspath(cl, resource, type)).flatMap(Optional::stream).findFirst();
        if (source.isPresent()) {
            return source;
        }
        invalidSuffixes.stream().map(suf -> configPrefix + suf).forEach(it -> {
            Optional<ConfigSource> found = MetaConfigFinder.findFile(it, type);
            if (found.isPresent() && FILES_LOGGED.add((String)it)) {
                LOGGER.log(System.Logger.Level.WARNING, "Configuration file " + it + " is on file system, yet there is no parser configured for it");
            }
            if ((found = MetaConfigFinder.findClasspath(cl, it, type)).isPresent() && CLASSPATH_LOGGED.add((String)it)) {
                LOGGER.log(System.Logger.Level.WARNING, "Configuration file " + it + " is on classpath, yet there is no parser configured for it");
            }
        });
        return Optional.empty();
    }

    private static Optional<ConfigSource> findFile(String name, String type) {
        Path path = Paths.get(name, new String[0]);
        if (Files.exists(path, new LinkOption[0]) && Files.isReadable(path) && !Files.isDirectory(path, new LinkOption[0])) {
            LOGGER.log(System.Logger.Level.INFO, "Found " + type + " file: " + String.valueOf(path.toAbsolutePath()));
            return Optional.of(ConfigSources.file(path).build());
        }
        return Optional.empty();
    }

    private static Optional<ConfigSource> findClasspath(ClassLoader cl, String name, String type) {
        URL resource = cl.getResource(name);
        if (null != resource) {
            LOGGER.log(System.Logger.Level.TRACE, "Found " + type + " resource: " + resource.getPath());
            return Optional.of(ConfigSources.classpath(name).build());
        }
        return Optional.empty();
    }
}

