/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.validation;

import org.jboss.logging.processor.validation.AbstractFormatPart;

class MessageFormatPart
extends AbstractFormatPart {
    private final String originalFormat;
    private final int position;
    private int index;
    private String formatType;
    private String formatStyle;

    private MessageFormatPart(int position, String format) {
        this.position = position;
        this.originalFormat = format;
        this.index = 0;
    }

    public static MessageFormatPart of(int position, String format) {
        MessageFormatPart result = new MessageFormatPart(position, format);
        if (format.charAt(0) != '{' || format.charAt(format.length() - 1) != '}') {
            throw new IllegalArgumentException("Format must begin with '{' and end with '}'. Format: " + format);
        }
        String formatText = format.substring(1, format.length() - 1);
        if (formatText.contains("{") || formatText.contains("}")) {
            throw new IllegalArgumentException("String contains an invalid character. Cannot specify either '{' or '}'.");
        }
        result.init(formatText);
        return result;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public String part() {
        return this.originalFormat;
    }

    private void init(String formatText) {
        if (formatText != null && !formatText.trim().isEmpty()) {
            try {
                this.index = Integer.parseInt(formatText.substring(0, 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid index portion of format.", e);
            }
        }
    }
}

