/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.Resources;
import jakarta.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.jdbc.admin.cli.JDBCResourceManager;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.jvnet.hk2.annotations.Service;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.POST, path="execute-jdbc-sql", description="execute-jdbc-sql")})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="execute-jdbc-sql")
@PerLookup
public class ExecuteJdbcSql
implements AdminCommand {
    @Param(optional=true, defaultValue="server")
    private String target;
    @Param
    String sqlFileName;
    @Param(name="jndi_name", primary=true)
    private String jndiName;
    @Inject
    private JDBCResourceManager jdbcResourceManager;

    public void execute(AdminCommandContext context) {
        ResourceStatus resourceStatus;
        ActionReport report = context.getActionReport();
        try {
            resourceStatus = this.jdbcResourceManager.executeSql(this.jndiName, this.sqlFileName);
        }
        catch (Exception e) {
            report.setMessage("Failed to execute SQL against datasource " + this.jndiName);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode exitCode = ActionReport.ExitCode.SUCCESS;
        if (resourceStatus.getMessage() != null) {
            report.setMessage(resourceStatus.getMessage());
        }
        if (resourceStatus.getStatus() == 1) {
            exitCode = ActionReport.ExitCode.FAILURE;
            if (resourceStatus.getException() != null) {
                report.setFailureCause(resourceStatus.getException());
            }
        }
        report.setActionExitCode(exitCode);
    }
}

