/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.manager.ha;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.io.PortMapperTable;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.TakingoverTracker;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.RepHAClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.data.RollbackReason;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.persist.api.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.messaging.jmq.jmsserver.cluster.manager.ha.HAMonitorServiceImpl")
@Singleton
public class HAMonitorServiceImpl
implements HAMonitorService,
ClusterListener {
    private static boolean DEBUG_HA;
    private static boolean DEBUG;
    private Logger logger = Globals.getLogger();
    private static final String MONITOR_THRESHOLD_PROP = "imq.cluster.monitor.threshold";
    private static final String MONITOR_INTERVAL_PROP = "imq.cluster.monitor.interval";
    private int MAX_MONITOR_DEFAULT = 3;
    private int MAX_MONITOR = Globals.getConfig().getIntProperty("imq.cluster.monitor.threshold", this.MAX_MONITOR_DEFAULT);
    public static final int MONITOR_TIMEOUT_DEFAULT = 30;
    private int MONITOR_TIMEOUT = Globals.getConfig().getIntProperty("imq.cluster.monitor.interval", 30) * 1000;
    private int MAX_HEARTBEAT = Globals.getConfig().getIntProperty("imq.cluster.heartbeat.threshold", 30);
    private int reaperTimeout = Globals.getConfig().getIntProperty("imq.cluster.reaptime", 300) * 1000;
    ClusterManager clusterconfig = null;
    String mybrokerid = null;
    private HAMonitorTask haMonitor = null;
    Map indoubtBrokers = Collections.synchronizedMap(new LinkedHashMap());
    private AtomicInteger heartbeatMissedCnt = new AtomicInteger(0);
    FaultInjection fi = null;
    Runnable takeoverRunnable = null;
    boolean takeoverMEInprogress = false;
    Object takeoverRunnableLock = new Object();
    boolean monitorBusy = false;
    private Vector takingoverTargets = new Vector();

    @Override
    public String getRemoteBrokerIDFromPortMapper(String host, int port, String brokerID) {
        try {
            String version = "101\n";
            PortMapperTable pt = new PortMapperTable();
            Socket s = new Socket(host, port);
            InputStream is = s.getInputStream();
            OutputStream os = s.getOutputStream();
            try {
                os.write(version.getBytes());
                os.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            pt.read(is);
            is.close();
            os.close();
            s.close();
            PortMapperEntry pme = pt.get("portmapper");
            return pme.getProperty("brokerid");
        }
        catch (IOException ex) {
            Globals.getLogger().log(4, "Unable to reach old remote broker associated with " + brokerID);
            return null;
        }
    }

    public HAMonitorServiceImpl() {
        DEBUG = DEBUG || this.logger.getLevel() <= 4;
        this.fi = FaultInjection.getInjection();
    }

    public HAMonitorServiceImpl(String clusterid, MQAddress brokerURL, Boolean resetTakeoverThenExitB) throws Exception {
        this.init(clusterid, brokerURL, resetTakeoverThenExitB);
    }

    @Override
    public void init(String clusterid, MQAddress brokerURL, boolean resetTakeoverThenExit) throws Exception {
        DEBUG = DEBUG || this.logger.getLevel() <= 4;
        this.fi = FaultInjection.getInjection();
        this.clusterconfig = Globals.getClusterManager();
        this.clusterconfig.addEventListener(this);
        this.mybrokerid = this.clusterconfig.getLocalBroker().getBrokerName();
        this.logger.logToAll(8, "B1206", this.mybrokerid, brokerURL);
        this.logger.logToAll(8, "imq.cluster.monitor.interval=" + this.MONITOR_TIMEOUT / 1000);
        this.logger.logToAll(8, "imq.cluster.monitor.threshold=" + this.MAX_MONITOR);
        if (!clusterid.equals(this.clusterconfig.getClusterId())) {
            this.logger.log(32, "B3201", (Object)clusterid, this.clusterconfig.getClusterId());
            throw new IllegalStateException("Bad Cluster ID " + clusterid);
        }
        HAClusteredBroker cb = (HAClusteredBroker)this.clusterconfig.getLocalBroker();
        MQAddress mqa = cb.getBrokerURL();
        if (!mqa.equals(brokerURL)) {
            this.logger.logToAll(8, "B1207", this.mybrokerid, brokerURL);
            String remotebrokerid = this.getRemoteBrokerIDFromPortMapper(mqa.getHostName(), mqa.getPort(), this.mybrokerid);
            if (this.mybrokerid.equals(remotebrokerid)) {
                this.logger.log(32, "B3202", this.mybrokerid);
                Broker.getBroker().exit(1, Globals.getBrokerResources().getKString("B3202", this.mybrokerid), BrokerEvent.Type.FATAL_ERROR, null, false, false, true);
            }
            cb.setBrokerURL(brokerURL);
        }
        cb.updateHeartbeat(true);
        Iterator itr = this.clusterconfig.getConfigBrokers();
        while (itr.hasNext()) {
            HAClusteredBroker nextb = (HAClusteredBroker)itr.next();
            String bkr = nextb.getTakeoverBroker();
            if (bkr == null || !bkr.equals(this.mybrokerid) || nextb.getState() != BrokerState.FAILOVER_PENDING && nextb.getState() != BrokerState.FAILOVER_STARTED) continue;
            this.logger.logToAll(8, "B1209", nextb.getBrokerName());
            nextb.setState(BrokerState.FAILOVER_COMPLETE);
        }
        if (resetTakeoverThenExit) {
            this.logger.logToAll(8, Globals.getBrokerResources().getKString("B1335"));
            return;
        }
        BrokerState state = cb.getState();
        String tkovrbkr = cb.getTakeoverBroker();
        if (state == BrokerState.FAILOVER_STARTED || state == BrokerState.FAILOVER_PENDING) {
            this.logger.log(16, "B2134", (Object)this.mybrokerid, tkovrbkr);
            long maxwaitsec = Globals.getConfig().getLongProperty("imq.cluster.ha.takeoverWaitTimeout", 300L);
            long maxwait = maxwaitsec * 1000L;
            if (maxwait == 0L) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B2225", String.valueOf(maxwaitsec)));
            }
            long waitinterval = 10000L;
            long currtime = System.currentTimeMillis();
            long totalwaited = 0L;
            long waittime = maxwait < 0L || maxwait > waitinterval ? waitinterval : maxwait;
            do {
                long l;
                this.logger.logToAll(8, "B1208");
                try {
                    Thread.currentThread();
                    Thread.sleep(waittime);
                    long precurrtime = currtime;
                    currtime = System.currentTimeMillis();
                    l = currtime - precurrtime > waittime ? currtime - precurrtime : waittime;
                }
                catch (InterruptedException ex) {
                    throw new BrokerException("Waiting for taking over of this broker to complete is interrupted: " + ex.getMessage());
                }
                cb.updateHeartbeat(true);
                state = cb.getState();
                long l2 = waittime = maxwait < 0L ? waitinterval : maxwait - (totalwaited += l);
                if (waittime <= waitinterval) continue;
                waittime = waitinterval;
            } while ((state == BrokerState.FAILOVER_STARTED || state == BrokerState.FAILOVER_PENDING) && waittime > 0L);
            if (waittime <= 0L && (state == BrokerState.FAILOVER_STARTED || state == BrokerState.FAILOVER_PENDING)) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B2225", String.valueOf(maxwaitsec)));
            }
        }
        try {
            cb.resetTakeoverBrokerReadyOperating();
        }
        catch (Exception e) {
            state = cb.getState();
            if (state == BrokerState.FAILOVER_STARTED || state == BrokerState.FAILOVER_PENDING) {
                String msg = Globals.getBrokerResources().getKString("B3187");
                this.logger.logStack(32, msg, e);
                throw new StoreBeingTakenOverException(msg, 409);
            }
            throw e;
        }
        Globals.setStoreSession(cb.getStoreSessionUID());
        this.logger.logToAll(8, "B1193", String.valueOf(cb.getStoreSessionUID().longValue()), String.valueOf(cb.getBrokerSessionUID().longValue()));
        this.haMonitor = new HAMonitorTask();
        try {
            new HATimerThread("HAMonitor", this.haMonitor, this.MONITOR_TIMEOUT, this.MONITOR_TIMEOUT);
        }
        catch (Exception ex) {
            String emsg = "Unable to start HA monitor thread";
            this.logger.logStack(32, emsg, ex);
            throw new BrokerException(emsg, ex);
        }
    }

    @Override
    public int getMonitorInterval() {
        return this.MONITOR_TIMEOUT / 1000;
    }

    public UID getStoreSession() {
        return ((HAClusteredBroker)this.clusterconfig.getLocalBroker()).getStoreSessionUID();
    }

    public String toString() {
        return "HAMonitorServiceImpl[" + String.valueOf(this.clusterconfig.getLocalBroker()) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor() {
        HAClusteredBroker cb = (HAClusteredBroker)this.clusterconfig.getLocalBroker();
        if (DEBUG) {
            this.logger.log(8, "HAMonitor is updating heartbeat timestamp of [" + this.mybrokerid + "]" + this.MONITOR_TIMEOUT);
        }
        try {
            if (this.fi.FAULT_INJECTION) {
                this.fi.checkFaultAndThrowBrokerException("hb.sharedb", null);
            }
            cb.updateHeartbeat();
            this.heartbeatMissedCnt.set(0);
        }
        catch (BrokerException ex) {
            if (Globals.getJDBCHAEnabled()) {
                if (this.heartbeatMissedCnt.incrementAndGet() < this.MAX_HEARTBEAT) {
                    this.logger.logStack(16, Globals.getBrokerResources().getKString("B2192", ex.getMessage()), ex);
                } else {
                    String errorMsg = Globals.getBrokerResources().getKString("B3230", this.MAX_HEARTBEAT);
                    this.logger.logStack(32, errorMsg, ex);
                    Broker.getBroker().exit(BrokerStateHandler.getRestartCode(), errorMsg, BrokerEvent.Type.RESTART, ex, true, false, false);
                }
            }
            this.logger.logStack(32, ex.getMessage(), ex);
            Broker.getBroker().exit(BrokerStateHandler.getRestartCode(), ex.getMessage(), BrokerEvent.Type.RESTART, ex, true, false, false);
        }
        try {
            BrokerState state = cb.getState();
            if (state == BrokerState.QUIESCE_STARTED || state == BrokerState.QUIESCE_COMPLETED || state == BrokerState.FAILOVER_PENDING || state == BrokerState.FAILOVER_FAILED || state == BrokerState.SHUTDOWN_STARTED || state == BrokerState.SHUTDOWN_FAILOVER || state == BrokerState.SHUTDOWN_COMPLETE) {
                return;
            }
        }
        catch (BrokerException ex) {
            this.logger.logStack(16, "B4117", ex.getMessage(), (Throwable)ex);
        }
        if (this.indoubtBrokers.size() > 0) {
            this.logger.logToAll(8, "B1210", String.valueOf(this.indoubtBrokers.size()));
        }
        ArrayList<DownBroker> takeover = null;
        HashSet s = new HashSet(this.indoubtBrokers.keySet());
        Object object = this.takeoverRunnableLock;
        synchronized (object) {
            this.monitorBusy = true;
        }
        try {
            Iterator itr = s.iterator();
            while (itr.hasNext()) {
                Object key = itr.next();
                IndoubtData wbd = (IndoubtData)this.indoubtBrokers.get(key);
                try {
                    HAClusteredBroker idbcb = (HAClusteredBroker)this.clusterconfig.getBroker(wbd.brokerid);
                    BrokerState idbstate = idbcb.getState();
                    long ts = idbcb.getHeartbeat();
                    if (idbstate == BrokerState.SHUTDOWN_COMPLETE) {
                        this.logger.logToAll(8, "B1211", wbd.brokerid);
                        idbcb.setBrokerIsUp(false, wbd.brokerSession, null);
                        this.indoubtBrokers.remove(key);
                        itr.remove();
                        continue;
                    }
                    if (idbstate == BrokerState.FAILOVER_STARTED || idbstate == BrokerState.FAILOVER_COMPLETE) {
                        this.logger.logToAll(8, "B1212", wbd.brokerid + "[" + String.valueOf(idbstate) + "]");
                        idbcb.setBrokerIsUp(false, wbd.brokerSession, null);
                        this.indoubtBrokers.remove(key);
                        itr.remove();
                        continue;
                    }
                    if (ts > wbd.lastts && idbstate != BrokerState.FAILOVER_PENDING) {
                        this.logger.logToAll(8, "B1213", idbcb.getBrokerName());
                        idbcb.setBrokerInDoubt(false, wbd.brokerSession);
                        this.indoubtBrokers.remove(key);
                        itr.remove();
                        continue;
                    }
                    ++wbd.monitorCnt;
                    if (wbd.monitorCnt >= this.MAX_MONITOR || idbstate == BrokerState.SHUTDOWN_FAILOVER) {
                        this.logger.logToAll(8, "B1214", idbcb.getBrokerName());
                        if (this.takeoverRunnable != null) {
                            this.logger.logToAll(8, "B1296", idbcb.getBrokerName());
                            continue;
                        }
                        if (takeover == null) {
                            takeover = new ArrayList<DownBroker>();
                        }
                        DownBroker dbroker = new DownBroker();
                        dbroker.cb = idbcb;
                        dbroker.lastts = wbd.lastts;
                        dbroker.brokerSession = wbd.brokerSession;
                        dbroker.storeSession = idbcb.getStoreSessionUID();
                        takeover.add(dbroker);
                        idbcb.setBrokerIsUp(false, wbd.brokerSession, null);
                        itr.remove();
                        this.indoubtBrokers.remove(key);
                        continue;
                    }
                    this.logger.logToAll(8, "B1215", idbcb.getBrokerName());
                }
                catch (Exception ex) {
                    this.logger.logStack(32, "Unable to monitor broker " + wbd.brokerid, ex);
                }
            }
            if (takeover == null) {
                return;
            }
            if (this.takeoverRunnable != null) {
                this.logger.log(32, "B3100", Globals.getBrokerResources().getString("B1296", takeover));
                return;
            }
            this.takeoverRunnable = new TakeoverThread(takeover, false, false);
        }
        finally {
            Object object2 = this.takeoverRunnableLock;
            synchronized (object2) {
                this.monitorBusy = false;
                this.takeoverRunnableLock.notifyAll();
            }
        }
        Thread thr = new Thread(this.takeoverRunnable, "Takeover");
        thr.start();
    }

    public void brokerDown(BrokerAddress addr) throws BrokerException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inTakeover() {
        Object object = this.takeoverRunnableLock;
        synchronized (object) {
            return this.takeoverRunnable != null || this.takeoverMEInprogress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String takeoverME(HAClusteredBroker cb, String brokerID, Long syncTimeout) throws BrokerException {
        Object object = this.takeoverRunnableLock;
        synchronized (object) {
            this.takeoverMEInprogress = true;
        }
        try {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4313"), 405);
        }
        catch (Throwable throwable) {
            this.takeoverMEInprogress = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void takeoverBroker(HAClusteredBroker cb, Object extraInfo1, Object extraInfo2, boolean force) throws BrokerException {
        DownBroker dbroker = new DownBroker();
        dbroker.cb = cb;
        dbroker.lastts = cb.getHeartbeat();
        dbroker.brokerSession = cb.getBrokerSessionUID();
        dbroker.storeSession = cb.getStoreSessionUID();
        dbroker.extraInfo = extraInfo1;
        if (cb instanceof RepHAClusteredBrokerImpl) {
            dbroker.brokerName = ((RepHAClusteredBrokerImpl)cb).getNodeName();
            dbroker.storeSession = (UID)extraInfo2;
        } else {
            dbroker.brokerName = cb.getBrokerName();
        }
        ArrayList<DownBroker> l = new ArrayList<DownBroker>();
        l.add(dbroker);
        Object object = this.takeoverRunnableLock;
        synchronized (object) {
            while (this.monitorBusy || this.takeoverRunnable != null) {
                try {
                    this.takeoverRunnableLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.takeoverRunnable = new TakeoverThread(l, force, true);
        }
        try {
            ((TakeoverThread)this.takeoverRunnable).doTakeover();
        }
        catch (Exception e) {
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            throw new BrokerException(e.getMessage(), e, 500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkTakingoverDestination(Destination d) {
        if (this.takingoverTargets.size() == 0) {
            return false;
        }
        TakingoverTracker target2 = null;
        Iterator itr = null;
        Vector vector = this.takingoverTargets;
        synchronized (vector) {
            for (TakingoverTracker target2 : this.takingoverTargets) {
                if (!target2.containDestination(d)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkTakingoverMessage(Packet p) {
        TakingoverTracker target2 = null;
        Iterator itr = null;
        Vector vector = this.takingoverTargets;
        synchronized (vector) {
            for (TakingoverTracker target2 : this.takingoverTargets) {
                if (!target2.containMessage(p)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTakingoverTarget(String brokerID, UID storeSession) {
        TakingoverTracker target2 = null;
        Iterator itr = null;
        Vector vector = this.takingoverTargets;
        synchronized (vector) {
            for (TakingoverTracker target2 : this.takingoverTargets) {
                UID ss = target2.getStoreSessionUID();
                if (!target2.getTargetName().equals(brokerID) || (ss != null || !target2.getDownStoreSessionUID().equals(storeSession)) && (ss == null || !ss.equals(storeSession) && !target2.getDownStoreSessionUID().equals(storeSession)) && !target2.containStoreSession(storeSession.longValue())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchBroker(String brokerid, UID brokerSession) throws BrokerException {
        Map map = this.indoubtBrokers;
        synchronized (map) {
            if (this.indoubtBrokers.get(brokerid) != null) {
                return;
            }
            IndoubtData wbd = new IndoubtData();
            wbd.brokerid = brokerid;
            wbd.lastts = ((HAClusteredBroker)this.clusterconfig.getBroker(brokerid)).getHeartbeat();
            wbd.monitorCnt = 0;
            wbd.brokerSession = brokerSession;
            this.indoubtBrokers.put(brokerid, wbd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWatchingBroker(String brokerid) {
        Map map = this.indoubtBrokers;
        synchronized (map) {
            this.indoubtBrokers.remove(brokerid);
        }
    }

    @Override
    public void clusterPropertyChanged(String name, String value) {
    }

    @Override
    public void brokerAdded(ClusteredBroker broker, UID brokerSession) {
    }

    @Override
    public void brokerRemoved(ClusteredBroker broker, UID brokerSession) {
    }

    @Override
    public void masterBrokerChanged(ClusteredBroker oldMaster, ClusteredBroker newMaster) {
    }

    @Override
    public void brokerStatusChanged(String brokerid, int oldStatus, int newStatus, UID brokerSession, Object userData) {
        this.logger.log(4, "brokerStatusChanged " + brokerid + ":\n\t" + BrokerStatus.toString(oldStatus) + "\n\t" + BrokerStatus.toString(newStatus) + "\n\t" + String.valueOf(userData));
        if (BrokerStatus.getBrokerInDoubt(newStatus) && BrokerStatus.getBrokerIsUp(newStatus)) {
            ClusteredBroker cb = this.clusterconfig.getBroker(brokerid);
            if (cb.isLocalBroker()) {
                return;
            }
            try {
                BrokerState state = cb.getState();
                if (state == BrokerState.SHUTDOWN_COMPLETE || state == BrokerState.FAILOVER_COMPLETE) {
                    this.logger.logToAll(8, "B1213", cb.getBrokerName());
                    cb.setBrokerIsUp(false, brokerSession, null);
                    return;
                }
                this.logger.logToAll(8, "B1288", brokerid);
                this.watchBroker(brokerid, brokerSession);
            }
            catch (Exception ex) {
                this.logger.logStack(16, "Unable to monitor broker " + brokerid, ex);
            }
        } else if (BrokerStatus.getBrokerInDoubt(oldStatus) && BrokerStatus.getBrokerIsUp(newStatus)) {
            this.logger.logToAll(8, "B1213", brokerid);
            this.stopWatchingBroker(brokerid);
        }
    }

    @Override
    public void brokerStateChanged(String brokerid, BrokerState oldState, BrokerState newState) {
        ClusteredBroker cb = this.clusterconfig.getBroker(brokerid);
        if (cb.isLocalBroker() && (newState == BrokerState.SHUTDOWN_COMPLETE || newState == BrokerState.SHUTDOWN_FAILOVER)) {
            this.haMonitor.cancel();
            this.clusterconfig.removeEventListener(this);
        }
    }

    @Override
    public void brokerVersionChanged(String brokerid, int oldVersion, int newVersion) {
    }

    @Override
    public void brokerURLChanged(String brokerid, MQAddress oldAddress, MQAddress newAddress) {
    }

    static {
        DEBUG = DEBUG_HA = Globals.getConfig().getBooleanProperty("imq.ha.debug");
    }

    class HAMonitorTask
    implements Runnable {
        boolean valid = true;

        HAMonitorTask() {
        }

        public void cancel() {
            this.valid = false;
        }

        @Override
        public void run() {
            if (!this.valid) {
                return;
            }
            HAMonitorServiceImpl.this.monitor();
        }
    }

    static class HATimerThread
    implements Runnable {
        long nexttime = 0L;
        long repeatItr = 0L;
        Thread thr = null;
        Runnable child = null;

        HATimerThread(String name, Runnable runner, int initTO, int repeatItr) {
            this.nexttime = (long)initTO + System.currentTimeMillis();
            this.repeatItr = repeatItr;
            this.child = runner;
            this.thr = new Thread((Runnable)this, name);
            this.thr.setDaemon(true);
            this.thr.setPriority(10);
            this.thr.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                long tmpnext;
                long time = System.currentTimeMillis();
                HATimerThread hATimerThread = this;
                synchronized (hATimerThread) {
                    if (time < this.nexttime) {
                        try {
                            this.wait(this.nexttime - time);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    this.child.run();
                }
                if (this.repeatItr == 0L) break;
                time = System.currentTimeMillis();
                if (time >= (tmpnext = this.nexttime + this.repeatItr)) {
                    this.nexttime = time;
                    continue;
                }
                this.nexttime = tmpnext;
            }
        }
    }

    static class IndoubtData {
        String brokerid;
        long lastts = 0L;
        int monitorCnt = 0;
        UID brokerSession = null;

        IndoubtData() {
        }
    }

    static class DownBroker {
        HAClusteredBroker cb = null;
        long lastts = 0L;
        UID brokerSession = null;
        UID storeSession = null;
        String brokerName = null;
        Object extraInfo = null;

        DownBroker() {
        }
    }

    class TakeoverThread
    implements Runnable {
        ArrayList downBkrs = null;
        boolean force = false;
        boolean throwex = false;

        TakeoverThread(ArrayList downBkrs, boolean force, boolean throwex) {
            this.downBkrs = downBkrs;
            this.force = force;
            this.throwex = throwex;
        }

        @Override
        public void run() {
            try {
                this.doTakeover();
            }
            catch (Exception e) {
                Logger cfr_ignored_0 = HAMonitorServiceImpl.this.logger;
                HAMonitorServiceImpl.this.logger.logStack(16, e.getMessage(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void doTakeover() throws Exception {
            try {
                pstore = null;
                translist = null;
                if (!Globals.getStore().getPartitionModeEnabled()) {
                    pstore = Globals.getStore().getPrimaryPartition();
                    tls = DestinationList.getTransactionList(pstore);
                    translist = tls[0];
                }
                mbus = Globals.getClusterBroadcast();
                while (mbus == null) {
                    HAMonitorServiceImpl.this.logger.logToAll(8, "B1264");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException var4_4) {
                        // empty catch block
                    }
                    mbus = Globals.getClusterBroadcast();
                }
                itr = this.downBkrs.iterator();
                while (itr.hasNext()) {
                    dbroker = (DownBroker)itr.next();
                    cb = dbroker.cb;
                    brokerName = dbroker.brokerName;
                    if (brokerName == null) {
                        brokerName = cb.getBrokerName();
                    }
                    HAMonitorServiceImpl.this.logger.logToAll(8, "B1216", brokerName);
                    takeoverComplete = false;
                    tracker = new TakingoverTracker(brokerName, Thread.currentThread());
                    tracker.setBrokerSessionUID(dbroker.brokerSession);
                    tracker.setDownStoreSessionUID(dbroker.storeSession);
                    tracker.setLastHeartbeat(dbroker.lastts);
                    HAMonitorServiceImpl.this.takingoverTargets.add(tracker);
                    mbus.preTakeover(brokerName, tracker.getDownStoreSessionUID(), ((BrokerMQAddress)cb.getBrokerURL()).getHost().getHostAddress(), tracker.getBrokerSessionUID());
                    info = cb.takeover(this.force, dbroker.extraInfo, tracker);
                    tracker.setStage_BEFORE_PROCESSING();
                    tracker.setTakeoverStoreSessionList(info.getTakeoverStoreSessionList());
                    takeoverComplete = true;
                    HAMonitorServiceImpl.this.logger.logToAll(8, "B1217", tracker.getTargetName());
                    mbus.postTakeover(tracker.getTargetName(), tracker.getStoreSessionUID(), false, false);
                    if (Globals.getStore().getPartitionModeEnabled()) {
                        uid = null;
                        ps = null;
                        itrp = info.getTakeoverStoreSessionList().iterator();
                        while (itrp.hasNext()) {
                            uid = new UID(itrp.next());
                            ps = Globals.getStore().getStorePartition(uid);
                            HAMonitorServiceImpl.this.logger.logToAll(8, "Process taken over data from store session " + String.valueOf(uid));
                            DestinationList.addStorePartition(ps, false);
                            HAMonitorServiceImpl.this.logger.logToAll(8, "Processed taken over data from store session " + String.valueOf(uid));
                        }
                    } else {
                        msgs = info.getMessageMap();
                        txn = info.getTransactionList();
                        remoteTxn = info.getRemoteTransactionList();
                        if (txn == null) {
                            txn = new ArrayList<E>();
                        }
                        HAMonitorServiceImpl.this.logger.logToAll(8, "B1218", tracker.getTargetName(), String.valueOf(txn.size()));
                        HAMonitorServiceImpl.this.logger.logToAll(8, "B1297", tracker.getTargetName(), String.valueOf(remoteTxn.size()));
                        Globals.getDestinationList();
                        DestinationList.remoteCheckTakeoverMsgs(msgs, tracker.getTargetName(), pstore);
                        openTxns = new ArrayList<TransactionUID>();
                        titr = txn.iterator();
                        while (titr.hasNext()) {
                            tid = (TransactionUID)titr.next();
                            ts = pstore.getTransactionState(tid);
                            if (ts == null) {
                                titr.remove();
                                continue;
                            }
                            type = ts.getType();
                            state = ts.getState();
                            if (state == 7) {
                                if (HAMonitorServiceImpl.DEBUG) {
                                    HAMonitorServiceImpl.this.logger.log(8, "Process taken over txn: Rolling back  transaction " + String.valueOf(tid));
                                }
                                openTxns.add(tid);
                                continue;
                            }
                            if (state == 6) {
                                if (HAMonitorServiceImpl.DEBUG) {
                                    HAMonitorServiceImpl.this.logger.log(8, "Process takenover txn: Committing  transaction " + String.valueOf(tid));
                                }
                                openTxns.add(tid);
                                continue;
                            }
                            if (type == AutoRollbackType.ALL) {
                                v0 = new String[3];
                                v0[0] = tracker.getTargetName();
                                v0[1] = String.valueOf(tid.longValue());
                                v0[2] = TransactionState.toString(ts.getState());
                                args = v0;
                                HAMonitorServiceImpl.this.logger.log(8, "B1220", args);
                                ts.setState(7);
                                try {
                                    pstore.updateTransactionState(tid, ts, Destination.PERSIST_SYNC);
                                }
                                catch (IOException e) {
                                    throw new BrokerException(null, e);
                                }
                                openTxns.add(tid);
                                continue;
                            }
                            if (ts.getType() == AutoRollbackType.NOT_PREPARED && ts.getState() < 5) {
                                v1 = new String[3];
                                v1[0] = tracker.getTargetName();
                                v1[1] = String.valueOf(tid.longValue());
                                v1[2] = TransactionState.toString(ts.getState());
                                args = v1;
                                HAMonitorServiceImpl.this.logger.log(8, "B1219", args);
                                ts.setState(7);
                                try {
                                    pstore.updateTransactionState(tid, ts, Destination.PERSIST_SYNC);
                                }
                                catch (IOException e) {
                                    throw new BrokerException(null, e);
                                }
                                openTxns.add(tid);
                                continue;
                            }
                            args = new String[]{tracker.getTargetName(), String.valueOf(tid.longValue()), ts.toString()};
                            HAMonitorServiceImpl.this.logger.log(8, "B1298", args);
                        }
                        tid = null;
                        ts = null;
                        myts = null;
                        for (TransactionUID tid : remoteTxn) {
                            try {
                                ts = pstore.getTransactionState(tid);
                            }
                            catch (Exception e) {
                                HAMonitorServiceImpl.this.logger;
                                HAMonitorServiceImpl.this.logger.log(16, "Unable to get transaction state " + String.valueOf(tid) + " for takenover broker " + tracker.getTargetName());
                                continue;
                            }
                            if (ts == null) continue;
                            try {
                                if (ts.getState() >= 5 || translist.retrieveState(tid) == null || !translist.isClusterTransactionBroker(tid, tracker.getStoreSessionUID()) || (myts = translist.retrieveState(tid)) == null) continue;
                                myts = new TransactionState(myts);
                                translist.updateState(tid, myts.nextState(48, null), myts.getState(), true);
                                HAMonitorServiceImpl.this.logger;
                                HAMonitorServiceImpl.this.logger.log(8, "Remote transaction " + String.valueOf(tid) + "(" + TransactionState.toString(ts.getState()) + ") from takenover broker " + String.valueOf(tracker) + " will be rolledback");
                            }
                            catch (Exception e) {
                                HAMonitorServiceImpl.this.logger;
                                HAMonitorServiceImpl.this.logger.log(16, "Unable to set ROLLBACK state to transaction " + String.valueOf(tid) + ":" + e.getMessage() + " for takenover broker " + tracker.getTargetName());
                            }
                        }
                        reaper = new TakeoverReaper(tracker.getTargetName(), openTxns, translist);
                        m = translist.loadTakeoverTxns(txn, remoteTxn, msgs);
                        HAMonitorServiceImpl.this.logger.logToAll(8, "B1221", tracker.getTargetName(), String.valueOf(msgs.size()));
                        DestinationList.loadTakeoverMsgs(pstore, msgs, txn, m);
                        tracker.setStage_AFTER_PROCESSING();
                        HAMonitorServiceImpl.this.takingoverTargets.remove(tracker);
                        translist.unlockTakeoverTxns(txn);
                        done = reaper.processTxns();
                        timer = Globals.getTimer();
                        try {
                            if (done) ** GOTO lbl165
                            timer.schedule((TimerTask)reaper, HAMonitorServiceImpl.this.reaperTimeout, (long)HAMonitorServiceImpl.this.reaperTimeout);
                        }
                        catch (IllegalStateException ex) {
                            HAMonitorServiceImpl.this.logger.logStack(16, "B3100", "Unable to start takeover-transaction reaper", (Throwable)ex);
                        }
                    }
lbl165:
                    // 4 sources

                    HAMonitorServiceImpl.this.logger;
                    HAMonitorServiceImpl.this.logger.logToAll(8, "B1338", tracker.toString());
                    cb.setBrokerIsUp(false, tracker.getBrokerSessionUID(), tracker.getStoreSessionUID());
                    cb.setStateFailoverProcessed(tracker.getStoreSessionUID());
                    HAMonitorServiceImpl.this.logger;
                    HAMonitorServiceImpl.this.logger.logToAll(8, "B1223", tracker.toString());
                    itr.remove();
                    try {
                        mbus.postTakeover(tracker.getTargetName(), takeoverComplete != false ? tracker.getStoreSessionUID() : tracker.getDownStoreSessionUID(), takeoverComplete == false, true);
                        continue;
                    }
                    finally {
                        if (tracker.getStage() < 4) {
                            HAMonitorServiceImpl.this.takingoverTargets.remove(tracker);
                        }
                        if (translist == null) continue;
                        translist.postProcess();
                        continue;
                    }
                    catch (Exception ex) {
                        block73: {
                            if (ex instanceof TakeoverLockException) {
                                state = null;
                                takeoverBy = null;
                                bkrInfo = ((TakeoverLockException)ex).getBrokerInfo();
                                if (bkrInfo == null) {
                                    try {
                                        state = cb.getState();
                                        takeoverBy = cb.getTakeoverBroker();
                                    }
                                    catch (BrokerException openTxns) {}
                                } else {
                                    state = BrokerState.getState(bkrInfo.getState());
                                    takeoverBy = bkrInfo.getTakeoverBrokerID();
                                }
                                if (state == BrokerState.FAILOVER_PENDING || state == BrokerState.FAILOVER_STARTED || state == BrokerState.FAILOVER_COMPLETE) {
                                    if (takeoverBy != null) {
                                        HAMonitorServiceImpl.this.logger.logToAll(8, "B3231", brokerName, "Broker is being taken over by " + takeoverBy);
                                    } else {
                                        HAMonitorServiceImpl.this.logger.log(32, "B1191");
                                    }
                                } else if (state == BrokerState.OPERATING && takeoverBy == null) {
                                    HAMonitorServiceImpl.this.logger.logStack(16, Globals.getBrokerResources().getKString("B1481", cb.getBrokerName()), ex);
                                } else {
                                    HAMonitorServiceImpl.this.logger.logStack(16, "B1481", cb.getBrokerName() + "[" + String.valueOf(state) + "]TAKEOVER_BROKER=" + takeoverBy, (Throwable)ex);
                                }
                                try {
                                    cb.setStateFailoverFailed(dbroker.brokerSession);
                                }
                                catch (Exception ex2) {
                                    HAMonitorServiceImpl.this.logger.logStack(32, ex2.getMessage(), ex2);
                                }
                            } else if (ex instanceof BrokerException && ((BrokerException)ex).getStatusCode() == 409) {
                                HAMonitorServiceImpl.this.logger.log(16, ex.getMessage());
                            } else if (tracker.getStage() >= 4) {
                                HAMonitorServiceImpl.this.logger.logStack(32, Globals.getBrokerResources().getKString("B3244", tracker.toString()), ex);
                            } else {
                                HAMonitorServiceImpl.this.logger.logStack(32, "B3231", brokerName, ex.getMessage(), ex);
                            }
                            cb.setBrokerIsUp(false, dbroker.brokerSession, null);
                            if (!this.throwex) break block73;
                            throw ex;
                        }
                        try {
                            mbus.postTakeover(tracker.getTargetName(), takeoverComplete != false ? tracker.getStoreSessionUID() : tracker.getDownStoreSessionUID(), takeoverComplete == false, true);
                            continue;
                        }
                        finally {
                            if (tracker.getStage() < 4) {
                                HAMonitorServiceImpl.this.takingoverTargets.remove(tracker);
                            }
                            if (translist == null) continue;
                            translist.postProcess();
                            continue;
                        }
                        catch (Throwable var26_35) {
                            try {
                                mbus.postTakeover(tracker.getTargetName(), takeoverComplete != false ? tracker.getStoreSessionUID() : tracker.getDownStoreSessionUID(), takeoverComplete == false, true);
                                throw var26_35;
                            }
                            finally {
                                if (tracker.getStage() < 4) {
                                    HAMonitorServiceImpl.this.takingoverTargets.remove(tracker);
                                }
                                if (translist != null) {
                                    translist.postProcess();
                                }
                            }
                            return;
                        }
                    }
                }
            }
            finally {
                var1_1 = HAMonitorServiceImpl.this.takeoverRunnableLock;
                synchronized (var1_1) {
                    HAMonitorServiceImpl.this.takeoverRunnable = null;
                    HAMonitorServiceImpl.this.takeoverRunnableLock.notifyAll();
                }
            }
        }
    }

    class TakeoverReaper
    extends TimerTask {
        List txns = null;
        String id = null;
        TransactionList translist = null;

        TakeoverReaper(String broker, List txns, TransactionList translist) {
            this.txns = txns;
            this.id = broker;
            this.translist = translist;
            Logger cfr_ignored_0 = HAMonitorServiceImpl.this.logger;
            HAMonitorServiceImpl.this.logger.log(4, "monitoring " + txns.size() + " transactions");
        }

        @Override
        public void run() {
            boolean done = this.processTxns();
            if (done) {
                this.cancel();
            }
        }

        public boolean processTxns() {
            try {
                Iterator itr = this.txns.iterator();
                while (itr.hasNext()) {
                    TransactionState state;
                    TransactionUID tid;
                    block8: {
                        tid = (TransactionUID)itr.next();
                        state = null;
                        try {
                            state = this.translist.getPartitionedStore().getTransactionState(tid);
                            if (state == null) continue;
                            if (state.getState() == 6) {
                                this.translist.reapTakeoverCommittedTransaction(tid);
                                itr.remove();
                            }
                            break block8;
                        }
                        catch (BrokerException ex) {
                            this.translist.removeTransactionAck(tid);
                            this.translist.removeTransactionID(tid);
                            itr.remove();
                        }
                        continue;
                    }
                    int realstate = state.getState();
                    int msgs = 0;
                    int acks = 0;
                    try {
                        int[] retval = this.translist.getPartitionedStore().getTransactionUsageInfo(tid);
                        msgs = retval[0];
                        acks = retval[1];
                    }
                    catch (Exception retval) {
                        // empty catch block
                    }
                    if ((realstate == 7 || realstate == 5 || realstate == 6) && (msgs != 0 || acks != 0)) continue;
                    HAMonitorServiceImpl.this.logger.log(DEBUG ? 8 : 4, "Removing finished transaction " + String.valueOf(tid) + " for tookover broker " + this.id);
                    TransactionHandler thandler = (TransactionHandler)Globals.getPacketRouter(0).getHandler(48);
                    thandler.doRollback(this.translist, tid, null, null, state, null, null, RollbackReason.TAKEOVER_CLEANUP);
                    itr.remove();
                }
            }
            catch (Exception ex) {
                HAMonitorServiceImpl.this.logger.logStack(16, "B3100", "removing reaped destinations for tookover broker " + this.id, (Throwable)ex);
            }
            return this.txns.size() == 0;
        }
    }
}

