/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.pfl.dynamic.codegen.impl.ASMUtil;
import org.glassfish.pfl.dynamic.codegen.impl.AssignmentStatement;
import org.glassfish.pfl.dynamic.codegen.impl.BlockStatement;
import org.glassfish.pfl.dynamic.codegen.impl.ClassGeneratorImpl;
import org.glassfish.pfl.dynamic.codegen.impl.DefinitionStatement;
import org.glassfish.pfl.dynamic.codegen.impl.EmitterFactory;
import org.glassfish.pfl.dynamic.codegen.impl.ExpressionFactory;
import org.glassfish.pfl.dynamic.codegen.impl.ExpressionInternal;
import org.glassfish.pfl.dynamic.codegen.impl.MethodGenerator;
import org.glassfish.pfl.dynamic.codegen.impl.Node;
import org.glassfish.pfl.dynamic.codegen.impl.Statement;
import org.glassfish.pfl.dynamic.codegen.impl.TreeWalker;
import org.glassfish.pfl.dynamic.codegen.impl.TreeWalkerContext;
import org.glassfish.pfl.dynamic.codegen.impl.TryStatement;
import org.glassfish.pfl.dynamic.codegen.impl.VariableInternal;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Variable;

public class ASMSetupVisitor
extends TreeWalker {
    private VariableContext variableDefiningContext;
    private Mode mode;
    private SlotAllocator slotAllocator;
    private List<ErrorReport> errors;

    public List<ErrorReport> getVerificationErrors() {
        return this.errors;
    }

    private void verificationError(Node node, String msg) {
        ErrorReport report = new ErrorReport();
        report.node = node;
        report.msg = msg;
        this.errors.add(report);
    }

    public ASMSetupVisitor(TreeWalkerContext context) {
        this(context, Mode.PREPARE);
    }

    public ASMSetupVisitor(TreeWalkerContext context, Mode mode) {
        super(context);
        context.push(this);
        this.variableDefiningContext = VariableContext.REFERENCE;
        this.mode = mode;
        this.slotAllocator = null;
        this.errors = new ArrayList<ErrorReport>();
    }

    private boolean preparing() {
        return this.mode == Mode.PREPARE;
    }

    @Override
    public boolean preClassGenerator(ClassGeneratorImpl arg) {
        return true;
    }

    @Override
    public boolean preMethodGenerator(MethodGenerator arg) {
        this.slotAllocator = new SlotAllocator();
        for (Variable var : arg.arguments()) {
            ASMUtil.requiredEmitterType.set((VariableInternal)var, ASMUtil.RequiredEmitterType.NONE);
        }
        return !Modifier.isAbstract(arg.modifiers());
    }

    @Override
    public boolean methodGeneratorBeforeArguments(MethodGenerator arg) {
        this.variableDefiningContext = VariableContext.DEFINE_LOCAL;
        return true;
    }

    @Override
    public void methodGeneratorAfterArguments(MethodGenerator arg) {
        this.variableDefiningContext = VariableContext.REFERENCE;
    }

    @Override
    public void postMethodGenerator(MethodGenerator arg) {
        if (!arg.returnType().equals(Type._void())) {
            Variable var;
            if (this.preparing()) {
                var = arg.body().exprFactory().variable(arg.returnType(), "$$_returnVariable_$$");
                ASMUtil.returnVariable.set(arg, var);
            } else {
                var = ASMUtil.returnVariable.get(arg);
            }
            this.defineLocalVariable(var);
        }
        this.slotAllocator = null;
    }

    @Override
    public boolean classGeneratorBeforeFields(ClassGeneratorImpl arg) {
        return true;
    }

    @Override
    public void classGeneratorBeforeInitializer(ClassGeneratorImpl arg) {
        this.variableDefiningContext = VariableContext.REFERENCE;
    }

    @Override
    public void classGeneratorBeforeMethod(ClassGeneratorImpl arg) {
        this.variableDefiningContext = VariableContext.REFERENCE;
    }

    @Override
    public void classGeneratorBeforeConstructor(ClassGeneratorImpl arg) {
        this.variableDefiningContext = VariableContext.REFERENCE;
    }

    @Override
    public void postClassGenerator(ClassGeneratorImpl arg) {
        this.variableDefiningContext = VariableContext.REFERENCE;
    }

    @Override
    public boolean preBlockStatement(BlockStatement arg) {
        ASMUtil.lastStatement.set(arg, null);
        return true;
    }

    @Override
    public void blockStatementBeforeBodyStatement(BlockStatement arg, Statement stmt) {
        Statement lastStatement = ASMUtil.lastStatement.get(arg);
        if (lastStatement != null) {
            ASMUtil.next.set(lastStatement, stmt);
        }
        ASMUtil.lastStatement.set(arg, stmt);
    }

    @Override
    public void postBlockStatement(BlockStatement arg) {
    }

    @Override
    public boolean preDefinitionStatement(DefinitionStatement arg) {
        this.variableDefiningContext = VariableContext.DEFINE_LOCAL_DEFINITION;
        if (this.preparing()) {
            ASMUtil.requiredEmitterType.set((VariableInternal)arg.var(), ASMUtil.RequiredEmitterType.SETTER);
        } else if (ASMUtil.requiredEmitterType.get((VariableInternal)arg.var()) != ASMUtil.RequiredEmitterType.SETTER) {
            this.verificationError(arg, "Variable of definition statement should have requiredEmitterType true");
        }
        return true;
    }

    @Override
    public boolean definitionStatementBeforeExpr(DefinitionStatement arg) {
        this.variableDefiningContext = VariableContext.REFERENCE;
        return true;
    }

    @Override
    public boolean preTryStatement(TryStatement arg) {
        if (!arg.finalPart().isEmpty()) {
            Variable ucVar = arg.bodyPart().exprFactory().variable(Type._class("java.lang.Throwable"), "$$_uncaughtException_$$");
            this.defineLocalVariable(ucVar);
            ASMUtil.uncaughtException.set(arg, ucVar);
            Variable raVar = arg.bodyPart().exprFactory().variable(Type._Object(), "$$_returnAddress_$$");
            this.defineLocalVariable(raVar);
            ASMUtil.returnAddress.set(arg, raVar);
        }
        return true;
    }

    @Override
    public void tryStatementBeforeBlock(TryStatement arg, Type type, Variable var, BlockStatement block) {
        ASMUtil.requiredEmitterType.set((VariableInternal)var, ASMUtil.RequiredEmitterType.NONE);
        this.defineLocalVariable(var);
    }

    @Override
    public boolean tryStatementBeforeFinalPart(TryStatement arg) {
        return true;
    }

    @Override
    public void postTryStatement(TryStatement arg) {
    }

    @Override
    public boolean preAssignmentStatement(AssignmentStatement arg) {
        ExpressionInternal left = arg.left();
        assert (left.isAssignable());
        if (this.preparing()) {
            ASMUtil.requiredEmitterType.set(left, ASMUtil.RequiredEmitterType.SETTER);
        } else if (ASMUtil.requiredEmitterType.get(left) != ASMUtil.RequiredEmitterType.SETTER) {
            this.verificationError(arg, "Left side of assignment statement should have requiredEmitterType SETTER");
        }
        return true;
    }

    @Override
    public boolean preNonStaticFieldAccessExpression(ExpressionFactory.NonStaticFieldAccessExpression arg) {
        this.initializeEmitter(arg);
        return true;
    }

    @Override
    public boolean preStaticFieldAccessExpression(ExpressionFactory.StaticFieldAccessExpression arg) {
        this.initializeEmitter(arg);
        return true;
    }

    @Override
    public boolean preArrayIndexExpression(ExpressionFactory.ArrayIndexExpression arg) {
        this.initializeEmitter(arg);
        return true;
    }

    private void initializeEmitter(ExpressionFactory.NonStaticFieldAccessExpression arg) {
        ASMUtil.RequiredEmitterType ret = ASMUtil.requiredEmitterType.get(arg);
        EmitterFactory.Emitter em = null;
        if (ret != ASMUtil.RequiredEmitterType.NONE) {
            em = EmitterFactory.makeEmitter(arg, ret == ASMUtil.RequiredEmitterType.SETTER);
        }
        this.handleEmitter(arg, em);
    }

    private void initializeEmitter(ExpressionFactory.StaticFieldAccessExpression arg) {
        ASMUtil.RequiredEmitterType ret = ASMUtil.requiredEmitterType.get(arg);
        EmitterFactory.Emitter em = null;
        if (ret != ASMUtil.RequiredEmitterType.NONE) {
            em = EmitterFactory.makeEmitter(arg, ret == ASMUtil.RequiredEmitterType.SETTER);
        }
        this.handleEmitter(arg, em);
    }

    private void initializeEmitter(ExpressionFactory.ArrayIndexExpression arg) {
        ASMUtil.RequiredEmitterType ret = ASMUtil.requiredEmitterType.get(arg);
        EmitterFactory.Emitter em = null;
        if (ret != ASMUtil.RequiredEmitterType.NONE) {
            em = EmitterFactory.makeEmitter(arg, ret == ASMUtil.RequiredEmitterType.SETTER);
        }
        this.handleEmitter(arg, em);
    }

    private void compareEmitter(String nodeType, Node arg, EmitterFactory.Emitter expected, EmitterFactory.Emitter actual) {
        boolean error;
        if (actual == null) {
            error = expected != null;
        } else {
            boolean bl = error = !actual.equals(expected);
        }
        if (error) {
            this.verificationError(arg, "Incorrect " + nodeType + ": expected " + expected + ", but found " + actual);
        }
    }

    private void handleEmitter(Node arg, EmitterFactory.Emitter em) {
        if (this.preparing()) {
            ASMUtil.emitter.set(arg, em);
        } else {
            EmitterFactory.Emitter lem = ASMUtil.emitter.get(arg);
            this.compareEmitter("emitter", arg, em, lem);
        }
    }

    private void initializeVariableEmitter(Variable param) {
        VariableInternal arg = (VariableInternal)param;
        EmitterFactory.Emitter em = null;
        ASMUtil.RequiredEmitterType ret = ASMUtil.requiredEmitterType.get(arg);
        if (ret != ASMUtil.RequiredEmitterType.NONE) {
            em = ret == ASMUtil.RequiredEmitterType.SETTER ? ASMUtil.setEmitter.get(arg) : ASMUtil.getEmitter.get(arg);
            this.handleEmitter(arg, em);
        }
    }

    private void defineLocalVariable(Variable arg) {
        this.allocateLocalVariable(arg);
        this.finishVariableDefinition(arg);
    }

    private void allocateLocalVariable(Variable param) {
        VariableInternal arg = (VariableInternal)param;
        assert (this.slotAllocator != null);
        int sfs = this.slotAllocator.getSlot(arg.type());
        if (this.preparing()) {
            ASMUtil.stackFrameSlot.set(arg, sfs);
        } else {
            int slot = ASMUtil.stackFrameSlot.get(arg);
            if (slot != sfs) {
                this.verificationError(arg, "Expected stackFrameSlot to be " + sfs + ", was " + slot);
            }
        }
    }

    private void finishVariableDefinition(Variable param) {
        VariableInternal arg = (VariableInternal)param;
        EmitterFactory.Emitter getter = EmitterFactory.makeEmitter(arg, false);
        EmitterFactory.Emitter setter = EmitterFactory.makeEmitter(arg, true);
        if (this.preparing()) {
            ASMUtil.getEmitter.set(arg, getter);
            ASMUtil.setEmitter.set(arg, setter);
        } else {
            EmitterFactory.Emitter lgetter = ASMUtil.getEmitter.get(arg);
            this.compareEmitter("getEmitter", arg, getter, lgetter);
            EmitterFactory.Emitter lsetter = ASMUtil.setEmitter.get(arg);
            this.compareEmitter("setEmitter", arg, setter, lsetter);
        }
    }

    @Override
    public boolean preVariable(Variable arg) {
        switch (this.variableDefiningContext) {
            case REFERENCE: {
                ASMUtil.requiredEmitterType.set((VariableInternal)arg, ASMUtil.RequiredEmitterType.GETTER);
                this.initializeVariableEmitter(arg);
                break;
            }
            case DEFINE_LOCAL: {
                this.defineLocalVariable(arg);
                break;
            }
            case DEFINE_LOCAL_DEFINITION: {
                this.defineLocalVariable(arg);
                this.initializeVariableEmitter(arg);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return false;
    }

    @Override
    public boolean preBinaryOperatorExpression(ExpressionFactory.BinaryOperatorExpression arg) {
        return true;
    }

    @Override
    public void binaryOperatorExpressionBeforeRight(ExpressionFactory.BinaryOperatorExpression arg) {
    }

    @Override
    public void postBinaryOperatorExpression(ExpressionFactory.BinaryOperatorExpression arg) {
        this.postExpression(arg);
    }

    public static class ErrorReport {
        public Node node;
        public String msg;
    }

    public static enum Mode {
        PREPARE,
        VERIFY;

    }

    private static enum VariableContext {
        REFERENCE,
        DEFINE_LOCAL,
        DEFINE_LOCAL_DEFINITION;

    }

    static class SlotAllocator {
        private static int id = 0;
        private int myId = id++;
        private int current = 1;

        SlotAllocator() {
        }

        public int getSlot(Type type) {
            int result = this.current;
            this.current += type.size();
            return result;
        }

        public String toString() {
            return "SlotAllocator(" + this.myId + ")[current=" + this.current + "]";
        }
    }
}

