/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.AbstractSessionContextImpl;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EJBTimerServiceWrapper;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.spi.container.StatefulEJBContext;
import com.sun.enterprise.container.common.impl.PhysicalEntityManagerWrapper;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBLocalHome;
import jakarta.ejb.SessionContext;
import jakarta.ejb.TimerService;
import jakarta.persistence.EntityManagerFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.api.invocation.ComponentInvocation;

public final class SessionContextImpl
extends AbstractSessionContextImpl
implements StatefulEJBContext {
    private boolean completedTxStatus;
    private boolean afterCompletionDelayed = false;
    private boolean committing = false;
    private boolean inAfterCompletion = false;
    private boolean isStateless = false;
    private boolean isStateful = false;
    private boolean existsInSessionStore = false;
    private transient int refCount = 0;
    private boolean txCheckpointDelayed;
    private long lastPersistedAt;
    private long version;
    private boolean inLifeCycleCallback = false;
    private transient Map<EntityManagerFactory, PhysicalEntityManagerWrapper> extendedEntityManagerMap;
    private transient Set<EntityManagerFactory> emfsRegisteredWithTx;
    private Collection<StatefulSessionContainer.EEMRefInfo> eemRefInfos = new HashSet<StatefulSessionContainer.EEMRefInfo>();
    private transient ReentrantReadWriteLock statefulSerializedAccessLock;

    SessionContextImpl(Object ejb, BaseContainer container) {
        super(ejb, container);
        EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)this.getContainer().getEjbDescriptor();
        this.isStateless = sessionDesc.isStateless();
        this.isStateful = sessionDesc.isStateful();
        if (this.isStateful) {
            this.initializeStatefulWriteLock();
        }
    }

    public Map<EntityManagerFactory, PhysicalEntityManagerWrapper> getExtendedEntityManagerMap() {
        if (this.extendedEntityManagerMap == null) {
            this.extendedEntityManagerMap = new HashMap<EntityManagerFactory, PhysicalEntityManagerWrapper>();
        }
        return this.extendedEntityManagerMap;
    }

    Collection<StatefulSessionContainer.EEMRefInfo> getAllEEMRefInfos() {
        return this.eemRefInfos;
    }

    void setEEMRefInfos(Collection<StatefulSessionContainer.EEMRefInfo> val) {
        if (val != null) {
            this.eemRefInfos = val;
        }
    }

    public void addExtendedEntityManagerMapping(EntityManagerFactory emf, StatefulSessionContainer.EEMRefInfo refInfo) {
        this.getExtendedEntityManagerMap().put(emf, new PhysicalEntityManagerWrapper(refInfo.getEntityManager(), refInfo.getSynchronizationType()));
    }

    public PhysicalEntityManagerWrapper getExtendedEntityManager(EntityManagerFactory emf) {
        return this.getExtendedEntityManagerMap().get(emf);
    }

    public Collection<PhysicalEntityManagerWrapper> getExtendedEntityManagers() {
        return this.getExtendedEntityManagerMap().values();
    }

    private Set<EntityManagerFactory> getEmfsRegisteredWithTx() {
        if (this.emfsRegisteredWithTx == null) {
            this.emfsRegisteredWithTx = new HashSet<EntityManagerFactory>();
        }
        return this.emfsRegisteredWithTx;
    }

    public void setEmfRegisteredWithTx(EntityManagerFactory emf, boolean flag) {
        if (flag) {
            this.getEmfsRegisteredWithTx().add(emf);
        } else {
            this.getEmfsRegisteredWithTx().remove(emf);
        }
    }

    public boolean isEmfRegisteredWithTx(EntityManagerFactory emf) {
        return this.getEmfsRegisteredWithTx().contains(emf);
    }

    public void initializeStatefulWriteLock() {
        this.statefulSerializedAccessLock = new ReentrantReadWriteLock(true);
    }

    public ReentrantReadWriteLock.WriteLock getStatefulWriteLock() {
        return this.statefulSerializedAccessLock.writeLock();
    }

    public void setStatefulWriteLock(SessionContextImpl other) {
        this.statefulSerializedAccessLock = other.statefulSerializedAccessLock;
    }

    @Override
    public TimerService getTimerService() throws IllegalStateException {
        if (this.isStateful) {
            throw new IllegalStateException("EJBTimer Service is not accessible to Stateful Session ejbs");
        }
        if (this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        EJBTimerService timerService = EJBTimerService.getValidEJBTimerService();
        return new EJBTimerServiceWrapper(timerService, this);
    }

    @Override
    protected void checkAccessToCallerSecurity() throws IllegalStateException {
        if (this.isStateless ? this.state == EJBContextImpl.BeanState.CREATED || this.inEjbRemove : this.state == EJBContextImpl.BeanState.CREATED) {
            throw new IllegalStateException("Operation not allowed");
        }
    }

    @Override
    public void checkTimerServiceMethodAccess() throws IllegalStateException {
        ComponentInvocation compInv = this.getCurrentComponentInvocation();
        if (this.isStateful && (this.inStatefulSessionEjbCreate(compInv) || this.inActivatePassivate(compInv) || this.inAfterCompletion)) {
            throw new IllegalStateException("EJB Timer methods for stateful session beans cannot be  called in this context");
        }
        if (this.state == EJBContextImpl.BeanState.CREATED || this.inEjbRemove) {
            throw new IllegalStateException("EJB Timer method calls cannot be called in this context");
        }
    }

    boolean getCompletedTxStatus() {
        return this.completedTxStatus;
    }

    void setCompletedTxStatus(boolean s) {
        this.completedTxStatus = s;
    }

    boolean isAfterCompletionDelayed() {
        return this.afterCompletionDelayed;
    }

    void setAfterCompletionDelayed(boolean s) {
        this.afterCompletionDelayed = s;
    }

    boolean isTxCompleting() {
        return this.committing;
    }

    void setTxCompleting(boolean s) {
        this.committing = s;
    }

    void setInAfterCompletion(boolean flag) {
        this.inAfterCompletion = flag;
    }

    void setInLifeCycleCallback(boolean s) {
        this.inLifeCycleCallback = s;
    }

    boolean getInLifeCycleCallback() {
        return this.inLifeCycleCallback;
    }

    private boolean inStatefulSessionEjbCreate(ComponentInvocation inv) {
        boolean inEjbCreate = false;
        if (inv instanceof EjbInvocation) {
            Class clientIntf = ((EjbInvocation)inv).clientInterface;
            inEjbCreate = ((EjbInvocation)inv).isHome && (EJBHome.class.isAssignableFrom(clientIntf) || EJBLocalHome.class.isAssignableFrom(clientIntf));
        }
        return inEjbCreate;
    }

    void setTxCheckpointDelayed(boolean val) {
        this.txCheckpointDelayed = val;
    }

    boolean isTxCheckpointDelayed() {
        return this.txCheckpointDelayed;
    }

    long getLastPersistedAt() {
        return this.lastPersistedAt;
    }

    void setLastPersistedAt(long val) {
        this.lastPersistedAt = val;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public long incrementAndGetVersion() {
        return ++this.version;
    }

    @Override
    public void setVersion(long newVersion) {
        this.version = newVersion;
    }

    @Override
    public long getLastAccessTime() {
        return this.getLastTimeUsed();
    }

    @Override
    public boolean canBePassivated() {
        return this.state == EJBContextImpl.BeanState.READY;
    }

    public boolean hasExtendedPC() {
        return this.getExtendedEntityManagerMap().size() != 0;
    }

    @Override
    public SessionContext getSessionContext() {
        return this;
    }

    @Override
    public boolean existsInStore() {
        return this.existsInSessionStore;
    }

    @Override
    public void setExistsInStore(boolean val) {
        this.existsInSessionStore = val;
    }

    public final void incrementRefCount() {
        ++this.refCount;
    }

    public final void decrementRefCount() {
        --this.refCount;
    }

    public final int getRefCount() {
        return this.refCount;
    }
}

