/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.json;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.optional.api.SimpleJsonUtils;
import org.apache.derby.optional.utils.ToolUtilities;
import org.json.simple.JSONArray;

public class SimpleJsonTool
implements OptionalTool {
    private FunctionDescriptor[] _functionDescriptors = new FunctionDescriptor[]{new FunctionDescriptor("toJSON", "create function toJSON\n(\n\tqueryString varchar( 32672 ),\n\tqueryArgs varchar( 32672 ) ...\n)\nreturns JSONArray\n\nlanguage java parameter style derby reads sql data\nexternal name 'org.apache.derby.optional.json.SimpleJsonTool.toJSON'\n"), new FunctionDescriptor("readArrayFromString", "create function readArrayFromString( document varchar( 32672 ) )\nreturns JSONArray\nlanguage java parameter style java contains sql\nexternal name 'org.apache.derby.optional.api.SimpleJsonUtils.readArrayFromString'\n"), new FunctionDescriptor("readArrayFromFile", "create function readArrayFromFile\n( fileName varchar( 32672 ), characterSetName varchar( 100 ) )\nreturns JSONArray\nlanguage java parameter style java contains sql\nexternal name 'org.apache.derby.optional.api.SimpleJsonUtils.readArrayFromFile'\n"), new FunctionDescriptor("readArrayFromURL", "create function readArrayFromURL\n( urlString varchar( 32672 ), characterSetName varchar( 100 ) )\nreturns JSONArray\nlanguage java parameter style java contains sql\nexternal name 'org.apache.derby.optional.api.SimpleJsonUtils.readArrayFromURL'\n"), new FunctionDescriptor("arrayToClob", "create function arrayToClob( jsonDocument JSONArray ) returns clob\nlanguage java parameter style java no sql\nexternal name 'org.apache.derby.optional.api.SimpleJsonUtils.arrayToClob'")};

    public void loadTool(String ... stringArray) throws SQLException {
        if (stringArray != null && stringArray.length != 0) {
            throw this.wrap(LocalizedResource.getMessage((String)"OT_BadLoadUnloadArgs", (Object[])new Object[0]));
        }
        Connection connection = SimpleJsonTool.getDerbyConnection();
        this.createUDT(connection);
        this.createFunctions(connection);
        boolean bl = ToolUtilities.sqlAuthorizationEnabled(connection);
        if (bl) {
            this.grantPermissions(connection);
        }
    }

    private void grantPermissions(Connection connection) throws SQLException {
        this.executeDDL(connection, "grant usage on type JSONArray to public");
        for (FunctionDescriptor functionDescriptor : this._functionDescriptors) {
            this.executeDDL(connection, "grant execute on function " + functionDescriptor.functionName + " to public");
        }
    }

    public void unloadTool(String ... stringArray) throws SQLException {
        if (stringArray != null && stringArray.length != 0) {
            throw this.wrap(LocalizedResource.getMessage((String)"OT_BadLoadUnloadArgs", (Object[])new Object[0]));
        }
        Connection connection = SimpleJsonTool.getDerbyConnection();
        this.dropFunctions(connection);
        this.dropUDT(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray toJSON(String string, String ... stringArray) throws SQLException {
        try (PreparedStatement preparedStatement = null;){
            Connection connection = SimpleJsonTool.getDerbyConnection();
            preparedStatement = connection.prepareStatement(string);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    preparedStatement.setString(i + 1, stringArray[i]);
                }
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            JSONArray jSONArray = SimpleJsonUtils.toJSON(resultSet);
            return jSONArray;
        }
    }

    private void createUDT(Connection connection) throws SQLException {
        String string = "create type JSONArray external name 'org.json.simple.JSONArray' language java";
        this.executeDDL(connection, string);
    }

    private void dropUDT(Connection connection) throws SQLException {
        String string = "drop type JSONArray restrict";
        this.executeDDL(connection, string);
    }

    private void createFunctions(Connection connection) throws SQLException {
        for (FunctionDescriptor functionDescriptor : this._functionDescriptors) {
            this.executeDDL(connection, functionDescriptor.creationDDL);
        }
    }

    private void dropFunctions(Connection connection) throws SQLException {
        for (FunctionDescriptor functionDescriptor : this._functionDescriptors) {
            String string = "drop function " + functionDescriptor.functionName;
            this.executeDDL(connection, string);
        }
    }

    private void executeDDL(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(connection, string);
        preparedStatement.execute();
        preparedStatement.close();
    }

    private PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        return connection.prepareStatement(string);
    }

    private SQLException wrap(String string) {
        String string2 = "XJ001.U".substring(0, 5);
        return new SQLException(string, string2);
    }

    private static Connection getDerbyConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }

    public static final class FunctionDescriptor {
        public final String functionName;
        public final String creationDDL;

        public FunctionDescriptor(String string, String string2) {
            this.functionName = string;
            this.creationDDL = string2;
        }
    }
}

