/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.ejb;

import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.BeanAttributes;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bean.BeanIdentifiers;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.attributes.BeanAttributesFactory;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.ejb.InternalEjbDescriptor;
import org.jboss.weld.module.ejb.SessionBeanHierarchyDiscovery;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.Reflections;

class SessionBeans {
    private SessionBeans() {
    }

    public static <T> EnhancedAnnotatedType<T> getEjbImplementationClass(SessionBean<T> bean) {
        return SessionBeans.getEjbImplementationClass(bean.getEjbDescriptor(), bean.getBeanManager(), bean.getEnhancedAnnotated());
    }

    public static <T> EnhancedAnnotatedType<T> getEjbImplementationClass(EjbDescriptor<T> descriptor, BeanManagerImpl manager, EnhancedAnnotatedType<T> componentType) {
        InternalEjbDescriptor<T> ejbDescriptor = InternalEjbDescriptor.of(descriptor);
        if (ejbDescriptor.getBeanClass().equals(ejbDescriptor.getImplementationClass())) {
            return componentType;
        }
        ClassTransformer transformer = manager.getServices().get(ClassTransformer.class);
        EnhancedAnnotatedType implementationClass = (EnhancedAnnotatedType)Reflections.cast(transformer.getEnhancedAnnotatedType(ejbDescriptor.getImplementationClass(), manager.getId()));
        manager.getServices().get(SlimAnnotatedTypeStore.class).put(implementationClass.slim());
        return implementationClass;
    }

    public static String createIdentifier(EnhancedAnnotatedType<?> type, EjbDescriptor<?> descriptor) {
        StringBuilder builder = BeanIdentifiers.getPrefix(SessionBean.class);
        SessionBeans.appendEjbNameAndClass(builder, descriptor);
        if (!type.isDiscovered()) {
            builder.append("%").append(((AnnotatedTypeIdentifier)type.slim().getIdentifier()).asString());
        }
        return builder.toString();
    }

    private static StringBuilder appendEjbNameAndClass(StringBuilder builder, EjbDescriptor<?> descriptor) {
        return builder.append(descriptor.getEjbName()).append("%").append(descriptor.getBeanClass().getName());
    }

    public static <T> BeanAttributes<T> createBeanAttributes(EnhancedAnnotatedType<T> annotated, InternalEjbDescriptor<?> descriptor, BeanManagerImpl manager) {
        Set<Type> types = SharedObjectCache.instance(manager).getSharedSet(SessionBeans.getSessionBeanTypes(annotated, (EjbDescriptor)Reflections.cast(descriptor)));
        return new BeanAttributesFactory.BeanAttributesBuilder(annotated, types, manager).build();
    }

    private static <T> Set<Type> getSessionBeanTypes(EnhancedAnnotated<T, ?> annotated, EjbDescriptor<T> ejbDescriptor) {
        ImmutableSet.Builder<Type> types = ImmutableSet.builder();
        LinkedHashMap typeMap = new LinkedHashMap();
        HierarchyDiscovery beanClassDiscovery = HierarchyDiscovery.forNormalizedType(ejbDescriptor.getBeanClass());
        for (BusinessInterfaceDescriptor<?> businessInterfaceDescriptor : ejbDescriptor.getLocalBusinessInterfaces()) {
            Type resolvedLocalInterface = beanClassDiscovery.resolveType(Types.getCanonicalType(businessInterfaceDescriptor.getInterface()));
            SessionBeanHierarchyDiscovery interfaceDiscovery = new SessionBeanHierarchyDiscovery(resolvedLocalInterface);
            if (beanClassDiscovery.getTypeMap().containsKey(businessInterfaceDescriptor.getInterface())) {
                for (Map.Entry<Class<?>, Type> entry : interfaceDiscovery.getTypeMap().entrySet()) {
                    if (!annotated.getTypeClosure().contains(entry.getValue())) continue;
                    typeMap.put(entry.getKey(), entry.getValue());
                }
                continue;
            }
            typeMap.putAll(interfaceDiscovery.getTypeMap());
        }
        if (annotated.isAnnotationPresent(Typed.class)) {
            types.addAll((Iterable<Type>)Beans.getTypedTypes(typeMap, annotated.getJavaClass(), (Typed)annotated.getAnnotation(Typed.class)));
        } else {
            typeMap.put(Object.class, (Type)((Object)Object.class));
            types.addAll(typeMap.values());
        }
        return Beans.getLegalBeanTypes(types.build(), annotated, new Type[0]);
    }
}

