/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.util;

import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.InterceptorBindingDescriptor;

public class InterceptorBindingTranslator {
    private final List<InterceptorBindingDescriptor> interceptorBindings;
    private final EjbBundleDescriptorImpl ejbBundle;
    private final List<String> defaultInterceptorChain = new LinkedList<String>();
    private final List<String> classInterceptorChain = new LinkedList<String>();
    private boolean hasTotalClassLevelOrdering;
    private final List<String> totalClassLevelOrdering = new LinkedList<String>();
    private final Map<MethodDescriptor, LinkedList<String>> methodInterceptorsMap = new HashMap<MethodDescriptor, LinkedList<String>>();
    private boolean isEmpty;

    public InterceptorBindingTranslator(EjbBundleDescriptorImpl bundle) {
        this.ejbBundle = bundle;
        this.interceptorBindings = new ArrayList<InterceptorBindingDescriptor>(this.ejbBundle.getInterceptorBindings());
        if (this.interceptorBindings.isEmpty()) {
            this.isEmpty = true;
        } else {
            this.validateInterceptors();
        }
    }

    public TranslationResults apply(String ejbName) {
        if (this.isEmpty) {
            return new TranslationResults();
        }
        this.defaultInterceptorChain.clear();
        this.classInterceptorChain.clear();
        this.hasTotalClassLevelOrdering = false;
        this.totalClassLevelOrdering.clear();
        this.methodInterceptorsMap.clear();
        for (Object binding : this.interceptorBindings) {
            if (binding.getBindingType() != InterceptorBindingDescriptor.BindingType.DEFAULT) continue;
            this.defaultInterceptorChain.addAll(binding.getInterceptorClasses());
        }
        for (Object binding : this.interceptorBindings) {
            if (binding.getBindingType() != InterceptorBindingDescriptor.BindingType.CLASS || !binding.getEjbName().equals(ejbName)) continue;
            this.processClassLevelBinding((InterceptorBindingDescriptor)((Object)binding));
        }
        HashMap<MethodDescriptor, LinkedList<InterceptorBindingDescriptor>> methodBindings = new HashMap<MethodDescriptor, LinkedList<InterceptorBindingDescriptor>>();
        for (InterceptorBindingDescriptor interceptorBindingDescriptor : this.interceptorBindings) {
            if (!interceptorBindingDescriptor.getEjbName().equals(ejbName) || interceptorBindingDescriptor.getBindingType() != InterceptorBindingDescriptor.BindingType.METHOD) continue;
            MethodDescriptor method = interceptorBindingDescriptor.getBusinessMethod();
            LinkedList<InterceptorBindingDescriptor> methodBindingDescs = (LinkedList<InterceptorBindingDescriptor>)methodBindings.get(method);
            if (methodBindingDescs == null) {
                methodBindingDescs = new LinkedList<InterceptorBindingDescriptor>();
            }
            methodBindingDescs.add(interceptorBindingDescriptor);
            methodBindings.put(method, methodBindingDescs);
        }
        for (Map.Entry entry : methodBindings.entrySet()) {
            this.processMethod((MethodDescriptor)entry.getKey(), (List)entry.getValue());
        }
        TranslationResults results = this.buildResults();
        return results;
    }

    private void processClassLevelBinding(InterceptorBindingDescriptor binding) {
        if (binding.getExcludeDefaultInterceptors()) {
            this.defaultInterceptorChain.clear();
        }
        if (binding.getIsTotalOrdering()) {
            this.hasTotalClassLevelOrdering = true;
            this.totalClassLevelOrdering.clear();
            this.totalClassLevelOrdering.addAll(binding.getInterceptorClasses());
            for (String next : binding.getInterceptorClasses()) {
                if (this.defaultInterceptorChain.contains(next) || this.classInterceptorChain.contains(next)) continue;
                this.classInterceptorChain.add(next);
            }
        } else {
            this.classInterceptorChain.addAll(binding.getInterceptorClasses());
        }
    }

    private void processMethod(MethodDescriptor businessMethod, List<InterceptorBindingDescriptor> bindings) {
        LinkedList<String> tempDefaultInterceptorChain = new LinkedList<String>();
        LinkedList<String> tempClassInterceptorChain = new LinkedList<String>();
        LinkedList<String> tempMethodInterceptorChain = new LinkedList<String>();
        if (this.hasTotalClassLevelOrdering) {
            tempClassInterceptorChain.addAll(this.totalClassLevelOrdering);
        } else {
            tempDefaultInterceptorChain.addAll(this.defaultInterceptorChain);
            tempClassInterceptorChain.addAll(this.classInterceptorChain);
        }
        for (InterceptorBindingDescriptor nextBinding : bindings) {
            if (nextBinding.getExcludeDefaultInterceptors()) {
                if (this.hasTotalClassLevelOrdering) {
                    tempClassInterceptorChain.removeAll(this.defaultInterceptorChain);
                } else {
                    tempDefaultInterceptorChain.clear();
                }
            }
            if (nextBinding.getExcludeClassInterceptors()) {
                if (this.hasTotalClassLevelOrdering) {
                    tempClassInterceptorChain.removeAll(this.classInterceptorChain);
                } else {
                    tempClassInterceptorChain.clear();
                }
            }
            if (nextBinding.getIsTotalOrdering()) {
                tempDefaultInterceptorChain.clear();
                tempClassInterceptorChain.clear();
                tempMethodInterceptorChain.clear();
            }
            tempMethodInterceptorChain.addAll(nextBinding.getInterceptorClasses());
        }
        LinkedList<String> methodInterceptors = new LinkedList<String>();
        methodInterceptors.addAll(tempDefaultInterceptorChain);
        methodInterceptors.addAll(tempClassInterceptorChain);
        methodInterceptors.addAll(tempMethodInterceptorChain);
        this.methodInterceptorsMap.put(businessMethod, methodInterceptors);
    }

    private TranslationResults buildResults() {
        EjbInterceptor interceptor;
        TranslationResults results = new TranslationResults();
        if (this.hasTotalClassLevelOrdering) {
            for (String string : this.totalClassLevelOrdering) {
                interceptor = this.ejbBundle.getInterceptorByClassName(string);
                results.allInterceptorClasses.add(interceptor);
                results.classInterceptorChain.add(interceptor);
            }
        } else {
            for (String string : this.defaultInterceptorChain) {
                interceptor = this.ejbBundle.getInterceptorByClassName(string);
                results.allInterceptorClasses.add(interceptor);
                results.classInterceptorChain.add(interceptor);
            }
            for (String string : this.classInterceptorChain) {
                interceptor = this.ejbBundle.getInterceptorByClassName(string);
                results.allInterceptorClasses.add(interceptor);
                results.classInterceptorChain.add(interceptor);
            }
        }
        for (Map.Entry entry : this.methodInterceptorsMap.entrySet()) {
            List interceptorClassChain = (List)entry.getValue();
            LinkedList<EjbInterceptor> interceptorChain = new LinkedList<EjbInterceptor>();
            for (String nextClass : interceptorClassChain) {
                EjbInterceptor interceptor2 = this.ejbBundle.getInterceptorByClassName(nextClass);
                results.allInterceptorClasses.add(interceptor2);
                interceptorChain.add(interceptor2);
            }
            results.methodInterceptorsMap.put((MethodDescriptor)entry.getKey(), interceptorChain);
        }
        return results;
    }

    private void validateInterceptors() {
        for (InterceptorBindingDescriptor binding : this.interceptorBindings) {
            for (String interceptor : binding.getInterceptorClasses()) {
                if (this.ejbBundle.getInterceptorByClassName(interceptor) != null) continue;
                throw new IllegalStateException("Interceptor binding contains an interceptor class  name = " + interceptor + " that is not defined as an interceptor");
            }
        }
    }

    public static class TranslationResults {
        public Set<EjbInterceptor> allInterceptorClasses = new HashSet<EjbInterceptor>();
        public List<EjbInterceptor> classInterceptorChain = new LinkedList<EjbInterceptor>();
        public Map<MethodDescriptor, List<EjbInterceptor>> methodInterceptorsMap = new HashMap<MethodDescriptor, List<EjbInterceptor>>();
    }
}

