/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.util.OS;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.main.jul.GlassFishLogManager;

class StartServerShutdownHook
extends Thread {
    private static final System.Logger LOG = System.getLogger(StartServerShutdownHook.class.getName());
    private static final boolean LOG_RESTART = Boolean.parseBoolean(System.getenv("AS_RESTART_LOGFILES"));
    private static final Path CFGDIR = new File(System.getProperty("com.sun.aas.instanceRoot"), "config").toPath().toAbsolutePath();
    private static final Path LOGDIR = new File(System.getProperty("com.sun.aas.instanceRoot"), "logs").toPath().toAbsolutePath();
    private static final Predicate<Thread> FILTER_OTHER_HOOKS = t -> t.getName().startsWith("GlassFish") && t.getName().endsWith("Shutdown Hook");
    private final PrintStream logFile;
    private final ProcessBuilder builder;
    private final Instant startTime;

    StartServerShutdownHook(String classpath, String[] sysProps, String classname, String[] args) {
        super("GlassFish Restart Shutdown Hook");
        this.setDaemon(false);
        if (classname == null || classname.isBlank()) {
            throw new IllegalArgumentException("classname was null");
        }
        this.startTime = Instant.now();
        this.logFile = StartServerShutdownHook.getLogFileOld(this.startTime);
        this.builder = StartServerShutdownHook.prepareStartup(this.startTime, classpath, sysProps, classname, args);
    }

    @Override
    public void run() {
        try {
            Thread.onSpinWait();
            this.waitForThreads(FILTER_OTHER_HOOKS);
            LOG.log(System.Logger.Level.INFO, "Starting process {0} in directory {1}", this.builder.command(), this.builder.directory());
            this.stopLogging();
            this.startGlassFishInstance();
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.ERROR, "Failed to execute shutdown hook for server start. Restart failed.", (Throwable)e);
            this.log(e);
        }
        finally {
            if (this.logFile != null) {
                this.logFile.close();
            }
        }
    }

    private void stopLogging() {
        GlassFishLogManager logManager = GlassFishLogManager.getLogManager();
        if (logManager == null) {
            return;
        }
        logManager.getAllHandlers().forEach(Handler::close);
    }

    private void startGlassFishInstance() {
        try {
            this.builder.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("GlassFish instance startup failed.", e);
        }
    }

    private void waitForThreads(Predicate<Thread> filter) {
        Thread thread;
        Thread[] threads = this.getThreadsToDie(filter);
        this.log(() -> "Waiting for shutdown of threads:\n" + StartServerShutdownHook.toString(threads));
        while ((thread = this.getFirstAlive(threads)) != null) {
            try {
                thread.join();
                this.log(() -> "Joined thread " + StartServerShutdownHook.toString(thread));
            }
            catch (InterruptedException e) {
                this.log(e);
            }
        }
    }

    private Thread[] getThreadsToDie(Predicate<Thread> filter) {
        Thread[] threads = new Thread[Thread.activeCount() + 10];
        Thread.enumerate(threads);
        this.log(() -> "Found threads:\n" + StartServerShutdownHook.toString(threads));
        return (Thread[])Stream.of(threads).filter(Objects::nonNull).filter(t -> t != this).filter(t -> !t.isDaemon()).filter(filter).toArray(Thread[]::new);
    }

    private Thread getFirstAlive(Thread[] shutdown) {
        for (Thread thread : shutdown) {
            if (!thread.isAlive()) continue;
            return thread;
        }
        return null;
    }

    private void log(Supplier<String> message) {
        if (this.logFile == null) {
            return;
        }
        this.logFile.append(Instant.now().toString()).append(' ').append(message.get()).append('\n');
        this.logFile.flush();
    }

    private void log(Exception e) {
        if (this.logFile == null) {
            return;
        }
        this.logFile.append(Instant.now().toString()).append(' ').append(e.getMessage()).append('\n');
        e.printStackTrace(this.logFile);
        this.logFile.append('\n').flush();
    }

    private static PrintStream getLogFileOld(Instant startTime) {
        if (!LOG_RESTART) {
            return null;
        }
        try {
            return new PrintStream(LOGDIR.resolve("restart-" + String.valueOf(startTime) + "-old.log").toFile());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static ProcessBuilder prepareStartup(Instant startTime, String classpath, String[] sysprops, String classname, String[] args) {
        ArrayList<String> outerCommand;
        Path javaExecutable = StartServerShutdownHook.detectJavaExecutable();
        ArrayList<String> cmdline = new ArrayList<String>();
        if (!OS.isWindows()) {
            cmdline.add("nohup");
        }
        cmdline.add(javaExecutable.toFile().getAbsolutePath());
        cmdline.add("-cp");
        cmdline.add(classpath);
        if (sysprops != null) {
            for (String sysprop : sysprops) {
                cmdline.add(sysprop);
            }
        }
        cmdline.add(classname);
        if (args != null) {
            for (String arg : args) {
                cmdline.add(arg);
            }
        }
        if (OS.isWindows() || OS.isDarwin()) {
            outerCommand = cmdline;
        } else {
            outerCommand = new ArrayList();
            outerCommand.add("nohup");
            outerCommand.add("bash");
            outerCommand.add("-c");
            outerCommand.add("(waitpid -e " + ProcessHandle.current().pid() + " || sleep 1) && '" + cmdline.stream().collect(Collectors.joining("' '")) + (String)(LOG_RESTART ? "' > '" + String.valueOf(LOGDIR.resolve("restart-" + String.valueOf(startTime) + "-new.log'")) : "'"));
        }
        ProcessBuilder builder = new ProcessBuilder(outerCommand);
        builder.directory(new File(System.getProperty("user.dir")));
        builder.redirectError(ProcessBuilder.Redirect.DISCARD);
        builder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
        return builder;
    }

    private static Path detectJavaExecutable() {
        String javaName = OS.isWindows() ? "java.exe" : "java";
        Path javaroot = Path.of(System.getProperty("java.home"), new String[0]);
        return javaroot.resolve("bin").resolve(javaName);
    }

    private static String toString(Thread[] threads) {
        return Arrays.stream(threads).filter(Objects::nonNull).map(StartServerShutdownHook::toString).collect(Collectors.joining("\n"));
    }

    private static String toString(Thread thread) {
        return "Thread[" + "id=" + thread.getId() + ", name=" + thread.getName() + ", daemon=" + thread.isDaemon() + ", priority=" + thread.getPriority() + ", state=" + (Object)((Object)thread.getState()) + ", classloader=" + thread.getContextClassLoader() + ']';
    }
}

