/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.convert;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.convert.MessageFactory;
import java.math.BigInteger;

public class BigIntegerConverter
implements Converter {
    public static final String CONVERTER_ID = "jakarta.faces.BigInteger";
    public static final String BIGINTEGER_ID = "jakarta.faces.converter.BigIntegerConverter.BIGINTEGER";
    public static final String STRING_ID = "jakarta.faces.converter.STRING";

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        try {
            return new BigInteger(value);
        }
        catch (NumberFormatException nfe) {
            throw new ConverterException(MessageFactory.getMessage(context, BIGINTEGER_ID, value, "9876", MessageFactory.getLabel(context, component)), (Throwable)nfe);
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return value.toString();
        }
        catch (Exception e) {
            throw new ConverterException(MessageFactory.getMessage(context, STRING_ID, value, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
    }
}

