/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Vector;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRowBuilder;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.impl.sql.execute.AggregatorInfo;
import org.apache.derby.impl.sql.execute.AggregatorInfoList;
import org.apache.derby.impl.sql.execute.GenericAggregator;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.shared.common.error.SQLWarningFactory;
import org.apache.derby.shared.common.error.StandardException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class GenericAggregateResultSet
extends NoPutResultSetImpl {
    protected GenericAggregator[] aggregates;
    protected AggregatorInfoList aggInfoList;
    public NoPutResultSet source;
    protected NoPutResultSet originalSource;
    private final ExecIndexRow rowTemplate;

    GenericAggregateResultSet(NoPutResultSet noPutResultSet, int n, Activation activation, int n2, int n3, double d, double d2) throws StandardException {
        super(activation, n3, d, d2);
        this.source = noPutResultSet;
        this.originalSource = noPutResultSet;
        ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
        ExecutionFactory executionFactory = activation.getExecutionFactory();
        this.rowTemplate = executionFactory.getIndexableRow(((ExecRowBuilder)execPreparedStatement.getSavedObject(n2)).build(executionFactory));
        this.aggInfoList = (AggregatorInfoList)execPreparedStatement.getSavedObject(n);
        this.aggregates = this.getSortAggregators(this.aggInfoList, false, activation.getLanguageConnectionContext(), noPutResultSet);
    }

    ExecIndexRow getRowTemplate() {
        return this.rowTemplate;
    }

    protected final GenericAggregator[] getSortAggregators(AggregatorInfoList aggregatorInfoList, boolean bl, LanguageConnectionContext languageConnectionContext, NoPutResultSet noPutResultSet) throws StandardException {
        Vector<GenericAggregator> vector = new Vector<GenericAggregator>();
        ClassFactory classFactory = languageConnectionContext.getLanguageConnectionFactory().getClassFactory();
        for (AggregatorInfo aggregatorInfo : aggregatorInfoList) {
            if (bl && aggregatorInfo.isDistinct()) continue;
            vector.addElement(new GenericAggregator(aggregatorInfo, classFactory));
        }
        Object[] objectArray = new GenericAggregator[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected final ExecIndexRow finishAggregation(ExecIndexRow execIndexRow) throws StandardException {
        int n = this.aggregates.length;
        if (execIndexRow == null) {
            execIndexRow = this.getRowTemplate();
        }
        this.setCurrentRow(execIndexRow);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            GenericAggregator genericAggregator = this.aggregates[i];
            if (!genericAggregator.finish(execIndexRow)) continue;
            bl = true;
        }
        if (bl) {
            this.addWarning(SQLWarningFactory.newSQLWarning("01003", new Object[0]));
        }
        return execIndexRow;
    }

    @Override
    public void finish() throws StandardException {
        this.source.finish();
        super.finish();
    }

    @Override
    public Element toXML(Element element, String string) throws Exception {
        Element element2 = super.toXML(element, string);
        NodeList nodeList = element2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(0);
            if (!"originalSource".equals(node.getNodeName())) continue;
            element2.removeChild(node);
        }
        return element2;
    }
}

