/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.hk2;

import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.InjecteeImpl;
import org.glassfish.hk2.utilities.NamedImpl;

public class HK2IntegrationUtilities {
    private static final String APP_SL_NAME = "java:app/hk2/ServiceLocator";

    public static ServiceLocator getApplicationServiceLocator() {
        try {
            return (ServiceLocator)new InitialContext().lookup(APP_SL_NAME);
        }
        catch (NamingException ne) {
            return null;
        }
    }

    private static Set<Annotation> getHK2Qualifiers(InjectionPoint injectionPoint) {
        Set setQualifiers = injectionPoint.getQualifiers();
        HashSet<Annotation> hk2Qualifiers = new HashSet<Annotation>();
        for (Annotation annotation : setQualifiers) {
            Annotated annotated;
            Named named;
            if (annotation.annotationType().equals(Default.class)) continue;
            if (annotation.annotationType().equals(Named.class) && "".equals((named = (Named)annotation).value()) && (annotated = injectionPoint.getAnnotated()) instanceof AnnotatedField) {
                AnnotatedField annotatedField = (AnnotatedField)annotated;
                annotation = new NamedImpl(annotatedField.getJavaMember().getName());
            }
            hk2Qualifiers.add(annotation);
        }
        return hk2Qualifiers;
    }

    public static Injectee convertInjectionPointToInjectee(InjectionPoint injectionPoint) {
        InjecteeImpl injectee = new InjecteeImpl(injectionPoint.getType());
        injectee.setRequiredQualifiers(HK2IntegrationUtilities.getHK2Qualifiers(injectionPoint));
        injectee.setParent((AnnotatedElement)((Object)injectionPoint.getMember()));
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated instanceof AnnotatedField) {
            injectee.setPosition(-1);
        } else {
            AnnotatedParameter annotatedParameter = (AnnotatedParameter)annotated;
            injectee.setPosition(annotatedParameter.getPosition());
        }
        return injectee;
    }
}

