/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb;

import com.sun.ejb.codegen.AsmSerializableBeanGenerator;
import com.sun.ejb.codegen.EjbClassGeneratorFactory;
import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.ejb.codegen.Remote30WrapperGenerator;
import com.sun.ejb.codegen.RemoteGenerator;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.GenericEJBLocalHome;
import com.sun.ejb.containers.RemoteBusinessWrapperBase;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.glassfish.api.naming.SimpleJndiName;

public class EJBUtils {
    private static final Logger _logger = LogDomains.getLogger(EJBUtils.class, (String)"jakarta.enterprise.system.container.ejb");
    private static final String EJB_USE_STATIC_CODEGEN_PROP = "com.sun.ejb.UseStaticCodegen";
    private static final String REMOTE30_HOME_JNDI_SUFFIX = "__3_x_Internal_RemoteBusinessHome__";
    private static final String PORTABLE_JNDI_NAME_SEP = "!";
    private static final String GLASSFISH_JNDI_NAME_SEP = "#";
    private static Boolean ejbUseStaticCodegen_;

    public static final byte[] serializeObject(Object obj, boolean replaceObject) throws IOException {
        return EjbContainerUtilImpl.getInstance().getJavaEEIOUtils().serializeObject(obj, replaceObject);
    }

    public static final byte[] serializeObject(Object obj) throws IOException {
        return EjbContainerUtilImpl.getInstance().getJavaEEIOUtils().serializeObject(obj, true);
    }

    public static final Object deserializeObject(byte[] data, ClassLoader loader, boolean resolveObject) throws Exception {
        return EjbContainerUtilImpl.getInstance().getJavaEEIOUtils().deserializeObject(data, resolveObject, loader);
    }

    public static final Object deserializeObject(byte[] data, ClassLoader loader) throws Exception {
        return EjbContainerUtilImpl.getInstance().getJavaEEIOUtils().deserializeObject(data, true, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean useStaticCodegen() {
        Class<EJBUtils> clazz = EJBUtils.class;
        synchronized (EJBUtils.class) {
            if (ejbUseStaticCodegen_ == null) {
                String ejbStaticCodegenProp = System.getProperty(EJB_USE_STATIC_CODEGEN_PROP);
                boolean useStaticCodegen = ejbStaticCodegenProp != null && ejbStaticCodegenProp.equalsIgnoreCase("true");
                ejbUseStaticCodegen_ = useStaticCodegen;
                _logger.log(Level.FINE, "EJB Static codegen is " + (useStaticCodegen ? "ENABLED" : "DISABLED") + " ejbUseStaticCodegenProp = " + ejbStaticCodegenProp);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return ejbUseStaticCodegen_;
        }
    }

    public static String getGeneratedOptionalInterfaceName(String ejbClassName) {
        String packageName = Generator.getPackageName(ejbClassName);
        String simpleName = Generator.getBaseName(ejbClassName);
        String optionalIntfName = "__EJB31_Generated__" + simpleName + "__Intf__";
        return Generator.getFullClassName(packageName, optionalIntfName);
    }

    public static SimpleJndiName getRemoteEjbJndiName(EjbReferenceDescriptor refDesc) {
        String intf = refDesc.isEJB30ClientView() ? refDesc.getEjbInterface() : refDesc.getHomeClassName();
        return EJBUtils.getRemoteEjbJndiName(refDesc.isEJB30ClientView(), intf, refDesc.getJndiName());
    }

    public static SimpleJndiName getRemote30HomeJndiName(SimpleJndiName jndiName) {
        return new SimpleJndiName(String.valueOf(jndiName) + REMOTE30_HOME_JNDI_SUFFIX);
    }

    public static SimpleJndiName getRemoteEjbJndiName(boolean businessView, String interfaceName, SimpleJndiName jndiName) {
        SimpleJndiName returnValue = jndiName;
        String portableFullyQualifiedPortion = PORTABLE_JNDI_NAME_SEP + interfaceName;
        String glassfishFullyQualifiedPortion = GLASSFISH_JNDI_NAME_SEP + interfaceName;
        if (businessView) {
            if (jndiName.hasCorbaPrefix()) {
                int indexOfCorbaNameSep = jndiName.toString().indexOf(GLASSFISH_JNDI_NAME_SEP);
                SimpleJndiName jndiNameMinusCorbaNamePortion = new SimpleJndiName(jndiName.toString().substring(indexOfCorbaNameSep + 1));
                SimpleJndiName newJndiName = jndiName;
                if (jndiNameMinusCorbaNamePortion.isJavaGlobal()) {
                    newJndiName = EJBUtils.stripFullyQualifiedJndiName(jndiName, portableFullyQualifiedPortion);
                } else if (jndiNameMinusCorbaNamePortion.hasSuffix(glassfishFullyQualifiedPortion)) {
                    newJndiName = EJBUtils.stripFullyQualifiedJndiName(jndiName, glassfishFullyQualifiedPortion);
                }
                returnValue = EJBUtils.getRemote30HomeJndiName(newJndiName);
            } else {
                returnValue = jndiName.isJavaGlobal() ? EJBUtils.checkFullyQualifiedJndiName(jndiName, portableFullyQualifiedPortion) : EJBUtils.checkFullyQualifiedJndiName(jndiName, glassfishFullyQualifiedPortion);
            }
        } else if (jndiName.isJavaGlobal()) {
            returnValue = EJBUtils.checkFullyQualifiedJndiName(jndiName, portableFullyQualifiedPortion);
        }
        return returnValue;
    }

    private static SimpleJndiName checkFullyQualifiedJndiName(SimpleJndiName origJndiName, String fullyQualifiedPortion) {
        if (origJndiName.hasSuffix(fullyQualifiedPortion)) {
            return origJndiName;
        }
        return new SimpleJndiName(String.valueOf(origJndiName) + fullyQualifiedPortion);
    }

    private static SimpleJndiName stripFullyQualifiedJndiName(SimpleJndiName origJndiName, String fullyQualifiedPortion) {
        return origJndiName.removeSuffix(fullyQualifiedPortion);
    }

    public static Object resolveEjbRefObject(EjbReferenceDescriptor refDesc, Object jndiObj) throws NamingException {
        if (refDesc.isLocal()) {
            EjbDescriptor target = refDesc.getEjbDescriptor();
            BaseContainer container = EjbContainerUtilImpl.getInstance().getContainer(target.getUniqueId());
            if (refDesc.isEJB30ClientView()) {
                GenericEJBLocalHome genericLocalHome = container.getEJBLocalBusinessHome(refDesc.getEjbInterface());
                return genericLocalHome.create(refDesc.getEjbInterface());
            }
            return container.getEJBLocalHome();
        }
        if (refDesc.isEJB30ClientView() && !(jndiObj instanceof RemoteBusinessWrapperBase)) {
            return EJBUtils.lookupRemote30BusinessObject(jndiObj, refDesc.getEjbInterface());
        }
        return jndiObj;
    }

    public static Object lookupRemote30BusinessObject(Object jndiObj, String businessInterface) throws NamingException {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> genericEJBHome = EJBUtils.loadGeneratedGenericEJBHomeClass(loader, jndiObj.getClass());
            Object genericHomeObj = PortableRemoteObject.narrow((Object)jndiObj, genericEJBHome);
            EJBUtils.loadGeneratedRemoteBusinessClasses(businessInterface);
            String generatedRemoteIntfName = RemoteGenerator.getGeneratedRemoteIntfName(businessInterface);
            Method createMethod = genericEJBHome.getMethod("create", String.class);
            Remote delegate = (Remote)createMethod.invoke(genericHomeObj, generatedRemoteIntfName);
            return EJBUtils.createRemoteBusinessObject(loader, businessInterface, delegate);
        }
        catch (Exception e) {
            NamingException ne = new NamingException("ejb ref resolution error for remote business interface" + businessInterface);
            ne.initCause(e instanceof InvocationTargetException ? e.getCause() : e);
            throw ne;
        }
    }

    public static Class<?> loadGeneratedSerializableClass(ClassLoader loader, Class<?> originalClass) {
        String generatedClassName = AsmSerializableBeanGenerator.getGeneratedSerializableClassName(originalClass.getName());
        try {
            return loader.loadClass(generatedClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            AsmSerializableBeanGenerator gen = new AsmSerializableBeanGenerator(loader, originalClass, generatedClassName);
            return gen.generateSerializableSubclass();
        }
    }

    public static void loadGeneratedRemoteBusinessClasses(String businessInterfaceName) throws Exception {
        ClassLoader appClassLoader = EJBUtils.getBusinessIntfClassLoader(businessInterfaceName);
        EJBUtils.loadGeneratedRemoteBusinessClasses(appClassLoader, businessInterfaceName);
    }

    public static Class<?> loadGeneratedRemoteBusinessClasses(ClassLoader appClassLoader, String businessInterfaceName) throws Exception {
        try (EjbClassGeneratorFactory factory = new EjbClassGeneratorFactory(appClassLoader);){
            Class<?> clazz = factory.ensureRemote(businessInterfaceName);
            return clazz;
        }
    }

    public static Class<?> loadGeneratedGenericEJBHomeClass(ClassLoader appClassLoader, Class<?> anchorClass) throws GeneratorException {
        try (EjbClassGeneratorFactory factory = new EjbClassGeneratorFactory(appClassLoader);){
            Class<?> clazz = factory.ensureGenericHome(anchorClass);
            return clazz;
        }
    }

    public static Class<?> generateSEI(ClassLoader loader, Class<?> ejbClass) throws GeneratorException {
        try (EjbClassGeneratorFactory factory = new EjbClassGeneratorFactory(loader);){
            Class<?> clazz = factory.ensureServiceInterface(ejbClass);
            return clazz;
        }
    }

    public static RemoteBusinessWrapperBase createRemoteBusinessObject(String businessInterface, Remote delegate) throws Exception {
        ClassLoader appClassLoader = EJBUtils.getBusinessIntfClassLoader(businessInterface);
        return EJBUtils.createRemoteBusinessObject(appClassLoader, businessInterface, delegate);
    }

    public static RemoteBusinessWrapperBase createRemoteBusinessObject(ClassLoader loader, String businessInterface, Remote delegate) throws Exception {
        String wrapperClassName = Remote30WrapperGenerator.getGeneratedRemoteWrapperName(businessInterface);
        Class<?> clientWrapperClass = loader.loadClass(wrapperClassName);
        Constructor<?>[] ctors = clientWrapperClass.getConstructors();
        Constructor<?> ctor = null;
        for (Constructor<?> next : ctors) {
            if (next.getParameterTypes().length <= 0) continue;
            ctor = next;
            break;
        }
        Object obj = null;
        if (ctor != null) {
            obj = ctor.newInstance(delegate, businessInterface);
        }
        return obj;
    }

    private static ClassLoader getBusinessIntfClassLoader(String businessInterface) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ClassLoader contextLoader = cl == null ? ClassLoader.getSystemClassLoader() : cl;
        Class<?> businessInterfaceClass = contextLoader.loadClass(businessInterface);
        return businessInterfaceClass.getClassLoader();
    }

    public static void serializeObjectFields(Object instance, ObjectOutputStream oos) throws IOException {
        EJBUtils.serializeObjectFields(instance, oos, true);
    }

    public static void serializeObjectFields(Object instance, ObjectOutputStream oos, boolean usesSuperClass) throws IOException {
        Class<?> clazz = usesSuperClass ? instance.getClass().getSuperclass() : instance.getClass();
        Iterator<Field> iterator = EJBUtils.getSerializationFields(clazz).iterator();
        while (iterator.hasNext()) {
            Field next;
            Field nextField = next = iterator.next();
            Object theInstance = instance;
            Object value = null;
            try {
                if (!nextField.trySetAccessible()) {
                    throw new InaccessibleObjectException("Unable to make accessible: " + String.valueOf(nextField));
                }
                value = nextField.get(theInstance);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "=====> Serializing field: " + String.valueOf(nextField));
                }
                oos.writeObject(value);
            }
            catch (Throwable t) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Failed serializing field: " + String.valueOf(nextField) + " of " + String.valueOf(clazz) + " using: " + String.valueOf(oos.getClass()) + " serializing value of type: " + (value == null ? null : value.getClass().getName()) + ", cause: " + String.valueOf(t));
                }
                throw new IOException(t instanceof InvocationTargetException ? t.getCause() : t);
            }
        }
    }

    public static void deserializeObjectFields(Object instance, ObjectInputStream ois) throws IOException {
        EJBUtils.deserializeObjectFields(instance, ois, null, true);
    }

    public static void deserializeObjectFields(Object instance, ObjectInputStream ois, Object replaceValue, boolean usesSuperClass) throws IOException {
        Class<?> clazz;
        Class<?> clazz2 = clazz = usesSuperClass ? instance.getClass().getSuperclass() : instance.getClass();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "=====> Deserializing class: " + String.valueOf(clazz));
            if (replaceValue != null) {
                _logger.log(Level.FINE, "=====> Replace requested for value: " + String.valueOf(replaceValue.getClass()));
            }
        }
        for (Field next : EJBUtils.getSerializationFields(clazz)) {
            try {
                Field nextField = next;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "=====> Deserializing field: " + String.valueOf(nextField));
                }
                Object value = ois.readObject();
                if (replaceValue != null && nextField.getType().isAssignableFrom(replaceValue.getClass())) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "=====> Replacing field: " + String.valueOf(nextField));
                    }
                    value = replaceValue;
                }
                Object newValue = value;
                Object theInstance = instance;
                if (!nextField.trySetAccessible()) {
                    throw new InaccessibleObjectException("Unable to make accessible: " + String.valueOf(nextField));
                }
                nextField.set(theInstance, newValue);
            }
            catch (Throwable t) {
                throw new IOException(t instanceof InvocationTargetException ? t.getCause() : t);
            }
        }
    }

    private static Collection<Field> getSerializationFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        TreeMap<String, Field> sortedMap = new TreeMap<String, Field>();
        for (Field next : fields) {
            int modifiers = next.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            sortedMap.put(next.getName(), next);
        }
        return sortedMap.values();
    }
}

