/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer;

import com.sun.enterprise.deployment.ManagedScheduledExecutorDefinitionDescriptor;
import com.sun.enterprise.deployment.annotation.handlers.ContextualResourceDefinition;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.deployer.ConcurrencyDeployer;
import org.glassfish.concurrent.runtime.deployer.ConcurrencyManagedScheduledExecutorServiceConfig;
import org.glassfish.concurrent.runtime.deployer.cfg.ManagedScheduledExecutorServiceCfg;
import org.glassfish.concurro.ContextServiceImpl;
import org.glassfish.concurro.ManagedScheduledExecutorServiceImpl;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
@ResourceDeployerInfo(value=ManagedScheduledExecutorDefinitionDescriptor.class)
public class ConcurrencyManagedScheduledExecutorDeployer
extends ConcurrencyDeployer<ManagedScheduledExecutorDefinitionDescriptor> {
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private ResourceNamingService resourceNamingService;
    @Inject
    private ConcurrentRuntime runtime;

    public boolean handles(Object resource) {
        return resource instanceof ManagedScheduledExecutorDefinitionDescriptor;
    }

    public void deployResource(ManagedScheduledExecutorDefinitionDescriptor resource) throws Exception {
        String applicationName = this.invocationManager.getCurrentInvocation().getAppName();
        String moduleName = this.invocationManager.getCurrentInvocation().getModuleName();
        this.deployResource(resource, applicationName, moduleName);
    }

    public void deployResource(ManagedScheduledExecutorDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
        ManagedScheduledExecutorDefinitionDescriptor descriptor = resource;
        ManagedScheduledExecutorServiceImpl service = this.createExecutorService(applicationName, moduleName, descriptor);
        ResourceInfo resourceInfo = new ResourceInfo(this.toResourceName(descriptor), applicationName, moduleName);
        this.resourceNamingService.publishObject((GenericResourceInfo)resourceInfo, (Object)service, true);
    }

    public void undeployResource(ManagedScheduledExecutorDefinitionDescriptor resource) throws Exception {
    }

    public void undeployResource(ManagedScheduledExecutorDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
    }

    private ManagedScheduledExecutorServiceImpl createExecutorService(String applicationName, String moduleName, ManagedScheduledExecutorDefinitionDescriptor descriptor) {
        ConcurrencyManagedScheduledExecutorServiceConfig config = new ConcurrencyManagedScheduledExecutorServiceConfig(descriptor);
        ManagedScheduledExecutorServiceCfg mesConfig = new ManagedScheduledExecutorServiceCfg(config);
        ContextServiceImpl contextService = this.runtime.findOrCreateContextService((ContextualResourceDefinition)descriptor, applicationName, moduleName);
        return this.runtime.createManagedScheduledExecutorService(mesConfig, contextService);
    }
}

