/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet.internal;

import jakarta.inject.Singleton;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnit;
import jakarta.servlet.ServletConfig;
import jakarta.ws.rs.core.GenericType;
import java.lang.reflect.Proxy;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.jersey.innate.inject.InjectionIds;
import org.glassfish.jersey.innate.inject.InjectionResolverBinding;
import org.glassfish.jersey.innate.inject.InternalBinder;
import org.glassfish.jersey.internal.inject.Injectee;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.servlet.internal.LocalizationMessages;
import org.glassfish.jersey.servlet.internal.ThreadLocalNamedInvoker;

public class PersistenceUnitBinder
extends InternalBinder {
    private final ServletConfig servletConfig;
    public static final String PERSISTENCE_UNIT_PREFIX = "unit:";

    public PersistenceUnitBinder(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    protected void configure() {
        ((InjectionResolverBinding)this.bind(new PersistenceUnitInjectionResolver(this.servletConfig)).to((GenericType)new GenericType<InjectionResolver<PersistenceUnit>>(){})).id((long)InjectionIds.SERVLET_PERSISTANCE_UNIT_INJECTION_RESOLVER.id());
    }

    @Singleton
    private static class PersistenceUnitInjectionResolver
    implements InjectionResolver<PersistenceUnit> {
        private final Map<String, String> persistenceUnits = new HashMap<String, String>();

        private PersistenceUnitInjectionResolver(ServletConfig servletConfig) {
            Enumeration parameterNames = servletConfig.getInitParameterNames();
            while (parameterNames.hasMoreElements()) {
                String key = (String)parameterNames.nextElement();
                if (!key.startsWith(PersistenceUnitBinder.PERSISTENCE_UNIT_PREFIX)) continue;
                this.persistenceUnits.put(key.substring(PersistenceUnitBinder.PERSISTENCE_UNIT_PREFIX.length()), "java:comp/env/" + servletConfig.getInitParameter(key));
            }
        }

        public Object resolve(Injectee injectee) {
            if (!injectee.getRequiredType().equals(EntityManagerFactory.class)) {
                return null;
            }
            PersistenceUnit annotation = injectee.getParent().getAnnotation(PersistenceUnit.class);
            String unitName = annotation.unitName();
            if (!this.persistenceUnits.containsKey(unitName)) {
                throw new ContainerException(LocalizationMessages.PERSISTENCE_UNIT_NOT_CONFIGURED(unitName));
            }
            return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EntityManagerFactory.class}, new ThreadLocalNamedInvoker(this.persistenceUnits.get(unitName)));
        }

        public boolean isConstructorParameterIndicator() {
            return false;
        }

        public boolean isMethodParameterIndicator() {
            return false;
        }

        public Class<PersistenceUnit> getAnnotation() {
            return PersistenceUnit.class;
        }
    }
}

