/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.jdbc;

import java.sql.Array;
import java.sql.Struct;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.jdbc.JDBCType;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum JDBCTypes implements JDBCType
{
    ARRAY_TYPE(2003, "ARRAY"),
    BIGINT_TYPE(-5, "BIGINT"),
    BINARY_TYPE(-2, "BINARY"),
    BIT_TYPE(-7, "BIT"),
    BLOB_TYPE(2004, "BLOB"),
    BOOLEAN_TYPE(16, "BOOLEAN"),
    CHAR_TYPE(1, "CHAR"),
    NCHAR_TYPE(-15, "NCHAR"),
    CLOB_TYPE(2005, "CLOB"),
    DATALINK_TYPE(70, "DATALINK"),
    DATE_TYPE(91, "DATE"),
    DECIMAL_TYPE(3, "DECIMAL"),
    DISTINCT_TYPE(2001, "DISTINCT"),
    DOUBLE_TYPE(8, "DOUBLE"),
    FLOAT_TYPE(6, "FLOAT"),
    INTEGER_TYPE(4, "INTEGER"),
    JAVA_OBJECT_TYPE(2000, "JAVA_OBJECT"),
    LONGVARBINARY_TYPE(-4, "LONGVARBINARY"),
    LONGVARCHAR_TYPE(-1, "LONGVARCHAR"),
    NULL_TYPE(0, "NULL"),
    NUMERIC_TYPE(2, "NUMERIC"){

        protected void buildInitialDeclare(StringBuilder sb, PLSQLargument arg) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, arg, this);
            if (arg.precision != Integer.MIN_VALUE) {
                sb.append("(");
                sb.append(arg.precision);
                if (arg.scale != Integer.MIN_VALUE) {
                    sb.append(",");
                    sb.append(arg.scale);
                }
                sb.append(")");
            }
        }

        @Override
        public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
            this.buildInitialDeclare(sb, inArg);
            sb.append(" := :");
            sb.append(inArg.inIndex);
            sb.append(";");
            sb.append("\n");
        }

        @Override
        public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
            this.buildInitialDeclare(sb, outArg);
            sb.append(";");
            sb.append("\n");
        }
    }
    ,
    OTHER_TYPE(1111, "OTHER"),
    REAL_TYPE(7, "REAL"),
    REF_TYPE(2006, "REF"),
    SMALLINT_TYPE(5, "SMALLINT"),
    STRUCT_TYPE(2002, "STRUCT"),
    TIME_TYPE(92, "TIME"),
    TIMESTAMP_TYPE(93, "TIMESTAMP"),
    TINYINT_TYPE(-6, "TINYINT"),
    VARBINARY_TYPE(-3, "VARBINARY"),
    VARCHAR_TYPE(12, "VARCHAR"){

        protected void buildInitialDeclare(StringBuilder sb, PLSQLargument arg) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, arg, this);
            if (arg.length != Integer.MIN_VALUE) {
                sb.append("(");
                sb.append(arg.length);
                sb.append(")");
            }
        }

        @Override
        public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
            this.buildInitialDeclare(sb, inArg);
            sb.append(" := :");
            sb.append(inArg.inIndex);
            sb.append(";");
            sb.append("\n");
        }

        @Override
        public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
            this.buildInitialDeclare(sb, outArg);
            sb.append(";");
            sb.append("\n");
        }
    }
    ,
    NVARCHAR_TYPE(-9, "NVARCHAR"){

        protected void buildInitialDeclare(StringBuilder sb, PLSQLargument arg) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, arg, this);
            if (arg.length != Integer.MIN_VALUE) {
                sb.append("(");
                sb.append(arg.length);
                sb.append(")");
            }
        }

        @Override
        public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
            this.buildInitialDeclare(sb, inArg);
            sb.append(" := :");
            sb.append(inArg.inIndex);
            sb.append(";");
            sb.append("\n");
        }

        @Override
        public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
            this.buildInitialDeclare(sb, outArg);
            sb.append(";");
            sb.append("\n");
        }
    }
    ,
    NVARCHAR2_TYPE(-9, "NVARCHAR2"){

        protected void buildInitialDeclare(StringBuilder sb, PLSQLargument arg) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, arg, this);
            if (arg.length != Integer.MIN_VALUE) {
                sb.append("(");
                sb.append(arg.length);
                sb.append(")");
            }
        }

        @Override
        public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
            this.buildInitialDeclare(sb, inArg);
            sb.append(" := :");
            sb.append(inArg.inIndex);
            sb.append(";");
            sb.append("\n");
        }

        @Override
        public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
            this.buildInitialDeclare(sb, outArg);
            sb.append(";");
            sb.append("\n");
        }
    };

    private final int typeCode;
    private final String typeName;

    private JDBCTypes(int typeCode, String typeName) {
        this.typeCode = typeCode;
        this.typeName = typeName;
    }

    @Override
    public boolean isComplexDatabaseType() {
        return false;
    }

    @Override
    public boolean isJDBCType() {
        return true;
    }

    @Override
    public int getSqlCode() {
        return this.typeCode;
    }

    @Override
    public int getConversionCode() {
        return this.getSqlCode();
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public int computeInIndex(PLSQLargument inArg, int newIndex, ListIterator<PLSQLargument> i) {
        return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeInIndex(inArg, newIndex);
    }

    @Override
    public int computeOutIndex(PLSQLargument outArg, int newIndex, ListIterator<PLSQLargument> i) {
        return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeOutIndex(outArg, newIndex);
    }

    @Override
    public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, inArg, this);
        sb.append(" := :");
        sb.append(inArg.inIndex);
        sb.append(";");
        sb.append("\n");
    }

    @Override
    public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, outArg, this);
        sb.append(";");
        sb.append("\n");
    }

    @Override
    public void buildBeginBlock(StringBuilder sb, PLSQLargument arg, PLSQLStoredProcedureCall call) {
    }

    @Override
    public void buildOutAssignment(StringBuilder sb, PLSQLargument outArg, PLSQLStoredProcedureCall call) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutAssignment(sb, outArg, call);
    }

    @Override
    public void translate(PLSQLargument arg, AbstractRecord translationRow, AbstractRecord copyOfTranslationRow, List<DatabaseField> copyOfTranslationFields, List<DatabaseField> translationRowFields, List translationRowValues, StoredProcedureCall call) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.translate(arg, translationRow, copyOfTranslationRow, copyOfTranslationFields, translationRowFields, translationRowValues, call);
    }

    @Override
    public void buildOutputRow(PLSQLargument outArg, AbstractRecord outputRow, DatabaseRecord newOutputRow, List<DatabaseField> outputRowFields, List outputRowValues) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutputRow(outArg, outputRow, newOutputRow, outputRowFields, outputRowValues);
    }

    @Override
    public void logParameter(StringBuilder sb, DatasourceCall.ParameterType direction, PLSQLargument arg, AbstractRecord translationRow, DatabasePlatform platform) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.logParameter(sb, direction, arg, translationRow, platform);
    }

    public static DatabaseType getDatabaseTypeForCode(int typeCode) {
        JDBCTypes databaseType = switch (typeCode) {
            case 2003 -> ARRAY_TYPE;
            case -5 -> BIGINT_TYPE;
            case -2 -> BINARY_TYPE;
            case -7 -> BIT_TYPE;
            case 2004 -> BLOB_TYPE;
            case 16 -> BOOLEAN_TYPE;
            case 1 -> CHAR_TYPE;
            case 2005 -> CLOB_TYPE;
            case 70 -> DATALINK_TYPE;
            case 91 -> DATE_TYPE;
            case 3 -> DECIMAL_TYPE;
            case 2001 -> DISTINCT_TYPE;
            case 8 -> DOUBLE_TYPE;
            case 6 -> FLOAT_TYPE;
            case 4 -> INTEGER_TYPE;
            case 2000 -> JAVA_OBJECT_TYPE;
            case -4 -> LONGVARBINARY_TYPE;
            case -1 -> LONGVARCHAR_TYPE;
            case -15 -> NCHAR_TYPE;
            case 0 -> NULL_TYPE;
            case 2 -> NUMERIC_TYPE;
            case -9 -> NVARCHAR_TYPE;
            case 1111 -> OTHER_TYPE;
            case 7 -> REAL_TYPE;
            case 2006 -> REF_TYPE;
            case 5 -> SMALLINT_TYPE;
            case 2002 -> STRUCT_TYPE;
            case 92 -> TIME_TYPE;
            case 93 -> TIMESTAMP_TYPE;
            case -6 -> TINYINT_TYPE;
            case -3 -> VARBINARY_TYPE;
            case 12 -> VARCHAR_TYPE;
            default -> null;
        };
        return databaseType;
    }

    public static Class<?> getClassForCode(int typeCode) {
        Class<Object> clz = switch (typeCode) {
            case 2003 -> Array.class;
            case -5, 2, 3 -> ClassConstants.BIGDECIMAL;
            case -4, -3, -2, 2004 -> ClassConstants.BLOB;
            case 2005 -> ClassConstants.CLOB;
            case 16 -> ClassConstants.BOOLEAN;
            case 70, 1111, 2000, 2001, 2006 -> CoreClassConstants.OBJECT;
            case 0 -> ClassConstants.Void_Class;
            case 91 -> CoreClassConstants.SQLDATE;
            case 93 -> CoreClassConstants.TIMESTAMP;
            case 8 -> ClassConstants.DOUBLE;
            case 6, 7 -> ClassConstants.FLOAT;
            case 4 -> ClassConstants.INTEGER;
            case -7, -6, 5 -> ClassConstants.SHORT;
            case 2002 -> Struct.class;
            case 92 -> CoreClassConstants.TIME;
            default -> ClassConstants.STRING;
        };
        return clz;
    }
}

