/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.sql.Timestamp;
import org.eclipse.persistence.descriptors.AbstractTsLockingPolicy;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ModifyQuery;

public class TimestampLockingPolicy
extends AbstractTsLockingPolicy<Timestamp> {
    public TimestampLockingPolicy() {
    }

    public TimestampLockingPolicy(String fieldName) {
        super(fieldName);
    }

    TimestampLockingPolicy(DatabaseField field) {
        super(field);
    }

    @Override
    int compareTsLockValues(Timestamp value1, Timestamp value2) {
        return value1.compareTo(value2);
    }

    @Override
    Class<Timestamp> getDefaultTsLockFieldType() {
        return ClassConstants.TIMESTAMP;
    }

    @Override
    Timestamp getBaseTsValue() {
        return new Timestamp(0L);
    }

    @Override
    Timestamp getInitialTsWriteValue(AbstractSession session) {
        if (this.usesLocalTime()) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (this.usesServerTime()) {
            AbstractSession readSession = session.getSessionForClass(this.getDescriptor().getJavaClass());
            while (readSession.isUnitOfWork()) {
                readSession = readSession.getParent().getSessionForClass(this.getDescriptor().getJavaClass());
            }
            return readSession.getDatasourceLogin().getDatasourcePlatform().getTimestampFromServer(session, readSession.getName());
        }
        return null;
    }

    @Override
    Timestamp getNewTsLockValue(ModifyQuery query) {
        return this.getInitialTsWriteValue(query.getSession());
    }

    @Override
    Timestamp getTsValueToPutInCache(AbstractRecord row, AbstractSession session) {
        if (this.isStoredInCache()) {
            return (Timestamp)session.getDatasourcePlatform().convertObject(row.get(this.getWriteLockField()), ClassConstants.TIMESTAMP);
        }
        return null;
    }

    @Override
    Timestamp getWriteTsLockValue(Object domainObject, Object primaryKey, AbstractSession session) {
        Timestamp writeLockFieldValue = null;
        if (this.isStoredInCache()) {
            writeLockFieldValue = (Timestamp)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor());
        } else {
            Object lockValue = this.lockValueFromObject(domainObject);
            if (lockValue != null) {
                if (lockValue instanceof Timestamp) {
                    writeLockFieldValue = (Timestamp)this.lockValueFromObject(domainObject);
                } else {
                    throw OptimisticLockException.needToMapJavaSqlTimestampWhenStoredInObject();
                }
            }
        }
        return writeLockFieldValue;
    }

    @Override
    boolean isNewerTsVersion(Timestamp current, Object domainObject, Object primaryKey, AbstractSession session) {
        Timestamp writeLockFieldValue = this.isStoredInCache() ? (Timestamp)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor()) : (Timestamp)this.lockValueFromObject(domainObject);
        return this.isNewerTsVersion(current, writeLockFieldValue);
    }

    @Override
    boolean isNewerTsVersion(AbstractRecord row, Object domainObject, Object primaryKey, AbstractSession session) {
        Timestamp newWriteLockFieldValue = (Timestamp)session.getDatasourcePlatform().convertObject(row.get(this.getWriteLockField()), ClassConstants.TIMESTAMP);
        Timestamp writeLockFieldValue = this.isStoredInCache() ? (Timestamp)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor()) : (Timestamp)this.lockValueFromObject(domainObject);
        return this.isNewerTsVersion(newWriteLockFieldValue, writeLockFieldValue);
    }

    @Override
    boolean isNewerTsVersion(Timestamp first, Timestamp second) {
        if (first == null) {
            return false;
        }
        if (second == null) {
            return true;
        }
        return first.after(second);
    }

    @Override
    public int getVersionDifference(Object currentValue, Object domainObject, Object primaryKeys, AbstractSession session) {
        Timestamp newWriteLockFieldValue = (Timestamp)currentValue;
        if (newWriteLockFieldValue == null) {
            return 0;
        }
        Timestamp writeLockFieldValue = this.isStoredInCache() ? (Timestamp)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKeys, domainObject.getClass(), this.getDescriptor()) : (Timestamp)this.lockValueFromObject(domainObject);
        if (writeLockFieldValue != null && newWriteLockFieldValue.equals(writeLockFieldValue)) {
            return 0;
        }
        if (writeLockFieldValue != null && !newWriteLockFieldValue.after(writeLockFieldValue)) {
            return -1;
        }
        return 1;
    }
}

