/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;

public class ClusterTxnInquiryInfo {
    protected Logger logger = Globals.getLogger();
    private Long transactionID = null;
    private BrokerAddress txnhome = null;
    private Long replyXid = null;
    private GPacket pkt = null;

    private ClusterTxnInquiryInfo(Long txnID, BrokerAddress txnhome, Long replyXid) {
        this.transactionID = txnID;
        this.txnhome = txnhome;
        this.replyXid = replyXid;
    }

    private ClusterTxnInquiryInfo(GPacket pkt) {
        this.pkt = pkt;
    }

    public static ClusterTxnInquiryInfo newInstance(Long txnID, BrokerAddress txnhome, Long replyXid) {
        return new ClusterTxnInquiryInfo(txnID, txnhome, null);
    }

    public static ClusterTxnInquiryInfo newInstance(GPacket pkt) {
        return new ClusterTxnInquiryInfo(pkt);
    }

    public GPacket getGPacket() throws IOException {
        GPacket gp = GPacket.getInstance();
        gp.setType((short)47);
        gp.putProp((Object)"transactionID", (Object)this.transactionID);
        gp.setBit(1, true);
        if (this.replyXid != null) {
            gp.putProp((Object)"X", (Object)this.replyXid);
        }
        if (this.txnhome != null) {
            gp.putProp((Object)"transactionHome", (Object)this.txnhome.toProtocolString());
        }
        return gp;
    }

    public Long getTransactionID() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"transactionID");
    }

    public BrokerAddress getTransactionHome() {
        assert (this.pkt != null);
        String home = (String)this.pkt.getProp((Object)"transactionHome");
        if (home == null) {
            return null;
        }
        try {
            return Globals.getMyAddress().fromProtocolString(home);
        }
        catch (Exception e) {
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.log(16, "Unable to get transaction home broker address for TID=" + this.getTransactionID() + ":" + e.getMessage());
            return null;
        }
    }

    public Long getXid() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"X");
    }

    public String toString() {
        if (this.pkt == null) {
            StringBuilder buf = new StringBuilder();
            buf.append("\n\tTransactionID = ").append(this.transactionID);
            if (this.txnhome != null) {
                buf.append("\n\tTransactionHome = ").append(this.txnhome.toProtocolString());
            }
            if (this.replyXid != null) {
                buf.append("\n\tXID = ").append(this.replyXid);
            }
            return buf.toString();
        }
        StringBuilder buf = new StringBuilder();
        if (this.getTransactionID() != null) {
            buf.append("\n\tTransactionID = ").append(this.getTransactionID());
        }
        if (this.pkt.getProp((Object)"transactionHome") != null) {
            buf.append("\n\tTransactionHome = ").append((String)this.pkt.getProp((Object)"transactionHome"));
        }
        if (this.pkt.getProp((Object)"X") != null) {
            buf.append("\n\tXID = ").append(this.pkt.getProp((Object)"X"));
        }
        return buf.toString();
    }
}

