/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.weld.interceptor.proxy.InterceptorInvocation;
import org.jboss.weld.interceptor.reader.SimpleInterceptorInvocation;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionType;

public abstract class AbstractInterceptorMetadata
implements InterceptorMetadata {
    protected final Map<InterceptionType, List<Method>> interceptorMethodMap;

    public AbstractInterceptorMetadata(Map<InterceptionType, List<Method>> interceptorMethodMap) {
        this.interceptorMethodMap = interceptorMethodMap;
    }

    public List<Method> getInterceptorMethods(InterceptionType interceptionType) {
        if (this.interceptorMethodMap != null) {
            List<Method> methods = this.interceptorMethodMap.get((Object)interceptionType);
            return methods == null ? Collections.emptyList() : methods;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isEligible(InterceptionType interceptionType) {
        if (this.interceptorMethodMap == null) {
            return false;
        }
        List<Method> interceptorMethods = this.interceptorMethodMap.get((Object)interceptionType);
        return interceptorMethods != null && !interceptorMethods.isEmpty();
    }

    @Override
    public InterceptorInvocation getInterceptorInvocation(Object interceptorInstance, InterceptionType interceptionType) {
        return new SimpleInterceptorInvocation(interceptorInstance, interceptionType, this.getInterceptorMethods(interceptionType), this.isTargetClassInterceptor());
    }

    protected abstract boolean isTargetClassInterceptor();
}

