/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.convert;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.convert.MessageFactory;

public class CharacterConverter
implements Converter {
    public static final String CONVERTER_ID = "jakarta.faces.Character";
    public static final String CHARACTER_ID = "jakarta.faces.converter.CharacterConverter.CHARACTER";
    public static final String STRING_ID = "jakarta.faces.converter.STRING";

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        try {
            return Character.valueOf(value.charAt(0));
        }
        catch (Exception e) {
            throw new ConverterException(MessageFactory.getMessage(context, CHARACTER_ID, value, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return "";
        }
        try {
            return value.toString();
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }
}

