/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.cluster.SynchronizeInstanceCommand;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.servermgmt.cli.StartServerCommand;
import com.sun.enterprise.admin.servermgmt.cli.StartServerHelper;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.ObjectAnalyzer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="start-local-instance")
@ExecuteOn(value={RuntimeType.DAS})
@PerLookup
public class StartLocalInstanceCommand
extends SynchronizeInstanceCommand
implements StartServerCommand {
    @Param(optional=true, shortName="v", defaultValue="false")
    private boolean verbose;
    @Param(optional=true, shortName="w", defaultValue="false")
    private boolean watchdog;
    @Param(optional=true, shortName="d", defaultValue="false")
    private boolean debug;
    @Param(name="dry-run", shortName="n", optional=true, defaultValue="false")
    private boolean dry_run;
    private GFLauncherInfo info;
    private GFLauncher launcher;
    private StartServerHelper helper;

    public RuntimeType getType() {
        return RuntimeType.INSTANCE;
    }

    @Override
    protected boolean mkdirs(File f) {
        return false;
    }

    @Override
    protected void validate() throws CommandException {
        super.validate();
        File dir = this.getServerDirs().getServerDir();
        if (!dir.isDirectory()) {
            throw new CommandException(Strings.get("Instance.noSuchInstance"));
        }
    }

    @Override
    protected int executeCommand() throws CommandException {
        logger.finer(() -> this.toString());
        if (this.sync.equals("none")) {
            logger.info(Strings.get("Instance.nosync"));
        } else if (!this.synchronizeInstance()) {
            File domainXml = new File(new File(this.instanceDir, "config"), "domain.xml");
            if (!domainXml.exists()) {
                logger.info(Strings.get("Instance.nodomainxml"));
                return 1;
            }
            logger.info(Strings.get("Instance.syncFailed"));
        }
        try {
            this.createLauncher();
            String mpv = this.getMasterPassword();
            this.helper = new StartServerHelper(this.programOpts.isTerse(), this.getServerDirs(), this.launcher, mpv, this.debug);
            if (!this.helper.prepareForLaunch()) {
                return 1;
            }
            if (this.dry_run) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(Strings.get("dry_run_msg"));
                }
                logger.info(this.getLauncher().getCommandLine().toString("\n"));
                return 0;
            }
            this.getLauncher().launch();
            if (!this.verbose && !this.watchdog) {
                this.helper.waitForServerStart();
                this.helper.report();
                return 0;
            }
            while (true) {
                int returnValue = this.getLauncher().getExitValue();
                switch (returnValue) {
                    case 10: {
                        logger.info(Strings.get("restart"));
                        break;
                    }
                    case 11: {
                        logger.info(Strings.get("restartChangeDebug", "on"));
                        this.getInfo().setDebug(true);
                        break;
                    }
                    case 12: {
                        logger.info(Strings.get("restartChangeDebug", "off"));
                        this.getInfo().setDebug(false);
                        break;
                    }
                    default: {
                        return returnValue;
                    }
                }
                if (this.env.debug()) {
                    System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
                }
                this.getLauncher().relaunch();
            }
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
        catch (MiniXmlParserException me) {
            throw new CommandException((Throwable)me);
        }
    }

    public void createLauncher() throws GFLauncherException, MiniXmlParserException {
        this.setLauncher(GFLauncherFactory.getInstance((RuntimeType)this.getType()));
        this.setInfo(this.getLauncher().getInfo());
        this.getInfo().setInstanceName(this.instanceName);
        this.getInfo().setInstanceRootDir(this.instanceDir);
        this.getInfo().setVerbose(this.verbose);
        this.getInfo().setWatchdog(this.watchdog);
        this.getInfo().setDebug(this.debug);
        this.getInfo().setRespawnInfo(this.programOpts.getClassName(), this.programOpts.getClassPath(), this.respawnArgs());
        this.getLauncher().setup();
    }

    private String[] respawnArgs() {
        ArrayList<Object> args = new ArrayList<Object>(15);
        args.addAll(Arrays.asList(this.programOpts.getProgramArguments()));
        args.add(this.getName());
        args.add("--verbose=" + String.valueOf(this.verbose));
        args.add("--watchdog=" + String.valueOf(this.watchdog));
        args.add("--debug=" + String.valueOf(this.debug));
        if (StartLocalInstanceCommand.ok((String)this.nodeDir)) {
            args.add("--nodedir");
            args.add(this.nodeDir);
        }
        if (StartLocalInstanceCommand.ok((String)this.node)) {
            args.add("--node");
            args.add(this.node);
        }
        if (StartLocalInstanceCommand.ok((String)this.instanceName)) {
            args.add(this.instanceName);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Respawn args: " + ((Object)args).toString());
        }
        String[] a = new String[args.size()];
        args.toArray(a);
        return a;
    }

    private GFLauncher getLauncher() {
        if (this.launcher == null) {
            throw new RuntimeException(Strings.get("internal.error", "GFLauncher was not initialized"));
        }
        return this.launcher;
    }

    private void setLauncher(GFLauncher gfl) {
        this.launcher = gfl;
    }

    private GFLauncherInfo getInfo() {
        if (this.info == null) {
            throw new RuntimeException(Strings.get("internal.error", "GFLauncherInfo was not initialized"));
        }
        return this.info;
    }

    private void setInfo(GFLauncherInfo inf) {
        this.info = inf;
    }

    public String toString() {
        return ObjectAnalyzer.toStringWithSuper((Object)((Object)this));
    }
}

