/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.security.appclient.integration.AppClientSecurityInfo;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.appclient.client.acc.HttpAuthenticator;
import org.glassfish.appclient.client.acc.Util;
import org.glassfish.appclient.client.acc.config.ClientCredential;
import org.glassfish.appclient.client.acc.config.MessageSecurityConfig;
import org.glassfish.appclient.client.acc.config.TargetServer;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class AppClientContainerSecurityHelper {
    private static final Logger logger = Logger.getLogger(AppClientContainerSecurityHelper.class.getName());
    @Inject
    private InjectionManager injectionManager;
    @Inject
    private AppClientSecurityInfo appClientSecurityInfo;
    private ClassLoader classLoader;

    void init(TargetServer[] targetServers, List<MessageSecurityConfig> msgSecConfigs, Properties containerProperties, ClientCredential clientCredential, CallbackHandler callerSuppliedCallbackHandler, ClassLoader classLoader, ApplicationClientDescriptor acDesc, boolean isTextAuth) throws ReflectiveOperationException, InjectionException, IOException {
        this.classLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        this.initLoginConfig();
        CallbackHandler callbackHandler = this.initSecurity(callerSuppliedCallbackHandler, acDesc);
        this.appClientSecurityInfo.initializeSecurity(Arrays.asList(targetServers), msgSecConfigs, callbackHandler, clientCredential == null ? null : clientCredential.getUserName(), clientCredential == null || clientCredential.getPassword() == null || clientCredential.getPassword().get() == null ? null : clientCredential.getPassword().get(), false, !isTextAuth);
        this.initHttpAuthenticator(AppClientSecurityInfo.CredentialType.USERNAME_PASSWORD);
    }

    private void initLoginConfig() throws IOException {
        String appclientloginConfContent = System.getProperty("appclient.login.conf.content");
        URI configURI = appclientloginConfContent == null ? new File(System.getProperty("com.sun.aas.installRoot")).toURI().resolve("lib/appclient/appclientlogin.conf") : Util.writeTextToTempFile(appclientloginConfContent, "appclientlogin", ".conf", false).toURI();
        File configFile = new File(configURI);
        System.setProperty("java.security.auth.login.config", configFile.toURL().toString());
    }

    private CallbackHandler initSecurity(CallbackHandler callerSuppliedCallbackHandler, ApplicationClientDescriptor applicationClientDescriptor) throws ReflectiveOperationException, InjectionException, ClassNotFoundException {
        CallbackHandler callbackHandler = callerSuppliedCallbackHandler;
        if (callerSuppliedCallbackHandler == null) {
            String descriptorCallbackHandlerClassName;
            callbackHandler = applicationClientDescriptor != null && (descriptorCallbackHandlerClassName = applicationClientDescriptor.getCallbackHandler()) != null ? this.newCallbackHandlerInstance(descriptorCallbackHandlerClassName, applicationClientDescriptor, this.classLoader) : null;
        }
        logger.config("Callback handler class = " + (callbackHandler == null ? "(default)" : callbackHandler.getClass().getName()));
        return callbackHandler;
    }

    private CallbackHandler newCallbackHandlerInstance(String callbackHandlerClassName, ApplicationClientDescriptor applicationClientDescriptor, ClassLoader loader) throws ClassNotFoundException, ReflectiveOperationException, IllegalAccessException, InjectionException {
        Class<?> callbackHandlerClass = Class.forName(callbackHandlerClassName, true, loader);
        return this.newCallbackHandlerInstance(callbackHandlerClass, applicationClientDescriptor);
    }

    private CallbackHandler newCallbackHandlerInstance(Class<? extends CallbackHandler> callbackHandlerClass, ApplicationClientDescriptor applicationClientDescriptor) throws ReflectiveOperationException, IllegalAccessException, InjectionException {
        CallbackHandler userHandler = callbackHandlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.injectionManager.injectInstance((Object)userHandler, (JndiNameEnvironment)applicationClientDescriptor);
        return userHandler;
    }

    void clearClientSecurityContext() {
        this.appClientSecurityInfo.clearClientSecurityContext();
    }

    boolean isLoginCancelled() {
        return this.appClientSecurityInfo.isLoginCancelled();
    }

    private void initHttpAuthenticator(AppClientSecurityInfo.CredentialType loginType) {
        Authenticator.setDefault(new HttpAuthenticator(this.appClientSecurityInfo, loginType));
    }
}

