/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.tx;

import ee.jakarta.tck.concurrent.framework.TestLogger;
import ee.jakarta.tck.concurrent.framework.TestUtil;
import ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.tx.CancelledTransactedTask;
import ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.tx.Constants;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class Util {
    private static final TestLogger log = TestLogger.get(Util.class);

    private Util() {
    }

    public static Connection getConnection(DataSource ds, String user, String pwd, boolean autoCommit) {
        Connection conn = null;
        try {
            conn = ds.getConnection();
            if (conn == null) {
                conn = ds.getConnection(user, pwd);
            }
            if (null != conn) {
                conn.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException e) {
            log.severe("failed to get connection.", e);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(String tableName, String username, String password) {
        Connection conn = Util.getConnection(true, username, password);
        Statement stmt = null;
        try {
            String queryStr = "select count(*) from " + tableName;
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(queryStr);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(Connection conn, String tableName, String username, String password) {
        Statement stmt = null;
        try {
            String queryStr = "select count(*) from " + tableName;
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(queryStr);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static Connection getConnection(boolean autoCommit, String username, String password) {
        DataSource ds = (DataSource)TestUtil.lookup("java:comp/env/jdbc/ManagedScheduledExecutorServiceDB");
        Connection conn = Util.getConnection(ds, username, password, autoCommit);
        return conn;
    }

    public static void waitForTransactionBegan(CancelledTransactedTask pp) {
        long stopTime = System.currentTimeMillis() + Constants.POLL_TIMEOUT.toMillis();
        while (!pp.transactionBegin() && System.currentTimeMillis() < stopTime) {
            try {
                TestUtil.sleep(Constants.POLL_INTERVAL);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

