/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ContextService.tx;

import ee.jakarta.tck.concurrent.framework.TestLogger;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.tx.TestTransactionWork;
import ee.jakarta.tck.concurrent.spec.ContextService.tx.TestWorkInterface;
import ee.jakarta.tck.concurrent.spec.ContextService.tx.Util;
import jakarta.annotation.Resource;
import jakarta.annotation.sql.DataSourceDefinition;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.transaction.UserTransaction;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.sql.DataSource;

@WebServlet(value={"/TransactionServlet"})
@DataSourceDefinition(name="java:comp/env/jdbc/ContextServiceDB", className="org.apache.derby.jdbc.EmbeddedDataSource", databaseName="memory:ContextServiceDB", properties={"createDatabase=create"})
public class TransactionServlet
extends TestServlet {
    private static final TestLogger log = TestLogger.get(TransactionServlet.class);
    @Resource(lookup="java:comp/env/jdbc/ContextServiceDB")
    private DataSource ds;
    @Resource(lookup="java:comp/DefaultContextService")
    private ContextService cx;
    @Resource(lookup="java:comp/UserTransaction")
    private UserTransaction ut;

    @Override
    protected void before() throws RemoteException {
        log.enter("before", new Object[0]);
        try (Connection conn = Util.getConnection(this.ds, "user1", "password1", true);
             Statement stmt = conn.createStatement();){
            try {
                stmt.executeUpdate("drop table concurrencetable");
            }
            catch (SQLException e) {
                log.finest("Could not drop table, assume table did not exist.");
            }
            stmt.executeUpdate("create table concurrencetable (TYPE_ID int NOT NULL, TYPE_DESC varchar(32), primary key(TYPE_ID))");
            log.exit("before", new Object[0]);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public String testTransactionOfExecuteThreadAndCommit() throws ServletException {
        Statement pStmt = null;
        Connection conn = null;
        Object conn2 = null;
        try {
            int originCount = Util.getCount("concurrencetable", "user1", "password1");
            this.ut.begin();
            conn = Util.getConnection(false, "user1", "password1");
            pStmt = conn.prepareStatement("insert into concurrencetable values(?, ?)");
            pStmt.setInt(1, 99);
            pStmt.setString(2, "Type-99");
            pStmt.addBatch();
            pStmt.setInt(1, 100);
            pStmt.setString(2, "Type-100");
            pStmt.addBatch();
            pStmt.executeBatch();
            TestTransactionWork work = new TestTransactionWork();
            work.setUserName("user1");
            work.setPassword("password1");
            work.setSQLTemplate("insert into concurrencetable values(?, ?)");
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("jakarta.enterprise.concurrent.TRANSACTION", "USE_TRANSACTION_OF_EXECUTION_THREAD");
            TestWorkInterface proxy = (TestWorkInterface)this.cx.createContextualProxy((Object)work, m, TestWorkInterface.class);
            proxy.doSomeWork();
            this.ut.commit();
            int afterTransacted = Util.getCount("concurrencetable", "user1", "password1");
            String string = String.valueOf(afterTransacted - originCount);
            return string;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String testTransactionOfExecuteThreadAndRollback() throws ServletException {
        Statement pStmt = null;
        Connection conn = null;
        Object conn2 = null;
        try {
            int originCount = Util.getCount("concurrencetable", "user1", "password1");
            this.ut.begin();
            conn = Util.getConnection(false, "user1", "password1");
            pStmt = conn.prepareStatement("insert into concurrencetable values(?, ?)");
            pStmt.setInt(1, 99);
            pStmt.setString(2, "Type-99");
            pStmt.addBatch();
            pStmt.setInt(1, 100);
            pStmt.setString(2, "Type-100");
            pStmt.addBatch();
            pStmt.executeBatch();
            TestTransactionWork work = new TestTransactionWork();
            work.setUserName("user1");
            work.setPassword("password1");
            work.setSQLTemplate("insert into concurrencetable values(?, ?)");
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("jakarta.enterprise.concurrent.TRANSACTION", "USE_TRANSACTION_OF_EXECUTION_THREAD");
            TestWorkInterface proxy = (TestWorkInterface)this.cx.createContextualProxy((Object)work, m, TestWorkInterface.class);
            proxy.doSomeWork();
            this.ut.rollback();
            int afterTransacted = Util.getCount("concurrencetable", "user1", "password1");
            String string = String.valueOf(afterTransacted - originCount);
            return string;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String testSuspendAndCommit() throws ServletException {
        Statement pStmt = null;
        Connection conn = null;
        Object conn2 = null;
        try {
            int originCount = Util.getCount("concurrencetable", "user1", "password1");
            this.ut.begin();
            conn = Util.getConnection(false, "user1", "password1");
            pStmt = conn.prepareStatement("insert into concurrencetable values(?, ?)");
            pStmt.setInt(1, 99);
            pStmt.setString(2, "Type-99");
            pStmt.addBatch();
            pStmt.setInt(1, 100);
            pStmt.setString(2, "Type-100");
            pStmt.addBatch();
            pStmt.executeBatch();
            TestTransactionWork work = new TestTransactionWork();
            work.setUserName("user1");
            work.setPassword("password1");
            work.setSQLTemplate("insert into concurrencetable values(?, ?)");
            work.needBeginTx(true);
            work.needCommit(true);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("jakarta.enterprise.concurrent.TRANSACTION", "SUSPEND");
            TestWorkInterface proxy = (TestWorkInterface)this.cx.createContextualProxy((Object)work, m, TestWorkInterface.class);
            proxy.doSomeWork();
            this.ut.rollback();
            int afterTransacted = Util.getCount("concurrencetable", "user1", "password1");
            String string = String.valueOf(afterTransacted - originCount);
            return string;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String testSuspendAndRollback() throws ServletException {
        Statement pStmt = null;
        Connection conn = null;
        Object conn2 = null;
        try {
            int originCount = Util.getCount("concurrencetable", "user1", "password1");
            this.ut.begin();
            conn = Util.getConnection(false, "user1", "password1");
            pStmt = conn.prepareStatement("insert into concurrencetable values(?, ?)");
            pStmt.setInt(1, 99);
            pStmt.setString(2, "Type-99");
            pStmt.addBatch();
            pStmt.setInt(1, 100);
            pStmt.setString(2, "Type-100");
            pStmt.addBatch();
            pStmt.executeBatch();
            TestTransactionWork work = new TestTransactionWork();
            work.setUserName("user1");
            work.setPassword("password1");
            work.setSQLTemplate("insert into concurrencetable values(?, ?)");
            work.needBeginTx(true);
            work.needRollback(true);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("jakarta.enterprise.concurrent.TRANSACTION", "SUSPEND");
            TestWorkInterface proxy = (TestWorkInterface)this.cx.createContextualProxy((Object)work, m, TestWorkInterface.class);
            proxy.doSomeWork();
            this.ut.commit();
            int afterTransacted = Util.getCount("concurrencetable", "user1", "password1");
            String string = String.valueOf(afterTransacted - originCount);
            return string;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String testDefaultAndCommit() throws ServletException {
        Statement pStmt = null;
        Connection conn = null;
        Object conn2 = null;
        try {
            int originCount = Util.getCount("concurrencetable", "user1", "password1");
            this.ut.begin();
            conn = Util.getConnection(false, "user1", "password1");
            pStmt = conn.prepareStatement("insert into concurrencetable values(?, ?)");
            pStmt.setInt(1, 99);
            pStmt.setString(2, "Type-99");
            pStmt.addBatch();
            pStmt.setInt(1, 100);
            pStmt.setString(2, "Type-100");
            pStmt.addBatch();
            pStmt.executeBatch();
            TestTransactionWork work = new TestTransactionWork();
            work.setUserName("user1");
            work.setPassword("password1");
            work.setSQLTemplate("insert into concurrencetable values(?, ?)");
            work.needBeginTx(true);
            work.needCommit(true);
            TestWorkInterface proxy = (TestWorkInterface)this.cx.createContextualProxy((Object)work, TestWorkInterface.class);
            proxy.doSomeWork();
            this.ut.rollback();
            int afterTransacted = Util.getCount("concurrencetable", "user1", "password1");
            String string = String.valueOf(afterTransacted - originCount);
            return string;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

