/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.framework;

import ee.jakarta.tck.concurrent.framework.TestLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class URLBuilder {
    private static final TestLogger log = TestLogger.get(URLBuilder.class);
    public static final String TEST_METHOD = "testMethod";
    private URL baseURL;
    private ArrayList<String> queries;
    private ArrayList<String> paths;
    private boolean testNameSet = false;

    private URLBuilder() {
    }

    public static URLBuilder get() {
        return new URLBuilder();
    }

    public URLBuilder withBaseURL(URL baseURL) {
        this.baseURL = baseURL;
        return this;
    }

    public URLBuilder withQueries(String ... queries) {
        if (this.queries == null) {
            this.queries = new ArrayList<String>(Arrays.asList(queries));
        } else {
            this.queries.addAll(Arrays.asList(queries));
        }
        return this;
    }

    public URLBuilder withPaths(String ... paths) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>(Arrays.asList(paths));
        } else {
            this.paths.addAll(Arrays.asList(paths));
        }
        return this;
    }

    public URLBuilder withTestName(String testName) {
        if (this.testNameSet) {
            throw new UnsupportedOperationException("Cannot call withTestName more than once.");
        }
        String query = "testMethod=" + testName;
        if (this.queries == null) {
            this.queries = new ArrayList<String>(Arrays.asList(query));
        } else {
            this.queries.add(query);
        }
        this.testNameSet = true;
        return this;
    }

    public URL build() {
        if (this.baseURL == null) {
            throw new RuntimeException("Cannot build URL without a baseURL");
        }
        log.enter("build", this.baseURL, this.queries, this.paths);
        URL extendedURL = this.baseURL;
        extendedURL = URLBuilder.extendQuery(extendedURL, this.queries);
        extendedURL = URLBuilder.extendPath(extendedURL, this.paths);
        log.exit("build", extendedURL);
        return extendedURL;
    }

    public static URL extendQuery(URL baseURL, List<String> queries) {
        if (queries == null) {
            return baseURL;
        }
        boolean existingQuery = baseURL.getQuery() != null;
        Object extendedQuery = existingQuery ? "?" + baseURL.getQuery() : "?";
        for (String queryPart : queries) {
            extendedQuery = (String)extendedQuery + queryPart + "&";
        }
        extendedQuery = ((String)extendedQuery).substring(0, ((String)extendedQuery).length() - 1);
        try {
            return new URL(baseURL.getProtocol(), baseURL.getHost(), baseURL.getPort(), baseURL.getPath() + (String)extendedQuery, null);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL extendPath(URL baseURL, List<String> paths) {
        if (paths == null) {
            return baseURL;
        }
        boolean existingPath = baseURL.getPath() != null;
        Object extendedPath = existingPath ? baseURL.getPath() : "";
        for (String pathPart : paths) {
            pathPart = pathPart.replace("/", "");
            extendedPath = (String)extendedPath + pathPart + "/";
        }
        extendedPath = ((String)extendedPath).substring(0, ((String)extendedPath).length() - 1);
        try {
            return new URL(baseURL.getProtocol(), baseURL.getHost(), baseURL.getPort(), (String)extendedPath + (String)(baseURL.getQuery() == null ? "" : "?" + baseURL.getQuery()), null);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

