/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.swt;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.view.internal.swt.Activator;
import org.eclipse.emf.ecp.view.internal.swt.DebugViewModelService;
import org.eclipse.emf.ecp.view.internal.swt.ECPAdditionalRendererDescription;
import org.eclipse.emf.ecp.view.internal.swt.ECPRendererDescription;
import org.eclipse.emf.ecp.view.model.common.ECPRendererTester;
import org.eclipse.emf.ecp.view.model.common.ECPStaticRendererTester;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.swt.AbstractAdditionalSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.ECPAdditionalRendererTester;
import org.eclipse.emf.ecp.view.spi.swt.SWTRendererFactory;
import org.eclipse.emf.ecp.view.spi.swt.UnknownVElementSWTRenderer;
import org.osgi.framework.Bundle;

public final class SWTRendererFactoryImpl
implements SWTRendererFactory {
    private static final String TEST_DYNAMIC = "dynamicTest";
    private static final String TEST_STATIC = "staticTest";
    private static final String TESTER_PRIORITY = "priority";
    private static final String TESTER_VELEMENT = "element";
    private static final String RENDERER_TESTER = "testClass";
    private static final String RENDER_EXTENSION = "org.eclipse.emf.ecp.ui.view.swt.renderers";
    private static final String ADDITIONAL_RENDER_EXTENSION = "org.eclipse.emf.ecp.ui.view.swt.additionalRenderers";
    private final Set<ECPRendererDescription> rendererDescriptors = new LinkedHashSet<ECPRendererDescription>();
    private final Set<ECPAdditionalRendererDescription> additionalRendererDescriptors = new LinkedHashSet<ECPAdditionalRendererDescription>();
    private boolean debugMode = false;

    public SWTRendererFactoryImpl() {
        String[] commandLineArgs = Platform.getCommandLineArgs();
        int i = 0;
        while (i < commandLineArgs.length) {
            String arg = commandLineArgs[i];
            if ("-debugEMFForms".equalsIgnoreCase(arg)) {
                this.debugMode = true;
            }
            ++i;
        }
        this.readRenderer();
        this.readAdditionalRenderer();
    }

    private void readRenderer() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(RENDER_EXTENSION);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                try {
                    Class<AbstractSWTRenderer<VElement>> renderer = SWTRendererFactoryImpl.loadClass(configurationElement.getContributor().getName(), configurationElement.getAttribute("renderer"));
                    LinkedHashSet<ECPRendererTester> tester = new LinkedHashSet<ECPRendererTester>();
                    IConfigurationElement[] iConfigurationElementArray2 = configurationElement.getChildren();
                    int n5 = iConfigurationElementArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement testerExtension = iConfigurationElementArray2[n6];
                        if (TEST_DYNAMIC.equals(testerExtension.getName())) {
                            tester.add((ECPRendererTester)testerExtension.createExecutableExtension(RENDERER_TESTER));
                        } else if (TEST_STATIC.equals(testerExtension.getName())) {
                            int priority = Integer.parseInt(testerExtension.getAttribute(TESTER_PRIORITY));
                            String vElement = testerExtension.getAttribute(TESTER_VELEMENT);
                            Class supportedEObject = SWTRendererFactoryImpl.loadClass(testerExtension.getContributor().getName(), vElement);
                            tester.add((ECPRendererTester)new ECPStaticRendererTester(priority, supportedEObject));
                        }
                        ++n6;
                    }
                    this.rendererDescriptors.add(new ECPRendererDescription(renderer, tester));
                }
                catch (CoreException ex) {
                    ex.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InvalidRegistryObjectException e) {
                    e.printStackTrace();
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void readAdditionalRenderer() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ADDITIONAL_RENDER_EXTENSION);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                try {
                    Class<AbstractAdditionalSWTRenderer<VElement>> renderer = SWTRendererFactoryImpl.loadClass(configurationElement.getContributor().getName(), configurationElement.getAttribute("renderer"));
                    ECPAdditionalRendererTester tester = (ECPAdditionalRendererTester)configurationElement.createExecutableExtension("tester");
                    this.additionalRendererDescriptors.add(new ECPAdditionalRendererDescription(renderer, tester));
                }
                catch (CoreException ex) {
                    ex.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InvalidRegistryObjectException e) {
                    e.printStackTrace();
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + bundleName);
        }
        return bundle.loadClass(clazz);
    }

    @Override
    public AbstractSWTRenderer<VElement> getRenderer(VElement vElement, ViewModelContext viewContext) {
        int highestPriority = -1;
        AbstractSWTRenderer<VElement> bestCandidate = null;
        for (ECPRendererDescription description : this.rendererDescriptors) {
            int currentPriority = -1;
            for (ECPRendererTester tester : description.getTester()) {
                int testerPriority = tester.isApplicable(vElement, viewContext);
                if (testerPriority <= currentPriority) continue;
                currentPriority = testerPriority;
            }
            if (currentPriority <= highestPriority) continue;
            highestPriority = currentPriority;
            try {
                bestCandidate = description.getRenderer().newInstance();
            }
            catch (InstantiationException ex) {
                Activator.log(ex);
                return null;
            }
            catch (IllegalAccessException ex) {
                Activator.log(ex);
                return null;
            }
        }
        if (bestCandidate == null && this.showUnknownRenderer(viewContext)) {
            bestCandidate = new UnknownVElementSWTRenderer();
        }
        bestCandidate.init(vElement, viewContext);
        return bestCandidate;
    }

    private boolean showUnknownRenderer(ViewModelContext viewModelContext) {
        return this.debugMode || viewModelContext.hasService(DebugViewModelService.class);
    }

    @Override
    public Collection<AbstractAdditionalSWTRenderer<VElement>> getAdditionalRenderer(VElement vElement, ViewModelContext viewModelContext) {
        LinkedHashSet<AbstractAdditionalSWTRenderer<VElement>> renderers = new LinkedHashSet<AbstractAdditionalSWTRenderer<VElement>>();
        for (ECPAdditionalRendererDescription description : this.additionalRendererDescriptors) {
            ECPAdditionalRendererTester tester = description.getTester();
            if (!tester.isApplicable(vElement, viewModelContext)) continue;
            try {
                AbstractAdditionalSWTRenderer<VElement> renderer = description.getRenderer().newInstance();
                renderer.init(vElement, viewModelContext);
                renderers.add(renderer);
            }
            catch (InstantiationException ex) {
                Activator.log(ex);
            }
            catch (IllegalAccessException ex) {
                Activator.log(ex);
            }
        }
        return renderers;
    }
}

