/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.rule;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.BidirectionalMap;
import org.eclipse.emf.ecp.view.internal.rule.AllEAttributes;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.rule.model.AndCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.Condition;
import org.eclipse.emf.ecp.view.spi.rule.model.LeafCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.OrCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.Rule;
import org.eclipse.emf.ecp.view.spi.rule.model.impl.LeafConditionImpl;

public class RuleRegistry<T extends Rule> {
    private static NoCondition noCondition = new NoCondition();
    private final Map<EStructuralFeature, BidirectionalMap<Condition, T>> featuresToRules = new LinkedHashMap<EStructuralFeature, BidirectionalMap<Condition, T>>();
    private final BidirectionalMap<T, VElement> rulesToRenderables = new BidirectionalMap();

    public Set<EStructuralFeature> register(VElement renderable, T rule, Condition condition, EObject domainModel) {
        LinkedHashSet<EStructuralFeature> registeredFeatures = new LinkedHashSet<EStructuralFeature>();
        if (condition instanceof LeafCondition) {
            LeafCondition leafCondition = (LeafCondition)condition;
            VDomainModelReference domainModelReference = leafCondition.getDomainModelReference();
            if (domainModelReference == null) {
                return registeredFeatures;
            }
            domainModelReference.init(domainModel);
            Iterator featureIterator = domainModelReference.getEStructuralFeatureIterator();
            while (featureIterator.hasNext()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)featureIterator.next();
                this.mapFeatureToRule(eStructuralFeature, (Condition)leafCondition, rule);
                registeredFeatures.add(eStructuralFeature);
            }
            this.rulesToRenderables.put(rule, (Object)renderable);
        } else if (condition instanceof OrCondition) {
            OrCondition orCondition = (OrCondition)condition;
            for (Condition cond : orCondition.getConditions()) {
                registeredFeatures.addAll(this.register(renderable, rule, cond, domainModel));
            }
        } else if (condition instanceof AndCondition) {
            AndCondition andCondition = (AndCondition)condition;
            for (Condition cond : andCondition.getConditions()) {
                registeredFeatures.addAll(this.register(renderable, rule, cond, domainModel));
            }
        } else {
            this.mapFeatureToRule((EStructuralFeature)AllEAttributes.get(), (Condition)noCondition, rule);
            this.rulesToRenderables.put(rule, (Object)renderable);
        }
        return registeredFeatures;
    }

    public VElement removeRule(T rule) {
        Condition condition = rule.getCondition();
        if (condition != null) {
            return this.removeCondition(condition);
        }
        Collection<BidirectionalMap<Condition, T>> values = this.featuresToRules.values();
        for (BidirectionalMap<Condition, T> bidirectionalMap : values) {
            if (bidirectionalMap.removeByValue(rule) != null) break;
        }
        VElement renderable = (VElement)this.rulesToRenderables.getValue(rule);
        this.rulesToRenderables.removeByKey(rule);
        return renderable;
    }

    public void removeRenderable(VElement renderable) {
        this.rulesToRenderables.removeByValue((Object)renderable);
    }

    public VElement removeCondition(Condition condition) {
        BidirectionalMap<Condition, T> bidirectionalMap;
        VElement ret = null;
        if (LeafCondition.class.isInstance(condition)) {
            LeafCondition leafCondition = (LeafCondition)LeafCondition.class.cast(condition);
            Iterator settingIterator = leafCondition.getDomainModelReference().getIterator();
            EStructuralFeature.Setting setting = (EStructuralFeature.Setting)settingIterator.next();
            bidirectionalMap = this.featuresToRules.get(setting.getEStructuralFeature());
        } else {
            bidirectionalMap = this.featuresToRules.get((Object)AllEAttributes.get());
        }
        if (bidirectionalMap != null) {
            Rule removedRule = (Rule)bidirectionalMap.removeByKey((Object)condition);
            ret = (VElement)this.rulesToRenderables.removeByKey((Object)removedRule);
        }
        return ret;
    }

    private void mapFeatureToRule(EStructuralFeature attribute, Condition condition, T rule) {
        if (!this.featuresToRules.containsKey(attribute)) {
            this.featuresToRules.put(attribute, new BidirectionalMap());
        }
        this.featuresToRules.get(attribute).put((Object)condition, rule);
    }

    public Set<EStructuralFeature> getAttributes() {
        return this.featuresToRules.keySet();
    }

    public Map<T, VElement> getAffectedRenderables(EStructuralFeature feature) {
        LinkedHashMap<Rule, VElement> result = new LinkedHashMap<Rule, VElement>();
        BidirectionalMap<Condition, T> bidirectionalMap = this.featuresToRules.get(feature);
        if (bidirectionalMap == null) {
            return Collections.emptyMap();
        }
        for (Rule rule : bidirectionalMap.values()) {
            VElement renderable = (VElement)this.rulesToRenderables.getValue((Object)rule);
            result.put(rule, renderable);
        }
        return result;
    }

    public VElement removeEFeature(EStructuralFeature esf, Condition condition) {
        if (!this.featuresToRules.containsKey(esf)) {
            return null;
        }
        Rule removeByKey = (Rule)this.featuresToRules.get(esf).removeByKey((Object)condition);
        return (VElement)this.rulesToRenderables.removeByKey((Object)removeByKey);
    }

    static class NoCondition
    extends LeafConditionImpl {
        NoCondition() {
        }
    }
}

