/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecp.common.cachetree.AbstractCachedTree;
import org.eclipse.emf.ecp.common.cachetree.CachedTreeNode;
import org.eclipse.emf.ecp.common.cachetree.IExcludedObjectsCallback;
import org.eclipse.emf.ecp.validation.api.IValidationService;

public final class ValidationService
extends AbstractCachedTree<Diagnostic>
implements IValidationService {
    public ValidationService(IExcludedObjectsCallback callback) {
        super(callback);
    }

    @Override
    public Set<EObject> validate(Collection<EObject> eObjects) {
        HashSet<EObject> allAffected = new HashSet<EObject>();
        for (EObject eObject : eObjects) {
            Set<EObject> affected = this.validate(eObject);
            allAffected.addAll(affected);
        }
        return allAffected;
    }

    @Override
    public Set<EObject> validate(EObject eObject) {
        return this.update(eObject, this.getSeverity(eObject));
    }

    @Override
    public Diagnostic getDiagnostic(Object eObject) {
        return (Diagnostic)this.getCachedValue(eObject);
    }

    @Override
    public Diagnostic getRootDiagnostic() {
        return (Diagnostic)this.getRootValue();
    }

    public Diagnostic getDefaultValue() {
        return Diagnostic.OK_INSTANCE;
    }

    public CachedTreeNode<Diagnostic> createdCachedTreeNode(Diagnostic diagnostic) {
        return new CachedSeverityTreeNode(diagnostic);
    }

    private Diagnostic getSeverity(EObject object) {
        EValidator validator = EValidator.Registry.INSTANCE.getEValidator(object.eClass().getEPackage());
        BasicDiagnostic diagnostics = Diagnostician.INSTANCE.createDefaultDiagnostic(object);
        if (validator == null) {
            validator = new EObjectValidator();
        }
        HashMap<Class, Object> context = new HashMap<Class, Object>();
        context.put(EValidator.SubstitutionLabelProvider.class, Diagnostician.INSTANCE);
        context.put(EValidator.class, validator);
        validator.validate(object, (DiagnosticChain)diagnostics, context);
        return diagnostics;
    }

    public class CachedSeverityTreeNode
    extends CachedTreeNode<Diagnostic> {
        public CachedSeverityTreeNode(Diagnostic diagnostic) {
            super((Object)diagnostic);
        }

        public void update() {
            Collection severities = this.values();
            if (severities.size() > 0) {
                Diagnostic mostSevereDiagnostic = (Diagnostic)this.values().iterator().next();
                for (Diagnostic diagnostic : severities) {
                    if (diagnostic.getSeverity() <= mostSevereDiagnostic.getSeverity()) continue;
                    mostSevereDiagnostic = diagnostic;
                }
                this.setChildValue(mostSevereDiagnostic);
                return;
            }
            this.setChildValue(ValidationService.this.getDefaultValue());
        }

        public Diagnostic getDisplayValue() {
            if (this.getChildValue() == null) {
                return (Diagnostic)this.getOwnValue();
            }
            return ((Diagnostic)this.getOwnValue()).getSeverity() > ((Diagnostic)this.getChildValue()).getSeverity() ? (Diagnostic)this.getOwnValue() : (Diagnostic)this.getChildValue();
        }
    }
}

