/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TreeNodeType implements Enumerator
{
    FOLDER(2, "FOLDER", "FOLDER"),
    FILE(1, "FILE", "FILE"),
    PROJECT(3, "PROJECT", "PROJECT"),
    UNKNOWN(0, "UNKNOWN", "UNKNOWN");

    public static final int FOLDER_VALUE = 2;
    public static final int FILE_VALUE = 1;
    public static final int PROJECT_VALUE = 3;
    public static final int UNKNOWN_VALUE = 0;
    private static final TreeNodeType[] VALUES_ARRAY;
    public static final List<TreeNodeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TreeNodeType[]{FOLDER, FILE, PROJECT, UNKNOWN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TreeNodeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TreeNodeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TreeNodeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TreeNodeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TreeNodeType get(int value) {
        switch (value) {
            case 2: {
                return FOLDER;
            }
            case 1: {
                return FILE;
            }
            case 3: {
                return PROJECT;
            }
            case 0: {
                return UNKNOWN;
            }
        }
        return null;
    }

    private TreeNodeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

