/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.context.spy;

import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class ContextSpyProcessor {
    private static final String ORG_ECLIPSE_UI_CONTEXTS_DIALOG_AND_WINDOW = "org.eclipse.ui.contexts.dialogAndWindow";
    private static final String CONTEXT_SPY_SHORTCUT = "M2+M3+F10";
    private static final String E4_SPIES_BINDING_TABLE = "e4.tooling.spies.bindings";
    private static final String CONTEXT_SPY_HANDLER = "e4.tooling.context.spy.handler";
    private static final String CONTEXT_SPY_COMMAND = "e4.tooling.context.spy.command";
    private static final String CONTEXT_SPY_CONTRIBUTOR_URI = "platform:/plugin/org.eclipse.e4.tools.context.spy";
    @Inject
    MApplication application;
    @Inject
    EModelService modelService;

    @PostConstruct
    public void process() {
        MCommand command = null;
        for (MCommand cmd : this.application.getCommands()) {
            if (!CONTEXT_SPY_COMMAND.equals(cmd.getElementId())) continue;
            command = cmd;
            break;
        }
        if (command == null) {
            command = (MCommand)this.modelService.createModelElement(MCommand.class);
            command.setElementId(CONTEXT_SPY_COMMAND);
            command.setCommandName("Show E4 Context Spy");
            command.setContributorURI(CONTEXT_SPY_CONTRIBUTOR_URI);
            command.setDescription("Show the Eclipse 4 contexts and their contents");
            this.application.getCommands().add(command);
        }
        MHandler handler = null;
        for (MHandler hdl : this.application.getHandlers()) {
            if (!CONTEXT_SPY_HANDLER.equals(hdl.getElementId())) continue;
            handler = hdl;
            break;
        }
        if (handler == null) {
            handler = (MHandler)this.modelService.createModelElement(MHandler.class);
            handler.setElementId(CONTEXT_SPY_HANDLER);
            handler.setContributionURI("bundleclass://org.eclipse.e4.tools.context.spy/org.eclipse.e4.tools.context.spy.ContextSpyHandler");
            handler.setContributorURI(CONTEXT_SPY_CONTRIBUTOR_URI);
            this.application.getHandlers().add(handler);
        }
        handler.setCommand(command);
        this.bindSpyKeyBinding(CONTEXT_SPY_SHORTCUT, command);
        MPartDescriptor descriptor = null;
        for (MPartDescriptor mp : this.application.getDescriptors()) {
            if (!"org.eclipse.e4.tools.context.spy.view".equals(mp.getElementId())) continue;
            descriptor = mp;
            break;
        }
        if (descriptor == null) {
            descriptor = (MPartDescriptor)this.modelService.createModelElement(MPartDescriptor.class);
            descriptor.setCategory("org.eclipse.e4.secondaryDataStack");
            descriptor.setElementId("org.eclipse.e4.tools.context.spy.view");
            descriptor.getTags().add("View");
            descriptor.getTags().add("categoryTag:General");
            descriptor.setLabel("Context Spy");
            descriptor.setContributionURI("bundleclass://org.eclipse.e4.tools.context.spy/org.eclipse.e4.tools.context.spy.ContextSpyPart");
            descriptor.setContributorURI(CONTEXT_SPY_CONTRIBUTOR_URI);
            descriptor.setIconURI("platform:/plugin/org.eclipse.e4.tools.context.spy/icons/annotation_obj.gif");
            this.application.getDescriptors().add(descriptor);
        }
    }

    public void bindSpyKeyBinding(String keySequence, MCommand cmd) {
        MBindingTable spyBindingTable = null;
        for (MBindingTable bt : this.application.getBindingTables()) {
            if (!ORG_ECLIPSE_UI_CONTEXTS_DIALOG_AND_WINDOW.equals(bt.getBindingContext().getElementId())) continue;
            spyBindingTable = bt;
        }
        if (spyBindingTable == null) {
            MBindingContext bc = null;
            List bindingContexts = this.application.getBindingContexts();
            if (bindingContexts.size() == 0) {
                bc = (MBindingContext)this.modelService.createModelElement(MBindingContext.class);
                bc.setElementId("org.eclipse.ui.contexts.window");
            } else {
                Iterator iterator = bindingContexts.iterator();
                while (iterator.hasNext()) {
                    MBindingContext aBindingContext;
                    bc = aBindingContext = (MBindingContext)iterator.next();
                    if (ORG_ECLIPSE_UI_CONTEXTS_DIALOG_AND_WINDOW.equals(aBindingContext.getElementId())) break;
                }
            }
            spyBindingTable = (MBindingTable)this.modelService.createModelElement(MBindingTable.class);
            spyBindingTable.setElementId(E4_SPIES_BINDING_TABLE);
            spyBindingTable.setBindingContext(bc);
            this.application.getBindingTables().add(spyBindingTable);
        }
        for (MKeyBinding kb : spyBindingTable.getBindings()) {
            if (!keySequence.equals(kb.getKeySequence())) continue;
            if (kb.getCommand().getElementId().equals(cmd.getElementId())) {
                return;
            }
            System.out.println("WARNING : Cannot bind the command '" + cmd.getElementId() + "' to the keySequence : " + keySequence + " because the command " + kb.getCommand().getElementId() + " is already bound !");
            return;
        }
        MKeyBinding binding = (MKeyBinding)this.modelService.createModelElement(MKeyBinding.class);
        binding.setElementId(String.valueOf(cmd.getElementId()) + ".binding");
        binding.setContributorURI(cmd.getContributorURI());
        binding.setKeySequence(keySequence);
        spyBindingTable.getBindings().add(binding);
        binding.setCommand(cmd);
    }
}

