/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.context.spy;

import java.net.URL;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.internal.tools.context.spy.ContextDataPart;
import org.eclipse.e4.internal.tools.context.spy.ContextSpyHelper;
import org.eclipse.e4.internal.tools.context.spy.ContextSpyProvider;
import org.eclipse.e4.internal.tools.context.spy.search.ContextRegistry;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ContextSpyPart {
    private static final String ICON_COLLAPSEALL = "icons/collapseall.gif";
    private static final String ICON_EXPANDALL = "icons/expandall.gif";
    private static final String ICON_REFRESH = "icons/refresh.gif";
    static final String CONTEXT_SPY_VIEW_DESC = "org.eclipse.e4.tools.context.spy.view";
    private TreeViewer contextTreeViewer;
    @Inject
    private ESelectionService selService;
    private ContextSpyProvider treeContentProvider;
    private ImageRegistry imgReg;
    @Inject
    private ContextRegistry contextRegistry;
    private ContextDataPart contextDataPart;

    @Inject
    private void initializeImageRegistry() {
        Bundle b = FrameworkUtil.getBundle(this.getClass());
        this.imgReg = new ImageRegistry();
        this.imgReg.put(ICON_COLLAPSEALL, ImageDescriptor.createFromURL((URL)b.getEntry(ICON_COLLAPSEALL)));
        this.imgReg.put(ICON_EXPANDALL, ImageDescriptor.createFromURL((URL)b.getEntry(ICON_EXPANDALL)));
        this.imgReg.put(ICON_REFRESH, ImageDescriptor.createFromURL((URL)b.getEntry(ICON_REFRESH)));
    }

    @PostConstruct
    public void createControls(Composite parent, MApplication a, IEclipseContext ctx) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(6, false));
        Button refreshButton = new Button(comp, 0x800000);
        refreshButton.setImage(this.imgReg.get(ICON_REFRESH));
        refreshButton.setToolTipText("Refresh the contexts");
        refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContextSpyPart.this.contextTreeViewer.refresh(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button expandAll = new Button(comp, 0x800000);
        expandAll.setImage(this.imgReg.get(ICON_EXPANDALL));
        expandAll.setToolTipText("Expand context nodes");
        expandAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContextSpyPart.this.contextTreeViewer.expandAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button collapseAll = new Button(comp, 0x800000);
        collapseAll.setImage(this.imgReg.get(ICON_COLLAPSEALL));
        collapseAll.setToolTipText("Collapse context nodes");
        collapseAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContextSpyPart.this.contextTreeViewer.collapseAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Text text = new Text(comp, 640);
        GridDataFactory.fillDefaults().hint(250, -1).applyTo((Control)text);
        text.setMessage("Search data");
        text.setToolTipText("Highlight the contexts where the contained objects match this string pattern.\nYou can use patterns like : *selection*, or *NameOfYourClass*");
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                ContextSpyPart.this.contextRegistry.setPattern(text.getText());
                ContextSpyPart.this.contextTreeViewer.refresh(true);
                ContextSpyPart.this.contextDataPart.refresh(true);
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        final Button ignoreCase = new Button(comp, 32);
        ignoreCase.setText("Ignore case");
        ignoreCase.setToolTipText("Ignore case in the search pattern");
        ignoreCase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContextSpyPart.this.contextRegistry.setIgnoreCase(ignoreCase.getSelection());
                ContextSpyPart.this.contextTreeViewer.refresh(true);
                ContextSpyPart.this.contextDataPart.refresh(true);
            }
        });
        final Button ignoreWildCards = new Button(comp, 32);
        ignoreWildCards.setText("Ignore WildCards");
        ignoreWildCards.setToolTipText("Ignore wildcards in the search pattern");
        ignoreWildCards.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContextSpyPart.this.contextRegistry.setIgnoreWildCards(ignoreWildCards.getSelection());
                ContextSpyPart.this.contextTreeViewer.refresh(true);
                ContextSpyPart.this.contextDataPart.refresh(true);
            }
        });
        SashForm sashForm = new SashForm(parent, 768);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.contextTreeViewer = new TreeViewer((Composite)sashForm);
        this.treeContentProvider = (ContextSpyProvider)((Object)ContextInjectionFactory.make(ContextSpyProvider.class, (IEclipseContext)ctx));
        this.contextTreeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.contextTreeViewer.setLabelProvider((IBaseLabelProvider)this.treeContentProvider);
        this.contextTreeViewer.setSorter(new ViewerSorter());
        this.contextTreeViewer.setInput(ContextSpyHelper.getAllBundleContexts());
        this.contextTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                ContextSpyPart.this.selService.setSelection((Object)(ss.size() == 1 ? ss.getFirstElement() : ss.toArray()));
            }
        });
        IEclipseContext subCtx = ctx.createChild("Context for ContextDataPart");
        subCtx.set(Composite.class, (Object)sashForm);
        this.contextDataPart = (ContextDataPart)ContextInjectionFactory.make(ContextDataPart.class, (IEclipseContext)subCtx);
        sashForm.setWeights(new int[]{35, 65});
        this.contextTreeViewer.expandAll();
    }

    @PreDestroy
    public void dispose() {
    }

    @Focus
    public void setFocus() {
        this.contextTreeViewer.getControl().setFocus();
    }
}

