/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractArchiveResourceSet;
import org.apache.catalina.webresources.JarResource;
import org.apache.tomcat.util.buf.UriUtil;

public class JarResourceSet
extends AbstractArchiveResourceSet {
    public JarResourceSet() {
    }

    public JarResourceSet(WebResourceRoot root, String webAppMount, String base, String internalPath) throws IllegalArgumentException {
        this.setRoot(root);
        this.setWebAppMount(webAppMount);
        this.setBase(base);
        this.setInternalPath(internalPath);
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    protected WebResource createArchiveResource(JarEntry jarEntry, String webAppPath, Manifest manifest) {
        return new JarResource(this, webAppPath, this.getBaseUrlString(), jarEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HashMap<String, JarEntry> getArchiveEntries(boolean single) {
        Object object = this.archiveLock;
        synchronized (object) {
            if (this.archiveEntries == null && !single) {
                JarFile jarFile = null;
                this.archiveEntries = new HashMap();
                try {
                    jarFile = this.openJarFile();
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        this.archiveEntries.put(entry.getName(), entry);
                    }
                }
                catch (IOException ioe) {
                    this.archiveEntries = null;
                    throw new IllegalStateException(ioe);
                }
                finally {
                    if (jarFile != null) {
                        this.closeJarFile();
                    }
                }
            }
            return this.archiveEntries;
        }
    }

    @Override
    protected JarEntry getArchiveEntry(String pathInArchive) {
        JarFile jarFile = null;
        try {
            jarFile = this.openJarFile();
            JarEntry jarEntry = jarFile.getJarEntry(pathInArchive);
            return jarEntry;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        finally {
            if (jarFile != null) {
                this.closeJarFile();
            }
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        try (JarFile jarFile = new JarFile(this.getBase());){
            this.setManifest(jarFile.getManifest());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
        try {
            this.setBaseUrl(UriUtil.buildJarSafeUrl(new File(this.getBase())));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

