/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.js;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.RuntimeActivator;
import org.eclipse.dirigible.runtime.js.JavaScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.IJavaScriptEngineExecutor;
import org.eclipse.dirigible.runtime.scripting.IJavaScriptEngineProvider;
import org.eclipse.dirigible.runtime.scripting.IJavaScriptExecutor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

class JavaScriptExecutorFactoryOSGi {
    private static final Logger logger = Logger.getLogger(JavaScriptExecutorFactoryOSGi.class);
    private static Map<String, IJavaScriptEngineProvider> javaScriptEngineProviders = Collections.synchronizedMap(new HashMap());
    private static boolean registered = false;

    JavaScriptExecutorFactoryOSGi() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerJavaScriptEngineProviders() {
        Class<JavaScriptExecutorFactoryOSGi> clazz = JavaScriptExecutorFactoryOSGi.class;
        synchronized (JavaScriptExecutorFactoryOSGi.class) {
            if (registered) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                BundleContext context = RuntimeActivator.getContext();
                Collection serviceReferences = context.getServiceReferences(IJavaScriptEngineProvider.class, null);
                for (ServiceReference serviceReference : serviceReferences) {
                    IJavaScriptEngineProvider javaScriptEngineProvider = (IJavaScriptEngineProvider)context.getService(serviceReference);
                    javaScriptEngineProviders.put(javaScriptEngineProvider.getType(), javaScriptEngineProvider);
                }
            }
            catch (InvalidSyntaxException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            registered = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static IJavaScriptEngineExecutor createExecutor(String type, JavaScriptExecutor javaScriptExecutor) throws IOException {
        JavaScriptExecutorFactoryOSGi.registerJavaScriptEngineProviders();
        IJavaScriptEngineProvider javascriptEngineProvider = javaScriptEngineProviders.get(type);
        IJavaScriptEngineExecutor javacriptExecutor = javascriptEngineProvider.create((IJavaScriptExecutor)javaScriptExecutor);
        return javacriptExecutor;
    }
}

