/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Xml2JsonUtils {
    private static final String CDATA_CLOSE = "]]>";
    private static final String CDATA_OPEN = "<![CDATA[";
    private static final String ESQ = "=\"";
    private static final String SPACE = " ";
    private static final String EQ = "\"";
    private static final String EMPTY = "";
    private static final String ATTR_TEXT = "#text";
    private static final String ATTR_CDATA = "#cdata-section";
    private static final String LTS = "</";
    private static final String GT = ">";
    private static final String LT = "<";
    static List<Object> ADDED_BY_VALUE = new ArrayList<Object>();
    static Map<String, JsonElement> REORGANIZED = new HashMap<String, JsonElement>();

    public static String toJson(String xml) throws ParserConfigurationException, SAXException, IOException {
        JsonObject rootJson = new JsonObject();
        DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = dBuilder.parse(new InputSource(new StringReader(xml)));
        if (doc.hasChildNodes()) {
            Xml2JsonUtils.traverseNode(doc, rootJson, null);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        String json = gson.toJson((JsonElement)rootJson);
        return json;
    }

    private static void traverseNode(Node parentNode, JsonObject parentJson, JsonObject upperJson) {
        NodeList childList = parentNode.getChildNodes();
        int i = 0;
        while (i < childList.getLength()) {
            JsonObject childJson = new JsonObject();
            Node childNode = childList.item(i);
            if (childNode.getNodeType() == 3) {
                if (childNode.getNodeValue().trim().length() != 0) {
                    Xml2JsonUtils.processTextNode(parentNode, upperJson, childJson, childNode);
                }
            } else if (childNode.getNodeType() == 1) {
                if (childNode.hasAttributes()) {
                    Xml2JsonUtils.traverseAttributes(childJson, childNode);
                }
                if (childNode.hasChildNodes()) {
                    Xml2JsonUtils.traverseNode(childNode, childJson, parentJson);
                }
                if (childNode.getNodeType() != 3) {
                    JsonElement existing;
                    if (ADDED_BY_VALUE.contains(childNode)) {
                        if (parentJson.has(childNode.getNodeName())) {
                            Iterator attrs;
                            existing = parentJson.get(childNode.getNodeName());
                            if (existing instanceof JsonPrimitive) {
                                attrs = childJson.entrySet().iterator();
                                if (attrs.hasNext()) {
                                    Xml2JsonUtils.reorganizeForAttributes(parentJson, childNode, existing, attrs);
                                }
                            } else if (existing instanceof JsonArray) {
                                attrs = childJson.entrySet().iterator();
                                if (attrs.hasNext()) {
                                    Xml2JsonUtils.reorganizeAddAttributes(childNode, attrs);
                                }
                            } else if (existing instanceof JsonObject) {
                                System.err.println("ERROR: found object, but expected primitive or array");
                            }
                        } else {
                            System.err.println("ERROR: expected element, but it does not exist");
                        }
                        ADDED_BY_VALUE.remove(childNode);
                    } else if (parentJson.has(childNode.getNodeName())) {
                        existing = parentJson.get(childNode.getNodeName());
                        if (existing instanceof JsonArray) {
                            ((JsonArray)existing).add((JsonElement)childJson);
                        } else if (existing instanceof JsonObject) {
                            Xml2JsonUtils.reorganizeElement(parentNode, parentJson, childJson, childNode, existing);
                        }
                    } else {
                        parentJson.add(childNode.getNodeName(), (JsonElement)childJson);
                    }
                }
            } else if (childNode.getNodeType() == 4) {
                String base64 = Base64.getEncoder().encodeToString(childNode.getNodeValue().getBytes());
                parentJson.addProperty(childNode.getNodeName(), base64);
            } else {
                System.err.println("ERROR: unsupported node type: " + childNode.getNodeType());
            }
            ++i;
        }
    }

    private static void processTextNode(Node parentNode, JsonObject upperJson, JsonObject childJson, Node childNode) {
        if (upperJson.has(parentNode.getNodeName())) {
            JsonElement existing = upperJson.get(parentNode.getNodeName());
            if (existing instanceof JsonArray) {
                ((JsonArray)existing).add((JsonElement)new JsonPrimitive(childNode.getNodeValue()));
                REORGANIZED.put(String.valueOf(parentNode.hashCode()), (JsonElement)childJson);
            } else if (existing instanceof JsonObject) {
                Xml2JsonUtils.reorganizeObjectToArray(parentNode, upperJson, childJson, childNode, existing);
            } else {
                Xml2JsonUtils.reorganizePrimitiveToArray(parentNode, upperJson, childJson, childNode, existing);
            }
        } else {
            upperJson.addProperty(parentNode.getNodeName(), childNode.getNodeValue());
        }
        ADDED_BY_VALUE.add(parentNode);
    }

    private static void reorganizeElement(Node parentNode, JsonObject parentJson, JsonObject childJson, Node childNode, JsonElement existing) {
        parentJson.remove(childNode.getNodeName());
        JsonArray arrayJson = new JsonArray();
        arrayJson.add(existing);
        arrayJson.add((JsonElement)childJson);
        parentJson.add(childNode.getNodeName(), (JsonElement)arrayJson);
    }

    private static void reorganizeObjectToArray(Node parentNode, JsonObject upperJson, JsonObject childJson, Node childNode, JsonElement existing) {
        upperJson.remove(parentNode.getNodeName());
        JsonArray arrayJson = new JsonArray();
        arrayJson.add(existing);
        childJson.addProperty(childNode.getNodeName(), childNode.getNodeValue());
        arrayJson.add((JsonElement)childJson);
        upperJson.add(parentNode.getNodeName(), (JsonElement)arrayJson);
        REORGANIZED.put(String.valueOf(parentNode.hashCode()), (JsonElement)childJson);
    }

    private static void reorganizePrimitiveToArray(Node parentNode, JsonObject upperJson, JsonObject childJson, Node childNode, JsonElement existing) {
        upperJson.remove(parentNode.getNodeName());
        JsonArray arrayJson = new JsonArray();
        arrayJson.add(existing);
        arrayJson.add((JsonElement)new JsonPrimitive(childNode.getNodeValue()));
        upperJson.add(parentNode.getNodeName(), (JsonElement)arrayJson);
        REORGANIZED.put(String.valueOf(parentNode.hashCode()), (JsonElement)childJson);
    }

    private static void reorganizeAddAttributes(Node childNode, Iterator attrs) {
        JsonElement reorganizedJson = REORGANIZED.get(String.valueOf(childNode.hashCode()));
        if (reorganizedJson instanceof JsonObject) {
            JsonObject objectJson = (JsonObject)reorganizedJson;
            while (attrs.hasNext()) {
                Map.Entry entry = (Map.Entry)attrs.next();
                objectJson.addProperty(entry.getKey().toString(), entry.getValue().toString().replace(EQ, EMPTY));
            }
        } else {
            System.err.println("ERROR: expected object, found element or null");
        }
        REORGANIZED.remove(String.valueOf(childNode.hashCode()));
    }

    private static void reorganizeForAttributes(JsonObject parentJson, Node childNode, JsonElement existing, Iterator attrs) {
        parentJson.remove(childNode.getNodeName());
        JsonObject objectJson = new JsonObject();
        objectJson.addProperty(ATTR_TEXT, ((JsonPrimitive)existing).getAsString());
        while (attrs.hasNext()) {
            Map.Entry entry = (Map.Entry)attrs.next();
            objectJson.addProperty(entry.getKey().toString(), entry.getValue().toString().replace(EQ, EMPTY));
        }
        parentJson.add(childNode.getNodeName(), (JsonElement)objectJson);
    }

    private static void traverseAttributes(JsonObject childJson, Node childNode) {
        NamedNodeMap attrNodeMap = childNode.getAttributes();
        int j = 0;
        while (j < attrNodeMap.getLength()) {
            Node attrNode = attrNodeMap.item(j);
            childJson.addProperty("-" + attrNode.getNodeName(), attrNode.getNodeValue());
            ++j;
        }
    }

    public static String toXml(String json) {
        JsonParser parser = new JsonParser();
        JsonElement rootJson = parser.parse(json);
        StringBuffer buff = new StringBuffer();
        Xml2JsonUtils.serializeObjectAsXml((JsonObject)rootJson, buff);
        return buff.toString();
    }

    private static void serializeObjectAsXml(JsonObject objectJson, StringBuffer buff) {
        for (Map.Entry entry : objectJson.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JsonObject) {
                buff.append(LT).append(key);
                Xml2JsonUtils.serializeObjectAttributes((JsonObject)value, buff);
                buff.append(GT);
                Xml2JsonUtils.serializeObjectAsXml((JsonObject)value, buff);
                buff.append(LTS).append(key).append(GT);
                continue;
            }
            if (value instanceof JsonArray) {
                Xml2JsonUtils.serializeArrayAsXml(buff, key, value);
                continue;
            }
            if (value instanceof JsonPrimitive) {
                if (ATTR_TEXT.equals(key)) {
                    buff.append(value.toString().replace(EQ, EMPTY));
                    continue;
                }
                if (ATTR_CDATA.equals(key)) {
                    buff.append(CDATA_OPEN).append(new String(Base64.getDecoder().decode(value.toString().replace(EQ, EMPTY)))).append(CDATA_CLOSE);
                    continue;
                }
                if (key.toString().startsWith("-")) continue;
                buff.append(LT).append(key.toString()).append(GT).append(value.toString().replace(EQ, EMPTY)).append(LTS).append(key.toString()).append(GT);
                continue;
            }
            System.err.println("ERROR: unhandled element");
        }
    }

    private static void serializeObjectAttributes(JsonObject objectJson, StringBuffer buff) {
        for (Map.Entry entry : objectJson.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof JsonPrimitive) || !key.toString().startsWith("-")) continue;
            buff.append(SPACE).append(key.toString().substring(1)).append(ESQ).append(value.toString().replace(EQ, EMPTY)).append(EQ);
        }
    }

    private static void serializeArrayAsXml(StringBuffer buff, Object key, Object value) {
        JsonArray array = (JsonArray)value;
        int i = 0;
        while (i < array.size()) {
            JsonElement elementJson = array.get(i);
            if (elementJson instanceof JsonObject) {
                buff.append(LT).append(key);
                Xml2JsonUtils.serializeObjectAttributes((JsonObject)elementJson, buff);
                buff.append(GT);
                Xml2JsonUtils.serializeObjectAsXml((JsonObject)elementJson, buff);
                buff.append(LTS).append(key).append(GT);
            } else if (elementJson instanceof JsonArray) {
                Xml2JsonUtils.serializeArrayAsXml(buff, key, elementJson);
            } else if (elementJson instanceof JsonPrimitive) {
                JsonPrimitive elementPrimitive = (JsonPrimitive)elementJson;
                if (ATTR_TEXT.equals(key)) {
                    buff.append(elementPrimitive.toString().replace(EQ, EMPTY));
                } else if (ATTR_CDATA.equals(key)) {
                    buff.append(CDATA_OPEN).append(new String(Base64.getDecoder().decode(elementPrimitive.toString().replace(EQ, EMPTY)))).append(CDATA_CLOSE);
                } else {
                    buff.append(LT).append(key);
                    buff.append(GT);
                    buff.append(elementPrimitive.toString().replace(EQ, EMPTY));
                    buff.append(LTS).append(key).append(GT);
                }
            }
            ++i;
        }
    }

    public String prettyPrintXml(String xml) throws TransformerFactoryConfigurationError, ParserConfigurationException, SAXException, IOException, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StreamResult result = new StreamResult(new StringWriter());
        DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = dBuilder.parse(new InputSource(new StringReader(xml)));
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    public String prettyPrintJson(String xml) {
        return null;
    }
}

