/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.content;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.db.init.DBRepositoryInitializer;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.task.IRunnableTask;
import org.eclipse.dirigible.runtime.task.TaskManagerShort;

public class DBInitializerServlet
extends HttpServlet {
    private static final long serialVersionUID = 6468050094756163896L;
    private static final Logger logger = Logger.getLogger(DBInitializerServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void registerInitRegister() {
        TaskManagerShort.getInstance().registerRunnableTask((IRunnableTask)new DBInitializerRegister(this));
        logger.info("Database Initializer Register has been registered");
    }

    private boolean initDefaultDatabaseContent(HttpServletRequest request) throws ServletException {
        boolean bl;
        block6: {
            DataSource dataSource = DataSourceFacade.getInstance().getDataSource(request);
            Connection connection = dataSource.getConnection();
            try {
                boolean result;
                DBRepositoryInitializer dbRepositoryInitializer = new DBRepositoryInitializer(dataSource, connection, false);
                bl = result = dbRepositoryInitializer.initialize();
                if (connection == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ServletException("Initializing local database for Repository use failed", (Throwable)e);
                }
            }
            connection.close();
        }
        return bl;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.initDefaultDatabaseContent(req);
    }

    class DBInitializerRegister
    implements IRunnableTask {
        DBInitializerServlet contentInitializerServlet;

        DBInitializerRegister(DBInitializerServlet contentInitializerServlet) {
            this.contentInitializerServlet = contentInitializerServlet;
        }

        public String getName() {
            return "Database Initializer Register";
        }

        public void start() {
            boolean ok = false;
            try {
                ok = DBInitializerServlet.this.initDefaultDatabaseContent(null);
            }
            catch (ServletException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (ok) {
                TaskManagerShort.getInstance().unregisterRunnableTask((IRunnableTask)this);
                logger.info("Database Initializer Register has been un-registered");
            }
        }
    }
}

