/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.scripting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.dirigible.repository.ext.generation.IGenerationService;
import org.eclipse.dirigible.repository.ext.generation.IGenerationWorker;
import org.eclipse.dirigible.repository.ext.generation.IGenerationWorkerProvider;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.RuntimeActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class GenerationService
implements IGenerationService {
    private static final Logger logger = Logger.getLogger(GenerationService.class);
    static List<IGenerationWorkerProvider> generationWorkerProviders = new ArrayList<IGenerationWorkerProvider>();

    static {
        GenerationService.registerServices();
    }

    private static void registerServices() {
        try {
            BundleContext context = RuntimeActivator.getContext();
            GenerationService.registerGenerationWorkerProviders(context);
        }
        catch (InvalidSyntaxException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void registerGenerationWorkerProviders(BundleContext context) throws InvalidSyntaxException {
        logger.info("Registering Generation Worker Providers...");
        Collection serviceReferences = context.getServiceReferences(IGenerationWorkerProvider.class, null);
        for (ServiceReference serviceReference : serviceReferences) {
            IGenerationWorkerProvider generationWorkerProvider = (IGenerationWorkerProvider)context.getService(serviceReference);
            generationWorkerProviders.add(generationWorkerProvider);
            logger.info(String.format("%s added to the list of available Repository Providers", generationWorkerProvider.getType()));
        }
    }

    public IGenerationWorker getGenerationWorker(String type, HttpServletRequest request) {
        try {
            if (generationWorkerProviders.isEmpty()) {
                GenerationService.registerServices();
            }
            for (IGenerationWorkerProvider provider : generationWorkerProviders) {
                if (!provider.getType().equals(type)) continue;
                return provider.createWorker(request);
            }
        }
        catch (InvalidSyntaxException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String[] getGenerationWorkerTypes() {
        ArrayList<String> types = new ArrayList<String>();
        try {
            if (generationWorkerProviders.isEmpty()) {
                GenerationService.registerServices();
            }
            for (IGenerationWorkerProvider provider : generationWorkerProviders) {
                types.add(provider.getType());
            }
            return types.toArray(new String[0]);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

