/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.dirigible.repository.api.ContentTypeHelper;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;

public class ZipImporter {
    private static final Logger logger = Logger.getLogger(ZipImporter.class);

    public static void importZip(IRepository repository, ZipInputStream zipInputStream, String relativeRoot) throws IOException {
        ZipImporter.importZip(repository, zipInputStream, relativeRoot, false);
    }

    public static void importZip(IRepository repository, ZipInputStream zipInputStream, String relativeRoot, boolean override) throws IOException {
        ZipImporter.importZip(repository, zipInputStream, relativeRoot, override, false);
    }

    public static void importZip(IRepository repository, ZipInputStream zipInputStream, String relativeRoot, boolean override, boolean excludeRootFolderName) throws IOException {
        ZipImporter.importZip(repository, zipInputStream, relativeRoot, override, excludeRootFolderName, null);
    }

    public static void importZip(IRepository repository, ZipInputStream zipInputStream, String relativeRoot, boolean override, boolean excludeRootFolderName, Map<String, String> filter) throws IOException {
        logger.debug("importZip started...");
        try {
            ZipEntry entry;
            String parentFolder = null;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (excludeRootFolderName && parentFolder == null) {
                    parentFolder = entry.getName();
                    logger.debug("importZip parentFolder: " + parentFolder);
                    continue;
                }
                String entryName = ZipImporter.getEntryName(entry, parentFolder, excludeRootFolderName);
                logger.debug("importZip entryName: " + entryName);
                String outpath = String.valueOf(relativeRoot) + (relativeRoot.endsWith("/") ? "" : "/") + entryName;
                logger.debug("importZip outpath: " + outpath);
                if (filter != null) {
                    for (Map.Entry<String, String> forReplacement : filter.entrySet()) {
                        outpath = outpath.replace(forReplacement.getKey(), forReplacement.getValue());
                    }
                }
                logger.debug("importZip outpath replaced: " + outpath);
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                try {
                    IOUtils.copy((InputStream)zipInputStream, (OutputStream)output);
                    try {
                        if (output.toByteArray().length > 0) {
                            String extension = ContentTypeHelper.getExtension((String)entry.getName());
                            String mimeType = ContentTypeHelper.getContentType((String)extension);
                            boolean isBinary = ContentTypeHelper.isBinary((String)mimeType);
                            if (mimeType != null) {
                                logger.debug("importZip creating resource: " + outpath);
                                logger.debug("importZip creating resource is binary?: " + isBinary);
                                repository.createResource(outpath, output.toByteArray(), isBinary, mimeType, override);
                                continue;
                            }
                            logger.debug("importZip creating resource: " + outpath);
                            repository.createResource(outpath, output.toByteArray(), true, "application/octet-stream", override);
                            continue;
                        }
                        if (!outpath.endsWith("/")) continue;
                        logger.debug("importZip creating collection: " + outpath);
                        repository.createCollection(outpath);
                    }
                    catch (Exception e) {
                        logger.error(String.format("Error importing %s", outpath), (Throwable)e);
                    }
                }
                finally {
                    output.close();
                }
            }
        }
        finally {
            zipInputStream.close();
        }
        logger.debug("importZip ended.");
    }

    private static String getEntryName(ZipEntry entry, String parentFolder, boolean excludeParentFolder) {
        return excludeParentFolder ? entry.getName().substring(parentFolder.length()) : entry.getName();
    }
}

