/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.rcp;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IEntityInformation;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.repository.rcp.Messages;
import org.eclipse.dirigible.repository.rcp.RCPBaseException;
import org.eclipse.dirigible.repository.rcp.RCPCollection;
import org.eclipse.dirigible.repository.rcp.RCPEntityInformation;
import org.eclipse.dirigible.repository.rcp.RCPObject;
import org.eclipse.dirigible.repository.rcp.RCPRepository;

public abstract class RCPEntity
implements IEntity {
    private static final String THERE_IS_NO_ENTITY_AT_PATH_0 = Messages.getString("DBEntity.THERE_IS_NO_ENTITY_AT_PATH_0");
    private static final Logger logger = Logger.getLogger(RCPEntity.class);
    private final RCPRepository repository;
    private final RepositoryPath path;

    public RCPEntity(RCPRepository repository, RepositoryPath path) {
        this.repository = repository;
        this.path = path;
    }

    public RCPRepository getRepository() {
        return this.repository;
    }

    protected RepositoryPath getRepositoryPath() {
        return this.path;
    }

    public String getName() {
        return this.path.getLastSegment();
    }

    public String getPath() {
        return this.path.toString();
    }

    public ICollection getParent() {
        RepositoryPath parentPath = this.path.getParentPath();
        if (parentPath == null) {
            return null;
        }
        return new RCPCollection(this.repository, parentPath);
    }

    public IEntityInformation getInformation() throws IOException {
        return new RCPEntityInformation(this.path, this.getRCPObjectSafe());
    }

    protected RCPObject getRCPObject() {
        try {
            return this.repository.getRepositoryDAO().getObjectByPath(this.getPath());
        }
        catch (RCPBaseException ex) {
            logger.error(ex.getMessage(), (Throwable)((Object)ex));
            return null;
        }
    }

    protected RCPObject getRCPObjectSafe() throws IOException {
        RCPObject result = this.getRCPObject();
        if (result == null) {
            throw new IOException(MessageFormat.format(THERE_IS_NO_ENTITY_AT_PATH_0, this.path.toString()));
        }
        return result;
    }

    protected void createAncestorsIfMissing() throws IOException {
        ICollection parent = this.getParent();
        if (parent != null && !parent.exists()) {
            parent.create();
        }
    }

    protected void createAncestorsAndSelfIfMissing() throws IOException {
        this.createAncestorsIfMissing();
        if (!this.exists()) {
            this.create();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RCPEntity)) {
            return false;
        }
        RCPEntity other = (RCPEntity)obj;
        return this.getPath().equals(other.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }
}

